/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.FirebaseApp;
import com.google.firebase.StartupTime;
import com.google.firebase.perf.FirebasePerformanceInitializer;
import com.google.firebase.perf.application.AppStateMonitor;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.metrics.AppStartTrace;
import com.google.firebase.perf.session.PerfSession;
import com.google.firebase.perf.session.SessionManager;
import com.google.firebase.sessions.FirebaseSessions;
import com.google.firebase.sessions.api.SessionSubscriber;
import java.util.concurrent.Executor;

public class FirebasePerfEarly {
    public FirebasePerfEarly(FirebaseApp app, FirebaseSessions firebaseSessions, @Nullable StartupTime startupTime, Executor uiExecutor) {
        Context context = app.getApplicationContext();
        final ConfigResolver configResolver = ConfigResolver.getInstance();
        configResolver.setApplicationContext(context);
        AppStateMonitor appStateMonitor = AppStateMonitor.getInstance();
        appStateMonitor.registerActivityLifecycleCallbacks(context);
        appStateMonitor.registerForAppColdStart(new FirebasePerformanceInitializer());
        if (startupTime != null) {
            AppStartTrace appStartTrace = AppStartTrace.getInstance();
            appStartTrace.registerActivityLifecycleCallbacks(context);
            uiExecutor.execute(new AppStartTrace.StartFromBackgroundRunnable(appStartTrace));
        }
        firebaseSessions.register(new SessionSubscriber(){

            public void onSessionChanged(@NonNull SessionSubscriber.SessionDetails sessionDetails) {
                PerfSession perfSession = PerfSession.createWithId(sessionDetails.getSessionId());
                SessionManager.getInstance().updatePerfSession(perfSession);
            }

            public boolean isDataCollectionEnabled() {
                if (!configResolver.isCollectionEnabledConfigValueAvailable()) {
                    return false;
                }
                return ConfigResolver.getInstance().isPerformanceMonitoringEnabled();
            }

            @NonNull
            public SessionSubscriber.Name getSessionSubscriberName() {
                return SessionSubscriber.Name.PERFORMANCE;
            }
        });
        SessionManager.getInstance().initializeGaugeCollection();
    }
}

