/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.firebase.FirebaseApp;
import com.google.firebase.StartupTime;
import com.google.firebase.perf.FirebasePerformanceInitializer;
import com.google.firebase.perf.application.AppStateMonitor;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.metrics.AppStartTrace;
import com.google.firebase.perf.session.SessionManager;
import java.util.concurrent.Executor;

public class FirebasePerfEarly {
    public FirebasePerfEarly(FirebaseApp app, @Nullable StartupTime startupTime, Executor uiExecutor) {
        Context context = app.getApplicationContext();
        ConfigResolver configResolver = ConfigResolver.getInstance();
        configResolver.setApplicationContext(context);
        AppStateMonitor appStateMonitor = AppStateMonitor.getInstance();
        appStateMonitor.registerActivityLifecycleCallbacks(context);
        appStateMonitor.registerForAppColdStart(new FirebasePerformanceInitializer());
        if (startupTime != null) {
            AppStartTrace appStartTrace = AppStartTrace.getInstance();
            appStartTrace.registerActivityLifecycleCallbacks(context);
            uiExecutor.execute(new AppStartTrace.StartFromBackgroundRunnable(appStartTrace));
        }
        SessionManager.getInstance().initializeGaugeCollection();
    }
}

