/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import com.google.firebase.sessions.DaggerFirebaseSessionsComponent;
import com.google.firebase.sessions.FirebaseSessions;
import com.google.firebase.sessions.FirebaseSessionsComponent;
import com.google.firebase.sessions.FirebaseSessionsRegistrar;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0001\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a0\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0014\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00050\u0004H\u0016\u00a8\u0006\t"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsRegistrar;", "Lcom/google/firebase/components/ComponentRegistrar;", "()V", "getComponents", "", "Lcom/google/firebase/components/Component;", "", "kotlin.jvm.PlatformType", "Companion", "com.google.firebase-firebase-sessions"})
@Keep
public final class FirebaseSessionsRegistrar
implements ComponentRegistrar {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    public static final String TAG = "FirebaseSessions";
    @Deprecated
    @NotNull
    public static final String LIBRARY_NAME = "fire-sessions";
    @NotNull
    private static final Qualified<Context> appContext;
    @NotNull
    private static final Qualified<FirebaseApp> firebaseApp;
    @NotNull
    private static final Qualified<FirebaseInstallationsApi> firebaseInstallationsApi;
    @NotNull
    private static final Qualified<CoroutineDispatcher> backgroundDispatcher;
    @NotNull
    private static final Qualified<CoroutineDispatcher> blockingDispatcher;
    @NotNull
    private static final Qualified<TransportFactory> transportFactory;
    @NotNull
    private static final Qualified<FirebaseSessionsComponent> firebaseSessionsComponent;

    @NotNull
    public List<Component<? extends Object>> getComponents() {
        Object[] objectArray = new Component[]{Component.builder(FirebaseSessions.class).name(LIBRARY_NAME).add(Dependency.required(firebaseSessionsComponent)).factory(FirebaseSessionsRegistrar::getComponents$lambda$0).eagerInDefaultApp().build(), Component.builder(FirebaseSessionsComponent.class).name("fire-sessions-component").add(Dependency.required(appContext)).add(Dependency.required(backgroundDispatcher)).add(Dependency.required(blockingDispatcher)).add(Dependency.required(firebaseApp)).add(Dependency.required(firebaseInstallationsApi)).add(Dependency.requiredProvider(transportFactory)).factory(FirebaseSessionsRegistrar::getComponents$lambda$1).build(), LibraryVersionComponent.create((String)LIBRARY_NAME, (String)"2.1.0")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final FirebaseSessions getComponents$lambda$0(ComponentContainer container) {
        return ((FirebaseSessionsComponent)container.get(firebaseSessionsComponent)).getFirebaseSessions();
    }

    private static final FirebaseSessionsComponent getComponents$lambda$1(ComponentContainer container) {
        FirebaseSessionsComponent.Builder builder = DaggerFirebaseSessionsComponent.builder();
        Object object = container.get(appContext);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"container[appContext]");
        FirebaseSessionsComponent.Builder builder2 = builder.appContext((Context)object);
        Object object2 = container.get(backgroundDispatcher);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"container[backgroundDispatcher]");
        FirebaseSessionsComponent.Builder builder3 = builder2.backgroundDispatcher((CoroutineContext)object2);
        Object object3 = container.get(blockingDispatcher);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"container[blockingDispatcher]");
        FirebaseSessionsComponent.Builder builder4 = builder3.blockingDispatcher((CoroutineContext)object3);
        Object object4 = container.get(firebaseApp);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"container[firebaseApp]");
        FirebaseSessionsComponent.Builder builder5 = builder4.firebaseApp((FirebaseApp)object4);
        Object object5 = container.get(firebaseInstallationsApi);
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"container[firebaseInstallationsApi]");
        FirebaseSessionsComponent.Builder builder6 = builder5.firebaseInstallationsApi((FirebaseInstallationsApi)object5);
        Provider provider = container.getProvider(transportFactory);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"container.getProvider(transportFactory)");
        return builder6.transportFactoryProvider((Provider<TransportFactory>)provider).build();
    }

    static {
        Qualified qualified = Qualified.unqualified(Context.class);
        Intrinsics.checkNotNullExpressionValue((Object)qualified, (String)"unqualified(Context::class.java)");
        appContext = qualified;
        Qualified qualified2 = Qualified.unqualified(FirebaseApp.class);
        Intrinsics.checkNotNullExpressionValue((Object)qualified2, (String)"unqualified(FirebaseApp::class.java)");
        firebaseApp = qualified2;
        Qualified qualified3 = Qualified.unqualified(FirebaseInstallationsApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)qualified3, (String)"unqualified(FirebaseInstallationsApi::class.java)");
        firebaseInstallationsApi = qualified3;
        Qualified qualified4 = Qualified.qualified(Background.class, CoroutineDispatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)qualified4, (String)"qualified(Background::cl\u2026neDispatcher::class.java)");
        backgroundDispatcher = qualified4;
        Qualified qualified5 = Qualified.qualified(Blocking.class, CoroutineDispatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)qualified5, (String)"qualified(Blocking::clas\u2026neDispatcher::class.java)");
        blockingDispatcher = qualified5;
        Qualified qualified6 = Qualified.unqualified(TransportFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)qualified6, (String)"unqualified(TransportFactory::class.java)");
        transportFactory = qualified6;
        Qualified qualified7 = Qualified.unqualified(FirebaseSessionsComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)qualified7, (String)"unqualified(FirebaseSessionsComponent::class.java)");
        firebaseSessionsComponent = qualified7;
        try {
            ((Object)((Object)Companion.1.INSTANCE)).getClass();
        }
        catch (NoClassDefFoundError ex) {
            Log.w((String)TAG, (String)"Your app is experiencing a known issue in the Android Gradle plugin, see https://issuetracker.google.com/328687152\n\nIt affects Java-only apps using AGP version 8.3.2 and under. To avoid the issue, either:\n\n1. Upgrade Android Gradle plugin to 8.4.0+\n   Follow the guide at https://developer.android.com/build/agp-upgrade-assistant\n\n2. Or, add the Kotlin plugin to your app\n   Follow the guide at https://developer.android.com/kotlin/add-kotlin\n\n3. Or, do the technical workaround described in https://issuetracker.google.com/issues/328687152#comment3");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\r0\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001f\u0010\u000f\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\r0\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u001f\u0010\u0011\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00120\u00120\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u001f\u0010\u0014\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00150\u00150\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u001f\u0010\u0017\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00180\u00180\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u001f\u0010\u001a\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001b0\u001b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsRegistrar$Companion;", "", "()V", "LIBRARY_NAME", "", "TAG", "appContext", "Lcom/google/firebase/components/Qualified;", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "getAppContext", "()Lcom/google/firebase/components/Qualified;", "backgroundDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getBackgroundDispatcher", "blockingDispatcher", "getBlockingDispatcher", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "getFirebaseApp", "firebaseInstallationsApi", "Lcom/google/firebase/installations/FirebaseInstallationsApi;", "getFirebaseInstallationsApi", "firebaseSessionsComponent", "Lcom/google/firebase/sessions/FirebaseSessionsComponent;", "getFirebaseSessionsComponent", "transportFactory", "Lcom/google/android/datatransport/TransportFactory;", "getTransportFactory", "com.google.firebase-firebase-sessions"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Qualified<Context> getAppContext() {
            return appContext;
        }

        @NotNull
        public final Qualified<FirebaseApp> getFirebaseApp() {
            return firebaseApp;
        }

        @NotNull
        public final Qualified<FirebaseInstallationsApi> getFirebaseInstallationsApi() {
            return firebaseInstallationsApi;
        }

        @NotNull
        public final Qualified<CoroutineDispatcher> getBackgroundDispatcher() {
            return backgroundDispatcher;
        }

        @NotNull
        public final Qualified<CoroutineDispatcher> getBlockingDispatcher() {
            return blockingDispatcher;
        }

        @NotNull
        public final Qualified<TransportFactory> getTransportFactory() {
            return transportFactory;
        }

        @NotNull
        public final Qualified<FirebaseSessionsComponent> getFirebaseSessionsComponent() {
            return firebaseSessionsComponent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

