/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.app.Service;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import com.google.firebase.sessions.SessionDatastore;
import com.google.firebase.sessions.SessionFirelogPublisher;
import com.google.firebase.sessions.SessionGenerator;
import com.google.firebase.sessions.settings.SessionsSettings;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/google/firebase/sessions/SessionLifecycleService;", "Landroid/app/Service;", "()V", "handlerThread", "Landroid/os/HandlerThread;", "getHandlerThread$com_google_firebase_firebase_sessions", "()Landroid/os/HandlerThread;", "messageHandler", "Lcom/google/firebase/sessions/SessionLifecycleService$MessageHandler;", "messenger", "Landroid/os/Messenger;", "getClientCallback", "intent", "Landroid/content/Intent;", "onBind", "Landroid/os/IBinder;", "onCreate", "", "onDestroy", "Companion", "MessageHandler", "com.google.firebase-firebase-sessions"})
public final class SessionLifecycleService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HandlerThread handlerThread = new HandlerThread("FirebaseSessions_HandlerThread");
    @Nullable
    private MessageHandler messageHandler;
    @Nullable
    private Messenger messenger;
    @NotNull
    public static final String TAG = "SessionLifecycleService";
    @NotNull
    public static final String CLIENT_CALLBACK_MESSENGER = "ClientCallbackMessenger";
    @NotNull
    public static final String SESSION_UPDATE_EXTRA = "SessionUpdateExtra";
    public static final int FOREGROUNDED = 1;
    public static final int BACKGROUNDED = 2;
    public static final int SESSION_UPDATED = 3;
    private static final int CLIENT_BOUND = 4;

    @NotNull
    public final HandlerThread getHandlerThread$com_google_firebase_firebase_sessions() {
        return this.handlerThread;
    }

    public void onCreate() {
        super.onCreate();
        this.handlerThread.start();
        Looper looper = this.handlerThread.getLooper();
        Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"handlerThread.looper");
        this.messageHandler = new MessageHandler(looper);
        this.messenger = new Messenger((Handler)this.messageHandler);
    }

    @Nullable
    public IBinder onBind(@Nullable Intent intent) {
        Object object;
        if (intent == null) {
            Log.d((String)TAG, (String)"Service bound with null intent. Ignoring.");
            object = null;
        } else {
            Log.d((String)TAG, (String)("Service bound to new client on process " + intent.getAction()));
            Messenger callbackMessenger = this.getClientCallback(intent);
            if (callbackMessenger != null) {
                Message clientBoundMsg = Message.obtain(null, (int)4, (int)0, (int)0);
                clientBoundMsg.replyTo = callbackMessenger;
                MessageHandler messageHandler = this.messageHandler;
                if (messageHandler != null) {
                    messageHandler.sendMessage(clientBoundMsg);
                }
            }
            Messenger messenger = this.messenger;
            object = messenger != null ? messenger.getBinder() : null;
        }
        return object;
    }

    public void onDestroy() {
        super.onDestroy();
        this.handlerThread.quit();
    }

    private final Messenger getClientCallback(Intent intent) {
        return Build.VERSION.SDK_INT >= 33 ? (Messenger)intent.getParcelableExtra(CLIENT_CALLBACK_MESSENGER, Messenger.class) : (Messenger)intent.getParcelableExtra(CLIENT_CALLBACK_MESSENGER);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/firebase/sessions/SessionLifecycleService$Companion;", "", "()V", "BACKGROUNDED", "", "CLIENT_BOUND", "CLIENT_CALLBACK_MESSENGER", "", "FOREGROUNDED", "SESSION_UPDATED", "SESSION_UPDATE_EXTRA", "TAG", "com.google.firebase-firebase-sessions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/google/firebase/sessions/SessionLifecycleService$MessageHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "(Landroid/os/Looper;)V", "boundClients", "Ljava/util/ArrayList;", "Landroid/os/Messenger;", "Lkotlin/collections/ArrayList;", "hasForegrounded", "", "lastMsgTimeMs", "", "broadcastSession", "", "handleBackgrounding", "msg", "Landroid/os/Message;", "handleClientBound", "handleForegrounding", "handleMessage", "isSessionRestart", "foregroundTimeMs", "maybeSendSessionToClient", "client", "newSession", "sendSessionToClient", "sessionId", "", "com.google.firebase-firebase-sessions"})
    @SourceDebugExtension(value={"SMAP\nSessionLifecycleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionLifecycleService.kt\ncom/google/firebase/sessions/SessionLifecycleService$MessageHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1855#2,2:263\n1#3:265\n*S KotlinDebug\n*F\n+ 1 SessionLifecycleService.kt\ncom/google/firebase/sessions/SessionLifecycleService$MessageHandler\n*L\n151#1:263,2\n*E\n"})
    public static final class MessageHandler
    extends Handler {
        private boolean hasForegrounded;
        private long lastMsgTimeMs;
        @NotNull
        private final ArrayList<Messenger> boundClients;

        public MessageHandler(@NotNull Looper looper) {
            Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
            super(looper);
            this.boundClients = new ArrayList();
        }

        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            if (this.lastMsgTimeMs > msg.getWhen()) {
                Log.d((String)SessionLifecycleService.TAG, (String)("Ignoring old message from " + msg.getWhen() + " which is older than " + this.lastMsgTimeMs + '.'));
                return;
            }
            switch (msg.what) {
                case 1: {
                    this.handleForegrounding(msg);
                    break;
                }
                case 2: {
                    this.handleBackgrounding(msg);
                    break;
                }
                case 4: {
                    this.handleClientBound(msg);
                    break;
                }
                default: {
                    Log.w((String)SessionLifecycleService.TAG, (String)("Received unexpected event from the SessionLifecycleClient: " + msg));
                    super.handleMessage(msg);
                }
            }
        }

        private final void handleForegrounding(Message msg) {
            Log.d((String)SessionLifecycleService.TAG, (String)("Activity foregrounding at " + msg.getWhen() + '.'));
            if (!this.hasForegrounded) {
                Log.d((String)SessionLifecycleService.TAG, (String)"Cold start detected.");
                this.hasForegrounded = true;
                this.newSession();
            } else if (this.isSessionRestart(msg.getWhen())) {
                Log.d((String)SessionLifecycleService.TAG, (String)"Session too long in background. Creating new session.");
                this.newSession();
            }
            this.lastMsgTimeMs = msg.getWhen();
        }

        private final void handleBackgrounding(Message msg) {
            Log.d((String)SessionLifecycleService.TAG, (String)("Activity backgrounding at " + msg.getWhen()));
            this.lastMsgTimeMs = msg.getWhen();
        }

        private final void handleClientBound(Message msg) {
            this.boundClients.add(msg.replyTo);
            Messenger messenger = msg.replyTo;
            Intrinsics.checkNotNullExpressionValue((Object)messenger, (String)"msg.replyTo");
            this.maybeSendSessionToClient(messenger);
            Log.d((String)SessionLifecycleService.TAG, (String)("Client " + msg.replyTo + " bound at " + msg.getWhen() + ". Clients: " + this.boundClients.size()));
        }

        private final void newSession() {
            try {
                SessionGenerator.Companion.getInstance().generateNewSession();
                Log.d((String)SessionLifecycleService.TAG, (String)"Generated new session.");
                this.broadcastSession();
                SessionDatastore.Companion.getInstance().updateSessionId(SessionGenerator.Companion.getInstance().getCurrentSession().getSessionId());
            }
            catch (IllegalStateException ex) {
                Log.w((String)SessionLifecycleService.TAG, (String)"Failed to generate new session.", (Throwable)ex);
            }
        }

        private final void broadcastSession() {
            Log.d((String)SessionLifecycleService.TAG, (String)"Broadcasting new session");
            SessionFirelogPublisher.Companion.getInstance().logSession(SessionGenerator.Companion.getInstance().getCurrentSession());
            ArrayList clientsToSend = new ArrayList(this.boundClients);
            Iterable $this$forEach$iv = clientsToSend;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Messenger it = (Messenger)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.maybeSendSessionToClient(it);
            }
        }

        private final void maybeSendSessionToClient(Messenger client) {
            try {
                if (this.hasForegrounded) {
                    this.sendSessionToClient(client, SessionGenerator.Companion.getInstance().getCurrentSession().getSessionId());
                } else {
                    String storedSession = SessionDatastore.Companion.getInstance().getCurrentSessionId();
                    Log.d((String)SessionLifecycleService.TAG, (String)"App has not yet foregrounded. Using previously stored session.");
                    String string = storedSession;
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        this.sendSessionToClient(client, it);
                    }
                }
            }
            catch (IllegalStateException ex) {
                Log.w((String)SessionLifecycleService.TAG, (String)"Failed to send session to client.", (Throwable)ex);
            }
        }

        private final void sendSessionToClient(Messenger client, String sessionId) {
            try {
                Bundle bundle;
                Bundle it = bundle = new Bundle();
                boolean bl = false;
                it.putString(SessionLifecycleService.SESSION_UPDATE_EXTRA, sessionId);
                Bundle msgData = bundle;
                it = bundle = Message.obtain(null, (int)3, (int)0, (int)0);
                Messenger messenger = client;
                boolean bl2 = false;
                it.setData(msgData);
                messenger.send((Message)bundle);
            }
            catch (DeadObjectException e) {
                Log.d((String)SessionLifecycleService.TAG, (String)("Removing dead client from list: " + client));
                this.boundClients.remove(client);
            }
            catch (Exception e) {
                Log.w((String)SessionLifecycleService.TAG, (String)("Unable to push new session to " + client + '.'), (Throwable)e);
            }
        }

        private final boolean isSessionRestart(long foregroundTimeMs) {
            return foregroundTimeMs - this.lastMsgTimeMs > Duration.getInWholeMilliseconds-impl((long)SessionsSettings.Companion.getInstance().getSessionRestartTimeout-UwyO8pc());
        }
    }
}

