/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.Context;
import androidx.datastore.core.DataStore;
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler;
import androidx.datastore.preferences.PreferenceDataStoreFile;
import androidx.datastore.preferences.core.PreferenceDataStoreFactory;
import androidx.datastore.preferences.core.Preferences;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.sessions.ApplicationInfo;
import com.google.firebase.sessions.EventGDTLogger;
import com.google.firebase.sessions.EventGDTLoggerInterface;
import com.google.firebase.sessions.FirebaseSessions;
import com.google.firebase.sessions.FirebaseSessionsComponent;
import com.google.firebase.sessions.LocalOverrideSettingsProvider;
import com.google.firebase.sessions.RemoteSettingsProvider;
import com.google.firebase.sessions.SessionConfigsDataStore;
import com.google.firebase.sessions.SessionDataStoreConfigs;
import com.google.firebase.sessions.SessionDatastore;
import com.google.firebase.sessions.SessionDatastoreImpl;
import com.google.firebase.sessions.SessionDetailsDataStore;
import com.google.firebase.sessions.SessionEvents;
import com.google.firebase.sessions.SessionFirelogPublisher;
import com.google.firebase.sessions.SessionFirelogPublisherImpl;
import com.google.firebase.sessions.SessionGenerator;
import com.google.firebase.sessions.SessionLifecycleServiceBinder;
import com.google.firebase.sessions.SessionLifecycleServiceBinderImpl;
import com.google.firebase.sessions.TimeProvider;
import com.google.firebase.sessions.TimeProviderImpl;
import com.google.firebase.sessions.UuidGenerator;
import com.google.firebase.sessions.UuidGeneratorImpl;
import com.google.firebase.sessions.dagger.Binds;
import com.google.firebase.sessions.dagger.BindsInstance;
import com.google.firebase.sessions.dagger.Component;
import com.google.firebase.sessions.dagger.Module;
import com.google.firebase.sessions.dagger.Provides;
import com.google.firebase.sessions.settings.CrashlyticsSettingsFetcher;
import com.google.firebase.sessions.settings.LocalOverrideSettings;
import com.google.firebase.sessions.settings.RemoteSettings;
import com.google.firebase.sessions.settings.RemoteSettingsFetcher;
import com.google.firebase.sessions.settings.SessionsSettings;
import com.google.firebase.sessions.settings.SettingsProvider;
import java.io.File;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Component(modules={MainModule.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\ba\u0018\u00002\u00020\u0001:\u0002\u0016\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsComponent;", "", "firebaseSessions", "Lcom/google/firebase/sessions/FirebaseSessions;", "getFirebaseSessions", "()Lcom/google/firebase/sessions/FirebaseSessions;", "sessionDatastore", "Lcom/google/firebase/sessions/SessionDatastore;", "getSessionDatastore", "()Lcom/google/firebase/sessions/SessionDatastore;", "sessionFirelogPublisher", "Lcom/google/firebase/sessions/SessionFirelogPublisher;", "getSessionFirelogPublisher", "()Lcom/google/firebase/sessions/SessionFirelogPublisher;", "sessionGenerator", "Lcom/google/firebase/sessions/SessionGenerator;", "getSessionGenerator", "()Lcom/google/firebase/sessions/SessionGenerator;", "sessionsSettings", "Lcom/google/firebase/sessions/settings/SessionsSettings;", "getSessionsSettings", "()Lcom/google/firebase/sessions/settings/SessionsSettings;", "Builder", "MainModule", "com.google.firebase-firebase-sessions"})
public interface FirebaseSessionsComponent {
    @NotNull
    public FirebaseSessions getFirebaseSessions();

    @NotNull
    public SessionDatastore getSessionDatastore();

    @NotNull
    public SessionFirelogPublisher getSessionFirelogPublisher();

    @NotNull
    public SessionGenerator getSessionGenerator();

    @NotNull
    public SessionsSettings getSessionsSettings();

    @Component.Builder
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H'J\u0012\u0010\u0004\u001a\u00020\u00002\b\b\u0001\u0010\u0004\u001a\u00020\u0005H'J\u0012\u0010\u0006\u001a\u00020\u00002\b\b\u0001\u0010\u0006\u001a\u00020\u0005H'J\b\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH'J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH'J\u0016\u0010\r\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH'\u00a8\u0006\u0010"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsComponent$Builder;", "", "appContext", "Landroid/content/Context;", "backgroundDispatcher", "Lkotlin/coroutines/CoroutineContext;", "blockingDispatcher", "build", "Lcom/google/firebase/sessions/FirebaseSessionsComponent;", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "firebaseInstallationsApi", "Lcom/google/firebase/installations/FirebaseInstallationsApi;", "transportFactoryProvider", "Lcom/google/firebase/inject/Provider;", "Lcom/google/android/datatransport/TransportFactory;", "com.google.firebase-firebase-sessions"})
    public static interface Builder {
        @BindsInstance
        @NotNull
        public Builder appContext(@NotNull Context var1);

        @BindsInstance
        @NotNull
        public Builder backgroundDispatcher(@Background @NotNull CoroutineContext var1);

        @BindsInstance
        @NotNull
        public Builder blockingDispatcher(@Blocking @NotNull CoroutineContext var1);

        @BindsInstance
        @NotNull
        public Builder firebaseApp(@NotNull FirebaseApp var1);

        @BindsInstance
        @NotNull
        public Builder firebaseInstallationsApi(@NotNull FirebaseInstallationsApi var1);

        @BindsInstance
        @NotNull
        public Builder transportFactoryProvider(@NotNull Provider<TransportFactory> var1);

        @NotNull
        public FirebaseSessionsComponent build();
    }

    @Module
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\bH'J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u000bH'J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\rH'J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0010H'J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0013H'J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0016H'\u00a8\u0006\u0018"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsComponent$MainModule;", "", "crashlyticsSettingsFetcher", "Lcom/google/firebase/sessions/settings/CrashlyticsSettingsFetcher;", "impl", "Lcom/google/firebase/sessions/settings/RemoteSettingsFetcher;", "eventGDTLoggerInterface", "Lcom/google/firebase/sessions/EventGDTLoggerInterface;", "Lcom/google/firebase/sessions/EventGDTLogger;", "localOverrideSettings", "Lcom/google/firebase/sessions/settings/SettingsProvider;", "Lcom/google/firebase/sessions/settings/LocalOverrideSettings;", "remoteSettings", "Lcom/google/firebase/sessions/settings/RemoteSettings;", "sessionDatastore", "Lcom/google/firebase/sessions/SessionDatastore;", "Lcom/google/firebase/sessions/SessionDatastoreImpl;", "sessionFirelogPublisher", "Lcom/google/firebase/sessions/SessionFirelogPublisher;", "Lcom/google/firebase/sessions/SessionFirelogPublisherImpl;", "sessionLifecycleServiceBinder", "Lcom/google/firebase/sessions/SessionLifecycleServiceBinder;", "Lcom/google/firebase/sessions/SessionLifecycleServiceBinderImpl;", "Companion", "com.google.firebase-firebase-sessions"})
    public static interface MainModule {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Binds
        @Singleton
        @NotNull
        public EventGDTLoggerInterface eventGDTLoggerInterface(@NotNull EventGDTLogger var1);

        @Binds
        @Singleton
        @NotNull
        public SessionDatastore sessionDatastore(@NotNull SessionDatastoreImpl var1);

        @Binds
        @Singleton
        @NotNull
        public SessionFirelogPublisher sessionFirelogPublisher(@NotNull SessionFirelogPublisherImpl var1);

        @Binds
        @Singleton
        @NotNull
        public SessionLifecycleServiceBinder sessionLifecycleServiceBinder(@NotNull SessionLifecycleServiceBinderImpl var1);

        @Binds
        @Singleton
        @NotNull
        public CrashlyticsSettingsFetcher crashlyticsSettingsFetcher(@NotNull RemoteSettingsFetcher var1);

        @Binds
        @Singleton
        @LocalOverrideSettingsProvider
        @NotNull
        public SettingsProvider localOverrideSettings(@NotNull LocalOverrideSettings var1);

        @Binds
        @Singleton
        @RemoteSettingsProvider
        @NotNull
        public SettingsProvider remoteSettings(@NotNull RemoteSettings var1);

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/google/firebase/sessions/FirebaseSessionsComponent$MainModule$Companion;", "", "()V", "TAG", "", "applicationInfo", "Lcom/google/firebase/sessions/ApplicationInfo;", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "sessionConfigsDataStore", "Landroidx/datastore/core/DataStore;", "Landroidx/datastore/preferences/core/Preferences;", "appContext", "Landroid/content/Context;", "sessionDetailsDataStore", "timeProvider", "Lcom/google/firebase/sessions/TimeProvider;", "uuidGenerator", "Lcom/google/firebase/sessions/UuidGenerator;", "com.google.firebase-firebase-sessions"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final String TAG = "FirebaseSessions";

            private Companion() {
            }

            @Provides
            @Singleton
            @NotNull
            public final TimeProvider timeProvider() {
                return TimeProviderImpl.INSTANCE;
            }

            @Provides
            @Singleton
            @NotNull
            public final UuidGenerator uuidGenerator() {
                return UuidGeneratorImpl.INSTANCE;
            }

            @Provides
            @Singleton
            @NotNull
            public final ApplicationInfo applicationInfo(@NotNull FirebaseApp firebaseApp) {
                Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
                return SessionEvents.INSTANCE.getApplicationInfo(firebaseApp);
            }

            @Provides
            @Singleton
            @SessionConfigsDataStore
            @NotNull
            public final DataStore<Preferences> sessionConfigsDataStore(@NotNull Context appContext) {
                Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
                return PreferenceDataStoreFactory.create$default((PreferenceDataStoreFactory)PreferenceDataStoreFactory.INSTANCE, (ReplaceFileCorruptionHandler)new ReplaceFileCorruptionHandler((Function1)sessionConfigsDataStore.1.INSTANCE), null, null, (Function0)((Function0)new Function0<File>(appContext){
                    final /* synthetic */ Context $appContext;
                    {
                        this.$appContext = $appContext;
                        super(0);
                    }

                    @NotNull
                    public final File invoke() {
                        return PreferenceDataStoreFile.preferencesDataStoreFile((Context)this.$appContext, (String)SessionDataStoreConfigs.INSTANCE.getSETTINGS_CONFIG_NAME());
                    }
                }), (int)6, null);
            }

            @Provides
            @Singleton
            @SessionDetailsDataStore
            @NotNull
            public final DataStore<Preferences> sessionDetailsDataStore(@NotNull Context appContext) {
                Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
                return PreferenceDataStoreFactory.create$default((PreferenceDataStoreFactory)PreferenceDataStoreFactory.INSTANCE, (ReplaceFileCorruptionHandler)new ReplaceFileCorruptionHandler((Function1)sessionDetailsDataStore.1.INSTANCE), null, null, (Function0)((Function0)new Function0<File>(appContext){
                    final /* synthetic */ Context $appContext;
                    {
                        this.$appContext = $appContext;
                        super(0);
                    }

                    @NotNull
                    public final File invoke() {
                        return PreferenceDataStoreFile.preferencesDataStoreFile((Context)this.$appContext, (String)SessionDataStoreConfigs.INSTANCE.getSESSIONS_CONFIG_NAME());
                    }
                }), (int)6, null);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

