/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.google.firebase.Firebase;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseAppLifecycleListener;
import com.google.firebase.FirebaseKt;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.sessions.SessionLifecycleClient;
import com.google.firebase.sessions.SessionLifecycleServiceBinder;
import com.google.firebase.sessions.SessionsActivityLifecycleCallbacks;
import com.google.firebase.sessions.api.FirebaseSessionsDependencies;
import com.google.firebase.sessions.api.SessionSubscriber;
import com.google.firebase.sessions.settings.SessionsSettings;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/firebase/sessions/FirebaseSessions;", "", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "settings", "Lcom/google/firebase/sessions/settings/SessionsSettings;", "backgroundDispatcher", "Lkotlin/coroutines/CoroutineContext;", "lifecycleServiceBinder", "Lcom/google/firebase/sessions/SessionLifecycleServiceBinder;", "(Lcom/google/firebase/FirebaseApp;Lcom/google/firebase/sessions/settings/SessionsSettings;Lkotlin/coroutines/CoroutineContext;Lcom/google/firebase/sessions/SessionLifecycleServiceBinder;)V", "Companion", "com.google.firebase-firebase-sessions"})
public final class FirebaseSessions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirebaseApp firebaseApp;
    @NotNull
    private final SessionsSettings settings;
    @NotNull
    private static final String TAG = "FirebaseSessions";

    @Inject
    public FirebaseSessions(@NotNull FirebaseApp firebaseApp, @NotNull SessionsSettings settings, @Background @NotNull CoroutineContext backgroundDispatcher, @NotNull SessionLifecycleServiceBinder lifecycleServiceBinder) {
        Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)backgroundDispatcher, (String)"backgroundDispatcher");
        Intrinsics.checkNotNullParameter((Object)lifecycleServiceBinder, (String)"lifecycleServiceBinder");
        this.firebaseApp = firebaseApp;
        this.settings = settings;
        Log.d((String)TAG, (String)"Initializing Firebase Sessions SDK.");
        Context appContext = this.firebaseApp.getApplicationContext().getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)SessionsActivityLifecycleCallbacks.INSTANCE);
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)backgroundDispatcher), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, backgroundDispatcher, lifecycleServiceBinder, null){
                int label;
                final /* synthetic */ FirebaseSessions this$0;
                final /* synthetic */ CoroutineContext $backgroundDispatcher;
                final /* synthetic */ SessionLifecycleServiceBinder $lifecycleServiceBinder;
                {
                    this.this$0 = $receiver;
                    this.$backgroundDispatcher = $backgroundDispatcher;
                    this.$lifecycleServiceBinder = $lifecycleServiceBinder;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = FirebaseSessionsDependencies.INSTANCE.getRegisteredSubscribers$com_google_firebase_firebase_sessions((Continuation<? super Map<SessionSubscriber.Name, ? extends SessionSubscriber>>)((Continuation)this));
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            subscribers = (Map)v0;
                            $this$none$iv = subscribers.values();
                            $i$f$none = false;
                            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl19
                            v1 = true;
                            ** GOTO lbl26
lbl19:
                            // 2 sources

                            for (T element$iv : $this$none$iv) {
                                it = (SessionSubscriber)element$iv;
                                $i$a$-none-FirebaseSessions$1$1 = false;
                                if (!it.isDataCollectionEnabled()) continue;
                                v1 = false;
                                ** GOTO lbl26
                            }
                            v1 = true;
lbl26:
                            // 3 sources

                            if (!v1) ** GOTO lbl30
                            Log.d((String)"FirebaseSessions", (String)"No Sessions subscribers. Not listening to lifecycle events.");
                            ** GOTO lbl46
lbl30:
                            // 1 sources

                            this.label = 2;
                            v2 = FirebaseSessions.access$getSettings$p(this.this$0).updateSettings((Continuation<? super Unit>)((Continuation)this));
                            if (v2 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl38
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl38:
                            // 2 sources

                            if (!FirebaseSessions.access$getSettings$p(this.this$0).getSessionsEnabled()) {
                                Log.d((String)"FirebaseSessions", (String)"Sessions SDK disabled. Not listening to lifecycle events.");
                            } else {
                                lifecycleClient = new SessionLifecycleClient(this.$backgroundDispatcher);
                                lifecycleClient.bindToService(this.$lifecycleServiceBinder);
                                SessionsActivityLifecycleCallbacks.INSTANCE.setLifecycleClient(lifecycleClient);
                                FirebaseSessions.access$getFirebaseApp$p(this.this$0).addLifecycleEventListener((FirebaseAppLifecycleListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Lcom/google/firebase/FirebaseOptions;)V, invokeSuspend$lambda$1(java.lang.String com.google.firebase.FirebaseOptions ), (Ljava/lang/String;Lcom/google/firebase/FirebaseOptions;)V)());
                            }
lbl46:
                            // 3 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda$1(String string, FirebaseOptions firebaseOptions) {
                    Log.w((String)FirebaseSessions.TAG, (String)"FirebaseApp instance deleted. Sessions library will stop collecting data.");
                    SessionsActivityLifecycleCallbacks.INSTANCE.setLifecycleClient(null);
                }
            }), (int)3, null);
        } else {
            Log.e((String)TAG, (String)("Failed to register lifecycle callbacks, unexpected context " + appContext.getClass() + '.'));
        }
    }

    public static final /* synthetic */ SessionsSettings access$getSettings$p(FirebaseSessions $this) {
        return $this.settings;
    }

    public static final /* synthetic */ FirebaseApp access$getFirebaseApp$p(FirebaseSessions $this) {
        return $this.firebaseApp;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/google/firebase/sessions/FirebaseSessions$Companion;", "", "()V", "TAG", "", "instance", "Lcom/google/firebase/sessions/FirebaseSessions;", "getInstance", "()Lcom/google/firebase/sessions/FirebaseSessions;", "com.google.firebase-firebase-sessions"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirebaseSessions getInstance() {
            Object object = FirebaseKt.getApp((Firebase)Firebase.INSTANCE).get(FirebaseSessions.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Firebase.app[FirebaseSessions::class.java]");
            return (FirebaseSessions)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

