// Generated by Dagger (https://dagger.dev).
package com.google.firebase.sessions;

import android.content.Context;
import androidx.datastore.core.DataStore;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.sessions.settings.LocalOverrideSettings;
import com.google.firebase.sessions.settings.LocalOverrideSettings_Factory;
import com.google.firebase.sessions.settings.RemoteSettings;
import com.google.firebase.sessions.settings.RemoteSettingsFetcher;
import com.google.firebase.sessions.settings.RemoteSettingsFetcher_Factory;
import com.google.firebase.sessions.settings.RemoteSettings_Factory;
import com.google.firebase.sessions.settings.SessionConfigs;
import com.google.firebase.sessions.settings.SessionsSettings;
import com.google.firebase.sessions.settings.SessionsSettings_Factory;
import com.google.firebase.sessions.settings.SettingsCacheImpl;
import com.google.firebase.sessions.settings.SettingsCacheImpl_Factory;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import kotlin.coroutines.CoroutineContext;

@DaggerGenerated
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava",
    "cast"
})
public final class DaggerFirebaseSessionsComponent {
  private DaggerFirebaseSessionsComponent() {
  }

  public static FirebaseSessionsComponent.Builder builder() {
    return new Builder();
  }

  private static final class Builder implements FirebaseSessionsComponent.Builder {
    private Context appContext;

    private CoroutineContext backgroundDispatcher;

    private CoroutineContext blockingDispatcher;

    private FirebaseApp firebaseApp;

    private FirebaseInstallationsApi firebaseInstallationsApi;

    private Provider<TransportFactory> transportFactoryProvider;

    @Override
    public Builder appContext(Context appContext) {
      this.appContext = Preconditions.checkNotNull(appContext);
      return this;
    }

    @Override
    public Builder backgroundDispatcher(CoroutineContext backgroundDispatcher) {
      this.backgroundDispatcher = Preconditions.checkNotNull(backgroundDispatcher);
      return this;
    }

    @Override
    public Builder blockingDispatcher(CoroutineContext blockingDispatcher) {
      this.blockingDispatcher = Preconditions.checkNotNull(blockingDispatcher);
      return this;
    }

    @Override
    public Builder firebaseApp(FirebaseApp firebaseApp) {
      this.firebaseApp = Preconditions.checkNotNull(firebaseApp);
      return this;
    }

    @Override
    public Builder firebaseInstallationsApi(FirebaseInstallationsApi firebaseInstallationsApi) {
      this.firebaseInstallationsApi = Preconditions.checkNotNull(firebaseInstallationsApi);
      return this;
    }

    @Override
    public Builder transportFactoryProvider(Provider<TransportFactory> transportFactoryProvider) {
      this.transportFactoryProvider = Preconditions.checkNotNull(transportFactoryProvider);
      return this;
    }

    @Override
    public FirebaseSessionsComponent build() {
      Preconditions.checkBuilderRequirement(appContext, Context.class);
      Preconditions.checkBuilderRequirement(backgroundDispatcher, CoroutineContext.class);
      Preconditions.checkBuilderRequirement(blockingDispatcher, CoroutineContext.class);
      Preconditions.checkBuilderRequirement(firebaseApp, FirebaseApp.class);
      Preconditions.checkBuilderRequirement(firebaseInstallationsApi, FirebaseInstallationsApi.class);
      Preconditions.checkBuilderRequirement(transportFactoryProvider, Provider.class);
      return new FirebaseSessionsComponentImpl(appContext, backgroundDispatcher, blockingDispatcher, firebaseApp, firebaseInstallationsApi, transportFactoryProvider);
    }
  }

  private static final class FirebaseSessionsComponentImpl implements FirebaseSessionsComponent {
    private final FirebaseSessionsComponentImpl firebaseSessionsComponentImpl = this;

    private dagger.internal.Provider<FirebaseApp> firebaseAppProvider;

    private dagger.internal.Provider<Context> appContextProvider;

    private dagger.internal.Provider<LocalOverrideSettings> localOverrideSettingsProvider;

    private dagger.internal.Provider<TimeProvider> timeProvider;

    private dagger.internal.Provider<FirebaseInstallationsApi> firebaseInstallationsApiProvider;

    private dagger.internal.Provider<ApplicationInfo> applicationInfoProvider;

    private dagger.internal.Provider<CoroutineContext> blockingDispatcherProvider;

    private dagger.internal.Provider<RemoteSettingsFetcher> remoteSettingsFetcherProvider;

    private dagger.internal.Provider<CoroutineContext> backgroundDispatcherProvider;

    private dagger.internal.Provider<DataStore<SessionConfigs>> sessionConfigsDataStoreProvider;

    private dagger.internal.Provider<SettingsCacheImpl> settingsCacheImplProvider;

    private dagger.internal.Provider<RemoteSettings> remoteSettingsProvider;

    private dagger.internal.Provider<SessionsSettings> sessionsSettingsProvider;

    private dagger.internal.Provider<UuidGenerator> uuidGeneratorProvider;

    private dagger.internal.Provider<SessionGenerator> sessionGeneratorProvider;

    private dagger.internal.Provider<Provider<TransportFactory>> transportFactoryProvider;

    private dagger.internal.Provider<EventGDTLogger> eventGDTLoggerProvider;

    private dagger.internal.Provider<SessionFirelogPublisherImpl> sessionFirelogPublisherImplProvider;

    private dagger.internal.Provider<SessionDataSerializer> sessionDataSerializerProvider;

    private dagger.internal.Provider<DataStore<SessionData>> sessionDataStoreProvider;

    private dagger.internal.Provider<ProcessDataManagerImpl> processDataManagerImplProvider;

    private dagger.internal.Provider<SharedSessionRepositoryImpl> sharedSessionRepositoryImplProvider;

    private dagger.internal.Provider<SessionsActivityLifecycleCallbacks> sessionsActivityLifecycleCallbacksProvider;

    private dagger.internal.Provider<FirebaseSessions> firebaseSessionsProvider;

    private FirebaseSessionsComponentImpl(Context appContextParam,
        CoroutineContext backgroundDispatcherParam, CoroutineContext blockingDispatcherParam,
        FirebaseApp firebaseAppParam, FirebaseInstallationsApi firebaseInstallationsApiParam,
        Provider<TransportFactory> transportFactoryProviderParam) {

      initialize(appContextParam, backgroundDispatcherParam, blockingDispatcherParam, firebaseAppParam, firebaseInstallationsApiParam, transportFactoryProviderParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final Context appContextParam,
        final CoroutineContext backgroundDispatcherParam,
        final CoroutineContext blockingDispatcherParam, final FirebaseApp firebaseAppParam,
        final FirebaseInstallationsApi firebaseInstallationsApiParam,
        final Provider<TransportFactory> transportFactoryProviderParam) {
      this.firebaseAppProvider = InstanceFactory.create(firebaseAppParam);
      this.appContextProvider = InstanceFactory.create(appContextParam);
      this.localOverrideSettingsProvider = DoubleCheck.provider(LocalOverrideSettings_Factory.create(appContextProvider));
      this.timeProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_TimeProviderFactory.create());
      this.firebaseInstallationsApiProvider = InstanceFactory.create(firebaseInstallationsApiParam);
      this.applicationInfoProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_ApplicationInfoFactory.create(firebaseAppProvider));
      this.blockingDispatcherProvider = InstanceFactory.create(blockingDispatcherParam);
      this.remoteSettingsFetcherProvider = DoubleCheck.provider(RemoteSettingsFetcher_Factory.create(applicationInfoProvider, blockingDispatcherProvider));
      this.backgroundDispatcherProvider = InstanceFactory.create(backgroundDispatcherParam);
      this.sessionConfigsDataStoreProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_SessionConfigsDataStoreFactory.create(appContextProvider, blockingDispatcherProvider));
      this.settingsCacheImplProvider = DoubleCheck.provider(SettingsCacheImpl_Factory.create(backgroundDispatcherProvider, timeProvider, sessionConfigsDataStoreProvider));
      this.remoteSettingsProvider = DoubleCheck.provider(RemoteSettings_Factory.create(timeProvider, firebaseInstallationsApiProvider, applicationInfoProvider, ((dagger.internal.Provider) remoteSettingsFetcherProvider), ((dagger.internal.Provider) settingsCacheImplProvider)));
      this.sessionsSettingsProvider = DoubleCheck.provider(SessionsSettings_Factory.create(((dagger.internal.Provider) localOverrideSettingsProvider), ((dagger.internal.Provider) remoteSettingsProvider)));
      this.uuidGeneratorProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_UuidGeneratorFactory.create());
      this.sessionGeneratorProvider = DoubleCheck.provider(SessionGenerator_Factory.create(timeProvider, uuidGeneratorProvider));
      this.transportFactoryProvider = InstanceFactory.create(transportFactoryProviderParam);
      this.eventGDTLoggerProvider = DoubleCheck.provider(EventGDTLogger_Factory.create(transportFactoryProvider));
      this.sessionFirelogPublisherImplProvider = DoubleCheck.provider(SessionFirelogPublisherImpl_Factory.create(firebaseAppProvider, firebaseInstallationsApiProvider, sessionsSettingsProvider, ((dagger.internal.Provider) eventGDTLoggerProvider), backgroundDispatcherProvider));
      this.sessionDataSerializerProvider = DoubleCheck.provider(SessionDataSerializer_Factory.create(sessionGeneratorProvider));
      this.sessionDataStoreProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_SessionDataStoreFactory.create(appContextProvider, blockingDispatcherProvider, sessionDataSerializerProvider));
      this.processDataManagerImplProvider = DoubleCheck.provider(ProcessDataManagerImpl_Factory.create(appContextProvider, uuidGeneratorProvider));
      this.sharedSessionRepositoryImplProvider = DoubleCheck.provider(SharedSessionRepositoryImpl_Factory.create(sessionsSettingsProvider, sessionGeneratorProvider, ((dagger.internal.Provider) sessionFirelogPublisherImplProvider), timeProvider, sessionDataStoreProvider, ((dagger.internal.Provider) processDataManagerImplProvider), backgroundDispatcherProvider));
      this.sessionsActivityLifecycleCallbacksProvider = DoubleCheck.provider(SessionsActivityLifecycleCallbacks_Factory.create(((dagger.internal.Provider) sharedSessionRepositoryImplProvider)));
      this.firebaseSessionsProvider = DoubleCheck.provider(FirebaseSessions_Factory.create(firebaseAppProvider, sessionsSettingsProvider, backgroundDispatcherProvider, sessionsActivityLifecycleCallbacksProvider));
    }

    @Override
    public FirebaseSessions getFirebaseSessions() {
      return firebaseSessionsProvider.get();
    }

    @Override
    public SessionFirelogPublisher getSessionFirelogPublisher() {
      return sessionFirelogPublisherImplProvider.get();
    }

    @Override
    public SessionGenerator getSessionGenerator() {
      return sessionGeneratorProvider.get();
    }

    @Override
    public SessionsSettings getSessionsSettings() {
      return sessionsSettingsProvider.get();
    }

    @Override
    public SharedSessionRepository getSharedSessionRepository() {
      return sharedSessionRepositoryImplProvider.get();
    }
  }
}
