/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.firebase.sessions.ProcessDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/google/firebase/sessions/ProcessDetailsProvider;", "", "<init>", "()V", "getAppProcessDetails", "", "Lcom/google/firebase/sessions/ProcessDetails;", "context", "Landroid/content/Context;", "getMyProcessDetails", "getProcessName", "", "com.google.firebase-firebase-sessions"})
@SourceDebugExtension(value={"SMAP\nProcessDetailsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDetailsProvider.kt\ncom/google/firebase/sessions/ProcessDetailsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n774#2:85\n865#2,2:86\n1557#2:88\n1628#2,3:89\n1#3:92\n*S KotlinDebug\n*F\n+ 1 ProcessDetailsProvider.kt\ncom/google/firebase/sessions/ProcessDetailsProvider\n*L\n37#1:85\n37#1:86,2\n41#1:88\n41#1:89,3\n*E\n"})
public final class ProcessDetailsProvider {
    @NotNull
    public static final ProcessDetailsProvider INSTANCE = new ProcessDetailsProvider();

    private ProcessDetailsProvider() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProcessDetails> getAppProcessDetails(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ActivityManager.RunningAppProcessInfo it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int appUid = context.getApplicationInfo().uid;
        String defaultProcessName = context.getApplicationInfo().processName;
        Object object = context.getSystemService("activity");
        ActivityManager activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
        Object object2 = activityManager;
        if (object2 == null || (object2 = object2.getRunningAppProcesses()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object runningAppProcesses = object2;
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)((Iterable)runningAppProcesses));
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ActivityManager.RunningAppProcessInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.uid == appUid)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void runningAppProcessInfo;
            it = (ActivityManager.RunningAppProcessInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = runningAppProcessInfo.processName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processName");
            collection.add(new ProcessDetails(string, runningAppProcessInfo.pid, runningAppProcessInfo.importance, Intrinsics.areEqual((Object)runningAppProcessInfo.processName, (Object)defaultProcessName)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ProcessDetails getMyProcessDetails(@NotNull Context context) {
        ProcessDetails processDetails;
        Object v0;
        int pid;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            pid = Process.myPid();
            Iterable iterable = this.getAppProcessDetails(context);
            for (Object t : iterable) {
                ProcessDetails it = (ProcessDetails)t;
                boolean bl = false;
                if (!(it.getPid() == pid)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((processDetails = (ProcessDetails)v0) == null) {
            processDetails = new ProcessDetails(this.getProcessName(), pid, 0, false);
        }
        return processDetails;
    }

    private final String getProcessName() {
        String string;
        if (Build.VERSION.SDK_INT > 33) {
            String string2 = Process.myProcessName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myProcessName(...)");
            return string2;
        }
        if (Build.VERSION.SDK_INT >= 28 && (string = Application.getProcessName()) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        string = ProcessUtils.getMyProcessName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        return "";
    }
}

