/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbqw;
import com.google.android.gms.internal.zzbrb;
import com.google.android.gms.internal.zzbrf;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzcki;
    private final Uri mUri;
    private final byte[] zzbyp;
    private final byte[] zzclJ;
    private final long zzclK;
    private final AtomicLong zzclL;
    private zzbqw zzckk;
    private InputStream zzclM;
    private boolean zzclN;
    private volatile StorageMetadata zzckN;
    private volatile Uri zzclO;
    private volatile Exception zzbLK;
    private volatile Exception zzclP;
    private volatile int mResultCode;
    private volatile String zzclQ;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzclJ = new byte[262144];
        this.zzclL = new AtomicLong(0L);
        this.zzclO = null;
        this.zzbLK = null;
        this.zzclP = null;
        this.mResultCode = 0;
        zzac.zzw((Object)storageReference);
        zzac.zzw((Object)byArray);
        this.zzbyp = byArray;
        this.zzclK = this.zzbyp.length;
        this.zzcki = storageReference;
        this.zzckN = storageMetadata;
        this.mUri = null;
        this.zzclM = new BufferedInputStream(new ByteArrayInputStream(this.zzbyp), 262144);
        this.zzclN = true;
        this.zzckk = new zzbqw(this.zzcki.getApp(), this.zzcki.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzclJ = new byte[262144];
            this.zzclL = new AtomicLong(0L);
            this.zzclO = null;
            this.zzbLK = null;
            this.zzclP = null;
            this.mResultCode = 0;
            zzac.zzw((Object)storageReference);
            zzac.zzw((Object)uri);
            this.zzbyp = null;
            this.zzcki = storageReference;
            this.zzckN = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzckk = new zzbqw(this.zzcki.getApp(), this.zzcki.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzcki.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")));
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n > 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzbLK = fileNotFoundException;
            }
        }
        this.zzclK = l;
        this.zzclM = inputStream;
        this.zzclN = true;
        this.zzclO = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzclJ = new byte[262144];
        this.zzclL = new AtomicLong(0L);
        this.zzclO = null;
        this.zzbLK = null;
        this.zzclP = null;
        this.mResultCode = 0;
        zzac.zzw((Object)storageReference);
        zzac.zzw((Object)inputStream);
        this.zzclK = -1L;
        this.zzbyp = null;
        this.zzcki = storageReference;
        this.zzckN = storageMetadata;
        this.zzclM = new BufferedInputStream(inputStream, 262144);
        this.zzclN = false;
        this.mUri = null;
        this.zzckk = new zzbqw(this.zzcki.getApp(), this.zzcki.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.zzcki;
    }

    long getTotalByteCount() {
        return this.zzclK;
    }

    @Override
    protected void schedule() {
        zzd.zzaaW().zzu(this.zzTj());
    }

    @Override
    void run() {
        this.zzckk.reset();
        if (!this.zzf(4, false)) {
            Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
            return;
        }
        if (this.zzcki.getParent() == null) {
            this.zzbLK = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.zzbLK != null) {
            return;
        }
        if (this.zzclO == null) {
            this.zzaba();
        } else {
            this.zzbd(false);
        }
        boolean bl = this.zzabb();
        while (bl) {
            this.zzabd();
            bl = this.zzabb();
            if (!bl) continue;
            this.zzf(4, false);
        }
        if (this.zzclN) {
            try {
                this.zzclM.close();
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzbLK = null;
        this.zzclP = null;
        this.mResultCode = 0;
        this.zzclQ = null;
    }

    private void zzaba() {
        Object object;
        String string = null;
        if (this.zzckN != null) {
            string = this.zzckN.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty((CharSequence)string)) {
            object = this.zzcki.getStorage().getApp().getApplicationContext();
            string = object.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "application/octet-stream";
        }
        try {
            object = this.zzcki.zzaaN().zza(this.zzcki.zzaaO(), this.zzckN != null ? this.zzckN.zzaaM() : null, string);
        }
        catch (RemoteException | JSONException throwable) {
            Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
            this.zzbLK = throwable;
            return;
        }
        if (!this.zzb((zzbrf)object)) {
            return;
        }
        String string2 = ((zzbrf)object).zzjP("X-Goog-Upload-URL");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzclO = Uri.parse((String)string2);
        }
    }

    private boolean zzabb() {
        boolean bl;
        if (this.zzaaQ() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzbLK = new InterruptedException();
            this.zzf(64, false);
            return false;
        }
        if (this.zzaaQ() == 32) {
            this.zzf(256, false);
            return false;
        }
        if (this.zzaaQ() == 8) {
            this.zzf(16, false);
            return false;
        }
        if (!this.zzabc()) {
            return false;
        }
        if (this.zzclO == null) {
            if (this.zzbLK == null) {
                this.zzbLK = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzf(64, false);
            return false;
        }
        if (this.zzbLK != null) {
            this.zzf(64, false);
            return false;
        }
        boolean bl2 = bl = this.zzclP != null || this.mResultCode < 200 || this.mResultCode >= 300;
        if (bl && !this.zzbd(true)) {
            if (this.zzabc()) {
                this.zzf(64, false);
            }
            return false;
        }
        return true;
    }

    private boolean zzabc() {
        if ("final".equals(this.zzclQ)) {
            if (this.zzbLK == null) {
                this.zzbLK = new IOException("The server has terminated the upload session");
            }
            this.zzf(64, false);
            return false;
        }
        return true;
    }

    private boolean zzbd(boolean bl) {
        zzbrf zzbrf2;
        try {
            zzbrf2 = this.zzcki.zzaaN().zzb(this.zzcki.zzaaO(), this.zzclO.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzbLK = remoteException;
            return false;
        }
        if ("final".equals(this.zzclQ)) {
            return false;
        }
        if (bl ? !this.zzb(zzbrf2) : !this.zza(zzbrf2)) {
            return false;
        }
        if ("final".equals(zzbrf2.zzjP("X-Goog-Upload-Status"))) {
            this.zzbLK = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzbrf2.zzjP("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzclL.get();
        if (l2 > l) {
            this.zzbLK = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if (this.zzclM.skip(l - l2) != l - l2) {
                    this.zzbLK = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzclL.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzbLK = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzbLK = iOException;
                return false;
            }
        }
        return true;
    }

    private void zzabd() {
        zzbrf zzbrf2;
        int n;
        this.zzclM.mark(this.zzclJ.length + 1);
        try {
            n = this.zzclM.read(this.zzclJ);
        }
        catch (IOException iOException) {
            Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
            this.zzbLK = iOException;
            return;
        }
        try {
            zzbrf2 = this.zzcki.zzaaN().zza(this.zzcki.zzaaO(), this.zzclO.toString(), this.zzclJ, this.zzclL.get(), n, (long)n != 262144L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            this.zzbLK = remoteException;
            return;
        }
        if (!this.zza(zzbrf2)) {
            try {
                this.zzclM.reset();
            }
            catch (IOException iOException) {
                Log.w((String)"UploadTask", (String)"Unable to reset the stream for error recovery.", (Throwable)iOException);
                this.zzbLK = iOException;
            }
            return;
        }
        if (n != -1) {
            this.zzclL.getAndAdd(n);
        }
        if ((long)n != 262144L) {
            try {
                this.zzckN = new StorageMetadata.Builder(zzbrf2.zzabq(), this.zzcki).build();
            }
            catch (RemoteException | JSONException throwable) {
                String string = String.valueOf(zzbrf2.zzabk());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                this.zzbLK = throwable;
                return;
            }
            this.zzf(4, false);
            this.zzf(128, false);
        }
    }

    private boolean zzpW(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    private boolean zza(zzbrf zzbrf2) {
        zzbrf2.zza(zzbrb.zzi(this.zzcki.getApp()), this.zzcki.getApp().getApplicationContext());
        return this.zzc(zzbrf2);
    }

    private boolean zzb(zzbrf zzbrf2) {
        this.zzckk.zzd(zzbrf2);
        return this.zzc(zzbrf2);
    }

    private boolean zzc(zzbrf zzbrf2) {
        int n = zzbrf2.getResultCode();
        this.mResultCode = this.zzckk.zzqa(n) ? -2 : n;
        this.zzclP = zzbrf2.getException();
        this.zzclQ = zzbrf2.zzjP("X-Goog-Upload-Status");
        return this.zzpW(this.mResultCode) && this.zzclP == null;
    }

    @Override
    protected void onCanceled() {
        this.zzckk.cancel();
        zzbrf zzbrf2 = null;
        if (this.zzclO != null) {
            try {
                zzbrf2 = this.zzcki.zzaaN().zza(this.zzcki.zzaaO(), this.zzclO.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzbrf2 != null) {
            final zzbrf zzbrf3 = zzbrf2;
            zzd.zzaaW().zzt(new Runnable(){

                @Override
                public void run() {
                    zzbrf3.zza(zzbrb.zzi(UploadTask.this.zzcki.getApp()), UploadTask.this.zzcki.getApp().getApplicationContext());
                }
            });
        }
        this.zzbLK = StorageException.fromErrorStatus(Status.zzayl);
        super.onCanceled();
    }

    @NonNull
    TaskSnapshot zzabe() {
        Exception exception = this.zzbLK != null ? this.zzbLK : this.zzclP;
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, this.mResultCode)), this.zzclL.get(), this.zzclO, this.zzckN);
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzaaK() {
        return this.zzabe();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzclT;
        private final Uri zzclO;
        private final StorageMetadata zzckN;

        TaskSnapshot(Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            super(exception);
            this.zzclT = l;
            this.zzclO = uri;
            this.zzckN = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzclT;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzclO;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzckN;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

