/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzbqw;
import com.google.android.gms.internal.zzbrf;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzckl;
    private long zzckm;
    private StorageReference zzcki;
    private zzbqw zzckk;
    private long zzaKG = -1L;
    private String zzckn = null;
    private volatile Exception zzbLK = null;
    private long zzcko = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzcki = storageReference;
        this.zzckl = uri;
        this.zzckk = new zzbqw(this.zzcki.getStorage().getApp(), this.zzcki.getStorage().getMaxDownloadRetryTimeMillis());
    }

    long getTotalBytes() {
        return this.zzaKG;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.zzcki;
    }

    @Override
    protected void schedule() {
        zzd.zzaaW().zzv(this.zzTj());
    }

    @NonNull
    TaskSnapshot zzaaJ() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.zzbLK, this.mResultCode)), this.zzckm);
    }

    @Override
    void run() {
        Object object;
        boolean bl;
        zzbrf zzbrf2;
        if (!this.zzf(4, false)) {
            return;
        }
        this.zzckk.reset();
        try {
            zzbrf2 = this.zzcki.zzaaN().zza(this.zzcki.zzaaO(), this.zzcko);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.zzbLK = remoteException;
            this.zzf(64, false);
            return;
        }
        this.zzckk.zza(zzbrf2, false);
        this.mResultCode = zzbrf2.getResultCode();
        this.zzbLK = zzbrf2.getException() != null ? zzbrf2.getException() : this.zzbLK;
        boolean bl2 = bl = this.zzpW(this.mResultCode) && this.zzbLK == null && this.zzaaQ() == 4;
        if (bl) {
            this.zzaKG = zzbrf2.zzabo();
            object = zzbrf2.zzjP("ETag");
            if (!TextUtils.isEmpty((CharSequence)object) && this.zzckn != null && !this.zzckn.equals(object)) {
                Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                this.zzcko = 0L;
                this.zzckn = null;
                zzbrf2.zzabh();
                this.schedule();
                return;
            }
            this.zzckn = object;
            InputStream inputStream = zzbrf2.getStream();
            if (inputStream != null) {
                try {
                    int n;
                    FileOutputStream fileOutputStream;
                    File file = new File(this.zzckl.getPath());
                    if (!file.exists()) {
                        if (this.zzcko > 0L) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                            throw new IllegalStateException("expected a file to resume from.");
                        }
                        boolean bl3 = file.createNewFile();
                        if (!bl3) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                        }
                    }
                    if (this.zzcko > 0L) {
                        String string = String.valueOf(file.getAbsolutePath());
                        Log.d((String)"FileDownloadTask", (String)(string.length() != 0 ? "Resuming download file ".concat(string) : new String("Resuming download file ")));
                        fileOutputStream = new FileOutputStream(file, true);
                    } else {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    byte[] byArray = new byte[262144];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        this.zzckm += (long)n;
                        if (this.zzf(4, false)) continue;
                    }
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    inputStream.close();
                }
                catch (Exception exception) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file download", (Throwable)exception);
                    this.zzbLK = exception;
                }
            } else {
                this.zzbLK = new IllegalStateException("Unable to open Firebase Storage stream.");
            }
        }
        zzbrf2.zzabh();
        boolean bl4 = bl = bl && this.zzbLK == null && this.zzaaQ() == 4;
        if (bl) {
            this.zzf(128, false);
        } else {
            object = new File(this.zzckl.getPath());
            this.zzcko = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzaaQ() == 8) {
                this.zzf(16, false);
            } else if (!this.zzf(this.zzaaQ() == 32 ? 256 : 64, false)) {
                int n = this.zzaaQ();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
            }
        }
    }

    @Override
    protected void onCanceled() {
        this.zzckk.cancel();
    }

    private boolean zzpW(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzaaK() {
        return this.zzaaJ();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzckm;

        TaskSnapshot(Exception exception, long l) {
            super(FileDownloadTask.this, exception);
            this.zzckm = l;
        }

        public long getBytesTransferred() {
            return this.zzckm;
        }

        public long getTotalByteCount() {
            return FileDownloadTask.this.getTotalBytes();
        }
    }
}

