/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public class zzbtu {
    private static final Runtime zzcot = Runtime.getRuntime();
    private final InputStream zzcou;
    private byte[] buffer;
    private int zzcov;
    private boolean zzcow;
    private boolean zzcox;

    public zzbtu(InputStream inputStream, int n) {
        this.zzcou = inputStream;
        this.buffer = new byte[n];
        this.zzcov = 0;
        this.zzcox = true;
        this.zzcow = false;
    }

    public int available() {
        return this.zzcov;
    }

    public byte[] zzacU() {
        return this.buffer;
    }

    public int zzqN(int n) throws IOException {
        int n2;
        if (n <= this.zzcov) {
            this.zzcov -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzcov);
            n2 = n;
        } else {
            n2 = this.zzcov = 0;
            while (n2 < n) {
                long l = this.zzcou.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzcou.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public int zzqO(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzqP(n));
        }
        while (this.zzcov < n) {
            int n2 = this.zzcou.read(this.buffer, this.zzcov, n - this.zzcov);
            if (n2 == -1) {
                this.zzcow = true;
                break;
            }
            this.zzcov += n2;
        }
        return this.zzcov;
    }

    private int zzqP(int n) {
        int n2 = Math.max(this.buffer.length * 2, n);
        if (this.zzcox && (long)(n2 + 262144) < zzcot.freeMemory()) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzcov);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzcox = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public boolean isFinished() {
        return this.zzcow;
    }

    public void close() throws IOException {
        this.zzcou.close();
    }
}

