/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzbub;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public class zzbue {
    private zzbub zzcoE;
    private Exception zzbNL;
    private int zzcoF;
    private Exception zzcoG;

    public zzbue(@NonNull zzbub zzbub2) {
        this.zzcoE = zzbub2;
    }

    public void zzaD(String string, String string2) {
        try {
            this.zzcoE.zzaD(string, string2);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
        }
    }

    private boolean zzcC(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzcoF = -2;
            this.zzcoG = new SocketException("Network subsystem is unavailable");
            return false;
        }
        return true;
    }

    @Nullable
    public String zzjO(String string) {
        try {
            return this.zzcoE.zzjO(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public void zzd(@Nullable String string, @NonNull Context context) {
        try {
            if (!this.zzcC(context)) {
                return;
            }
            this.zzcoE.zzjM(string);
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void reset() {
        try {
            this.zzcoF = 0;
            this.zzcoG = null;
            this.zzcoE.reset();
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzjN(@Nullable String string) {
        try {
            this.zzcoE.zzjN(string);
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzacV() {
        try {
            if (this.zzcoE != null) {
                this.zzcoE.zzacV();
            }
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    @Nullable
    public InputStream getStream() {
        try {
            return (InputStream)zzd.zzF((IObjectWrapper)this.zzcoE.zzacW());
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public JSONObject zzade() throws RemoteException {
        return (JSONObject)zzd.zzF((IObjectWrapper)this.zzcoE.zzacX());
    }

    @Nullable
    public String zzacY() {
        try {
            this.zzcoE.zzacY();
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public Exception getException() {
        try {
            if (this.zzcoG != null) {
                return this.zzcoG;
            }
            return this.zzbNL != null ? this.zzbNL : (Exception)zzd.zzF((IObjectWrapper)this.zzcoE.zzada());
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public int getResultCode() {
        try {
            if (this.zzcoF != 0) {
                return this.zzcoF;
            }
            return this.zzcoE.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public boolean zzadb() {
        try {
            if (this.zzcoF == -2 || this.zzcoG != null) {
                return false;
            }
            return this.zzcoE.zzadb();
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzadb() && exception == null) {
            taskCompletionSource.setResult(TResult);
        } else {
            StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (storageException != null);
            taskCompletionSource.setException((Exception)((Object)storageException));
        }
    }

    public int zzadc() {
        try {
            return this.zzcoE.zzadc();
        }
        catch (RemoteException remoteException) {
            this.zzbNL = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

