/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbtw;
import com.google.android.gms.internal.zzbua;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzcmQ = null;
    private StorageReference zzcmy = null;
    private String zzcmR = null;
    private String zzcmS = null;
    private String zzaoj = null;
    private String zzcmT = null;
    private String zzcmU = null;
    private String zzcmV = null;
    private long zzcmW;
    private String zzcmX = null;
    private String zzcmY = null;
    private String zzcmZ = null;
    private String zzcna = null;
    private String zzcnb = null;
    private Map<String, String> zzcnc = null;
    private String[] zzcnd = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzac.zzw((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzcmQ = storageMetadata.zzcmQ;
        this.zzcmy = storageMetadata.zzcmy;
        this.zzcmR = storageMetadata.zzcmR;
        this.zzaoj = storageMetadata.zzaoj;
        this.zzcmY = storageMetadata.zzcmY;
        this.zzcmZ = storageMetadata.zzcmZ;
        this.zzcna = storageMetadata.zzcna;
        this.zzcnb = storageMetadata.zzcnb;
        if (storageMetadata.zzcnc != null) {
            this.zzcnc = new HashMap<String, String>(storageMetadata.zzcnc);
        }
        this.zzcnd = storageMetadata.zzcnd;
        if (bl) {
            this.zzcmX = storageMetadata.zzcmX;
            this.zzcmW = storageMetadata.zzcmW;
            this.zzcmV = storageMetadata.zzcmV;
            this.zzcmU = storageMetadata.zzcmU;
            this.zzcmT = storageMetadata.zzcmT;
            this.zzcmS = storageMetadata.zzcmS;
        }
    }

    public String getContentType() {
        return this.zzaoj;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzcnc == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzcnc.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzcnc == null) {
            return Collections.emptySet();
        }
        return this.zzcnc.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzcmR;
    }

    @Nullable
    public String getGeneration() {
        return this.zzcmS;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzcmT;
    }

    public long getCreationTimeMillis() {
        return zzbua.zzjL(this.zzcmU);
    }

    public long getUpdatedTimeMillis() {
        return zzbua.zzjL(this.zzcmV);
    }

    public long getSizeBytes() {
        return this.zzcmW;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzcmX;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzcnd != null && this.zzcmy != null) {
            try {
                String string = this.zzcmy.zzacx().zzA(this.zzcmy.zzacy());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    for (String string2 : this.zzcnd) {
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzcmY;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzcmZ;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzcna;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzcnb;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzcmy == null && this.zzcmQ != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzbtw.zzjI((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzcmQ);
        }
        return this.zzcmy;
    }

    @NonNull
    JSONObject zzacw() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzcnc != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzcnc));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private void zzjH(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzcnd = string.split(",");
        }
    }

    public static class Builder {
        StorageMetadata zzcne;
        boolean zzcnf;

        public Builder() {
            this.zzcne = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzcne = new StorageMetadata(storageMetadata, false);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzcne.zzcmy = storageReference;
        }

        Builder(JSONObject jSONObject) throws JSONException {
            this.zzcne = new StorageMetadata();
            if (jSONObject != null) {
                this.zzu(jSONObject);
                this.zzcnf = true;
            }
        }

        private void zzu(JSONObject jSONObject) throws JSONException {
            this.zzcne.zzcmS = jSONObject.optString("generation");
            this.zzcne.mPath = jSONObject.optString("name");
            this.zzcne.zzcmR = jSONObject.optString("bucket");
            this.zzcne.zzcmT = jSONObject.optString("metageneration");
            this.zzcne.zzcmU = jSONObject.optString("timeCreated");
            this.zzcne.zzcmV = jSONObject.optString("updated");
            this.zzcne.zzcmW = jSONObject.optLong("size");
            this.zzcne.zzcmX = jSONObject.optString("md5Hash");
            this.zzcne.zzjH(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzcne, this.zzcnf);
        }

        public Builder setContentLanguage(String string) {
            this.zzcne.zzcnb = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzcne.zzcna = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzcne.zzcmZ = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzcne.zzcmY = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzcne.zzcnc == null) {
                this.zzcne.zzcnc = new HashMap();
            }
            this.zzcne.zzcnc.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzcne.zzaoj = string;
            return this;
        }
    }
}

