/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbtv;
import com.google.android.gms.internal.zzbue;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzcmy;
    private zzbtv zzcmA;
    private volatile Exception zzbNL = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzcnJ;
    private long zzaMd = -1L;
    private long zzcmC;
    private long zzcnK;
    private InputStream zzbUf;
    private zzbue zzcnL;
    private String zzcmD;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzcmy = storageReference;
        this.zzcmA = new zzbtv(this.zzcmy.getApp(), this.zzcmy.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzac.zzw((Object)streamProcessor);
        zzac.zzaw((this.zzcnJ == null ? 1 : 0) != 0);
        this.zzcnJ = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.zzcmy;
    }

    long getTotalBytes() {
        return this.zzaMd;
    }

    void zzaX(long l) {
        this.zzcmC += l;
        if (this.zzcnK + 262144L <= this.zzcmC) {
            if (this.zzacA() == 4) {
                this.zzf(4, false);
            } else {
                this.zzcnK = this.zzcmC;
            }
        }
    }

    @Override
    protected void schedule() {
        zzd.zzacG().zzw(this.zzUK());
    }

    private InputStream zzacH() throws Exception {
        boolean bl;
        this.zzcmA.reset();
        if (this.zzcnL != null) {
            this.zzcnL.zzacV();
        }
        try {
            this.zzcnL = this.zzcmy.zzacx().zza(this.zzcmy.zzacy(), this.zzcmC);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzcmA.zza(this.zzcnL, false);
        this.mResultCode = this.zzcnL.getResultCode();
        this.zzbNL = this.zzcnL.getException() != null ? this.zzcnL.getException() : this.zzbNL;
        boolean bl2 = bl = this.zzqJ(this.mResultCode) && this.zzbNL == null && this.zzacA() == 4;
        if (bl) {
            String string = this.zzcnL.zzjO("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzcmD != null && !this.zzcmD.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzcmD = string;
            if (this.zzaMd == -1L) {
                this.zzaMd = this.zzcnL.zzadc();
            }
            return this.zzcnL.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    void run() {
        boolean bl;
        if (this.zzbNL != null) {
            this.zzf(64, false);
            return;
        }
        if (!this.zzf(4, false)) {
            return;
        }
        zza zza2 = new zza(new Callable<InputStream>(){

            public InputStream zzacJ() throws Exception {
                return StreamDownloadTask.this.zzacH();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzacJ();
            }
        }, this);
        this.zzbUf = new BufferedInputStream(zza2);
        try {
            zza2.zzacL();
            if (this.zzcnJ != null) {
                try {
                    this.zzcnJ.doInBackground((TaskSnapshot)this.zzacC(), this.zzbUf);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzbNL = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzbNL = iOException;
        }
        if (this.zzbUf == null) {
            this.zzcnL.zzacV();
            this.zzcnL = null;
        }
        boolean bl2 = bl = this.zzbNL == null && this.zzacA() == 4;
        if (bl) {
            this.zzf(4, false);
            this.zzf(128, false);
        } else if (!this.zzf(this.zzacA() == 32 ? 256 : 64, false)) {
            int n = this.zzacA();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @NonNull
    TaskSnapshot zzacI() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.zzbNL, this.mResultCode)), this.zzcnK);
    }

    @Override
    protected void onCanceled() {
        this.zzcmA.cancel();
        this.zzbNL = StorageException.fromErrorStatus(Status.zzazB);
    }

    @Override
    protected void onProgress() {
        this.zzcnK = this.zzcmC;
    }

    private boolean zzqJ(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzacu() {
        return this.zzacI();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcmC;

        TaskSnapshot(Exception exception, long l) {
            super(exception);
            this.zzcmC = l;
        }

        public long getBytesTransferred() {
            return this.zzcmC;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        public InputStream getStream() {
            return StreamDownloadTask.this.zzbUf;
        }
    }

    static class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzcnN;
        @Nullable
        private InputStream zzcnO;
        private Callable<InputStream> zzcnP;
        private IOException zzcnQ;
        private int zzcnR;
        private int zzcnS;
        private boolean zzcnT;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzcnN = streamDownloadTask;
            this.zzcnP = callable;
        }

        private void zzacK() throws IOException {
            if (this.zzcnN != null && this.zzcnN.zzacA() == 32) {
                throw StorageException.zzcmM;
            }
        }

        private void zzaX(long l) {
            if (this.zzcnN != null) {
                this.zzcnN.zzaX(l);
            }
            this.zzcnR = (int)((long)this.zzcnR + l);
        }

        private boolean zzacL() throws IOException {
            this.zzacK();
            if (this.zzcnQ != null) {
                try {
                    if (this.zzcnO != null) {
                        this.zzcnO.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzcnO = null;
                if (this.zzcnS == this.zzcnR) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzcnQ);
                    return false;
                }
                int n = this.zzcnR;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzcnQ);
                this.zzcnS = this.zzcnR;
                this.zzcnQ = null;
            }
            if (this.zzcnT) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzcnO == null) {
                try {
                    this.zzcnO = this.zzcnP.call();
                }
                catch (Exception exception) {
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new IOException("Unable to open stream", exception);
                }
            }
            return true;
        }

        @Override
        public int read() throws IOException {
            while (this.zzacL()) {
                try {
                    int n = this.zzcnO.read();
                    if (n != -1) {
                        this.zzaX(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcnQ = iOException;
                }
            }
            throw this.zzcnQ;
        }

        @Override
        public int available() throws IOException {
            while (this.zzacL()) {
                try {
                    return this.zzcnO.available();
                }
                catch (IOException iOException) {
                    this.zzcnQ = iOException;
                }
            }
            throw this.zzcnQ;
        }

        @Override
        public void close() throws IOException {
            if (this.zzcnO != null) {
                this.zzcnO.close();
            }
            this.zzcnT = true;
            if (this.zzcnN != null && this.zzcnN.zzcnL != null) {
                this.zzcnN.zzcnL.zzacV();
                this.zzcnN.zzcnL = null;
            }
            this.zzacK();
        }

        @Override
        public void mark(int n) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzacL()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzcnO.read(byArray, n, 262144);
                        if (n4 == -1) {
                            return n3 == 0 ? -1 : n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzaX(n4);
                        this.zzacK();
                    }
                    if (n2 > 0) {
                        n4 = this.zzcnO.read(byArray, n, n2);
                        if (n4 == -1) {
                            return n3 == 0 ? -1 : n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzaX(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzcnQ = iOException;
                }
            }
            throw this.zzcnQ;
        }

        @Override
        public long skip(long l) throws IOException {
            int n = 0;
            while (this.zzacL()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzcnO.skip(262144L);
                        n = (int)((long)n + l2);
                        if (l2 < 262144L) {
                            this.zzaX(l2);
                            return n;
                        }
                        this.zzcnN.zzaX(262144L);
                        l -= 262144L;
                        this.zzacK();
                    }
                    l2 = this.zzcnO.skip(l);
                    n = (int)((long)n + l2);
                    l -= l2;
                    this.zzaX(l2);
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcnQ = iOException;
                }
            }
            throw this.zzcnQ;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

