/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzbtv;
import com.google.android.gms.internal.zzbue;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzcmJ;
    private long zzcmK;
    private StorageReference zzcmG;
    private zzbtv zzcmI;
    private long zzaMd = -1L;
    private String zzcmL = null;
    private volatile Exception zzbNH = null;
    private long zzcmM = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzcmG = storageReference;
        this.zzcmJ = uri;
        this.zzcmI = new zzbtv(this.zzcmG.getStorage().getApp(), this.zzcmG.getStorage().getMaxDownloadRetryTimeMillis());
    }

    long getTotalBytes() {
        return this.zzaMd;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.zzcmG;
    }

    @Override
    protected void schedule() {
        zzd.zzacH().zzw(this.zzUL());
    }

    @NonNull
    TaskSnapshot zzacu() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.zzbNH, this.mResultCode)), this.zzcmK + this.zzcmM);
    }

    private int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzbNH = iOException;
        }
        return bl ? n : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zzbue zzbue2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzbue2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            File file = new File(this.zzcmJ.getPath());
            if (!file.exists()) {
                if (this.zzcmM > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                boolean bl2 = file.createNewFile();
                if (!bl2) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzcmM > 0L) {
                String string = String.valueOf(file.getAbsolutePath());
                long l = this.zzcmM;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Resuming download file ").append(string).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                byte[] byArray = new byte[262144];
                while (bl && (n = this.zza(inputStream, byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    this.zzcmK += (long)n;
                    if (this.zzbNH != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzbNH);
                        this.zzbNH = null;
                        bl = false;
                    }
                    if (this.zzf(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzbNH = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    void run() {
        if (this.zzbNH != null) {
            this.zzf(64, false);
            return;
        }
        if (!this.zzf(4, false)) {
            return;
        }
        do {
            Object object;
            boolean bl;
            zzbue zzbue2;
            this.zzcmK = 0L;
            this.zzbNH = null;
            this.zzcmI.reset();
            try {
                zzbue2 = this.zzcmG.zzacy().zza(this.zzcmG.zzacz(), this.zzcmM);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzbNH = remoteException;
                this.zzf(64, false);
                return;
            }
            this.zzcmI.zza(zzbue2, false);
            this.mResultCode = zzbue2.getResultCode();
            this.zzbNH = zzbue2.getException() != null ? zzbue2.getException() : this.zzbNH;
            boolean bl2 = bl = this.zzqK(this.mResultCode) && this.zzbNH == null && this.zzacB() == 4;
            if (bl) {
                this.zzaMd = zzbue2.zzadd();
                object = zzbue2.zzjO("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzcmL != null && !this.zzcmL.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzcmM = 0L;
                    this.zzcmL = null;
                    zzbue2.zzacW();
                    this.schedule();
                    return;
                }
                this.zzcmL = object;
                try {
                    bl = this.zza(zzbue2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzbNH = iOException;
                }
            }
            zzbue2.zzacW();
            boolean bl3 = bl = bl && this.zzbNH == null && this.zzacB() == 4;
            if (bl) {
                this.zzf(128, false);
                return;
            }
            object = new File(this.zzcmJ.getPath());
            this.zzcmM = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzacB() == 8) {
                this.zzf(16, false);
                return;
            }
            if (this.zzacB() != 32) continue;
            if (!this.zzf(256, false)) {
                int n = this.zzacB();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
            }
            return;
        } while (this.zzcmK > 0L);
        this.zzf(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzcmI.cancel();
        this.zzbNH = StorageException.fromErrorStatus(Status.zzazB);
    }

    private boolean zzqK(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzacv() {
        return this.zzacu();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcmK;

        TaskSnapshot(Exception exception, long l) {
            super(FileDownloadTask.this, exception);
            this.zzcmK = l;
        }

        public long getBytesTransferred() {
            return this.zzcmK;
        }

        public long getTotalByteCount() {
            return FileDownloadTask.this.getTotalBytes();
        }
    }
}

