/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzbub;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public class zzbue {
    private zzbub zzcoM;
    private Exception zzbNH;
    private int zzcoN;
    private Exception zzcoO;

    public zzbue(@NonNull zzbub zzbub2) {
        this.zzcoM = zzbub2;
    }

    public void zzaD(String string, String string2) {
        try {
            this.zzcoM.zzaD(string, string2);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
        }
    }

    private boolean zzcB(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzcoN = -2;
            this.zzcoO = new SocketException("Network subsystem is unavailable");
            return false;
        }
        return true;
    }

    @Nullable
    public String zzjO(String string) {
        try {
            return this.zzcoM.zzjO(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public void zzd(@Nullable String string, @NonNull Context context) {
        try {
            if (!this.zzcB(context)) {
                return;
            }
            this.zzcoM.zzjM(string);
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void reset() {
        try {
            this.zzcoN = 0;
            this.zzcoO = null;
            this.zzcoM.reset();
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzjN(@Nullable String string) {
        try {
            this.zzcoM.zzjN(string);
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzacW() {
        try {
            this.zzcoM.zzacW();
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    @Nullable
    public InputStream getStream() {
        try {
            return (InputStream)zzd.zzF((IObjectWrapper)this.zzcoM.zzacX());
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public JSONObject zzadf() throws RemoteException {
        return (JSONObject)zzd.zzF((IObjectWrapper)this.zzcoM.zzacY());
    }

    @Nullable
    public String zzacZ() {
        try {
            this.zzcoM.zzacZ();
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public Exception getException() {
        try {
            if (this.zzcoO != null) {
                return this.zzcoO;
            }
            return this.zzbNH != null ? this.zzbNH : (Exception)zzd.zzF((IObjectWrapper)this.zzcoM.zzadb());
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public int getResultCode() {
        try {
            if (this.zzcoN != 0) {
                return this.zzcoN;
            }
            return this.zzcoM.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public boolean zzadc() {
        try {
            if (this.zzcoN == -2 || this.zzcoO != null) {
                return false;
            }
            return this.zzcoM.zzadc();
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzadc() && exception == null) {
            taskCompletionSource.setResult(TResult);
        } else {
            StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (storageException != null);
            taskCompletionSource.setException((Exception)((Object)storageException));
        }
    }

    public int zzadd() {
        try {
            return this.zzcoM.zzadd();
        }
        catch (RemoteException remoteException) {
            this.zzbNH = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

