/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbtw;
import com.google.android.gms.internal.zzbud;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.FileDownloadTask;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.StreamDownloadTask;
import com.google.firebase.storage.UploadTask;
import com.google.firebase.storage.zza;
import com.google.firebase.storage.zzb;
import com.google.firebase.storage.zzc;
import com.google.firebase.storage.zzd;
import com.google.firebase.storage.zzf;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class StorageReference {
    private final Uri zzcno;
    private final FirebaseStorage zzcnp;

    StorageReference(@NonNull Uri uri, @NonNull FirebaseStorage firebaseStorage) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"storageUri cannot be null");
        zzac.zzb((firebaseStorage != null ? 1 : 0) != 0, (Object)"FirebaseApp cannot be null");
        this.zzcno = uri;
        this.zzcnp = firebaseStorage;
    }

    @NonNull
    public StorageReference child(@NonNull String string) {
        Uri uri;
        zzac.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"childName cannot be null or empty");
        string = zzbtw.zzjK((String)string);
        try {
            uri = this.zzcno.buildUpon().appendEncodedPath(zzbtw.zzjI((String)string)).build();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = String.valueOf(string);
            Log.e((String)"StorageReference", (String)(string2.length() != 0 ? "Unable to create a valid default Uri. ".concat(string2) : new String("Unable to create a valid default Uri. ")), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException("childName");
        }
        return new StorageReference(uri, this.zzcnp);
    }

    @Nullable
    public StorageReference getParent() {
        String string = this.zzcno.getPath();
        if (string == null || string.equals("/")) {
            return null;
        }
        int n = string.lastIndexOf(47);
        string = n == -1 ? "/" : string.substring(0, n);
        Uri uri = this.zzcno.buildUpon().path(string).build();
        return new StorageReference(uri, this.zzcnp);
    }

    @NonNull
    public StorageReference getRoot() {
        Uri uri = this.zzcno.buildUpon().path("").build();
        return new StorageReference(uri, this.zzcnp);
    }

    @NonNull
    public String getName() {
        String string = this.zzcno.getPath();
        assert (string != null);
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @NonNull
    public String getPath() {
        String string = this.zzcno.getPath();
        assert (string != null);
        return string;
    }

    @NonNull
    public String getBucket() {
        return this.zzcno.getAuthority();
    }

    @NonNull
    public FirebaseStorage getStorage() {
        return this.zzcnp;
    }

    @NonNull
    FirebaseApp getApp() {
        return this.getStorage().getApp();
    }

    @NonNull
    zzbud zzacy() throws RemoteException {
        return zzbud.zzj(this.getApp());
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray) {
        zzac.zzb((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, byArray);
        uploadTask.zzacA();
        return uploadTask;
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray, @NonNull StorageMetadata storageMetadata) {
        zzac.zzb((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        zzac.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, byArray);
        uploadTask.zzacA();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, uri, null);
        uploadTask.zzacA();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @NonNull StorageMetadata storageMetadata) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzac.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, null);
        uploadTask.zzacA();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @Nullable StorageMetadata storageMetadata, @Nullable Uri uri2) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzac.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, uri2);
        uploadTask.zzacA();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream) {
        zzac.zzb((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, inputStream);
        uploadTask.zzacA();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream, @NonNull StorageMetadata storageMetadata) {
        zzac.zzb((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        zzac.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, inputStream);
        uploadTask.zzacA();
        return uploadTask;
    }

    @NonNull
    public List<UploadTask> getActiveUploadTasks() {
        return zzc.zzacG().zza(this);
    }

    @NonNull
    public List<FileDownloadTask> getActiveDownloadTasks() {
        return zzc.zzacG().zzb(this);
    }

    @NonNull
    public Task<StorageMetadata> getMetadata() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd.zzacH().zzu(new zzb(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Uri> getDownloadUrl() {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Task<StorageMetadata> task = this.getMetadata();
        task.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<StorageMetadata>(this){

            public void zzb(StorageMetadata storageMetadata) {
                taskCompletionSource.setResult((Object)storageMetadata.getDownloadUrl());
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.zzb((StorageMetadata)object);
            }
        });
        task.addOnFailureListener(new OnFailureListener(this){

            public void onFailure(@NonNull Exception exception) {
                taskCompletionSource.setException(exception);
            }
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<StorageMetadata> updateMetadata(@NonNull StorageMetadata storageMetadata) {
        zzac.zzw((Object)storageMetadata);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd.zzacH().zzu(new zzf(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource, storageMetadata));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<byte[]> getBytes(final long l) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        ((StorageTask)streamDownloadTask.zza(new StreamDownloadTask.StreamProcessor(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doInBackground(StreamDownloadTask.TaskSnapshot taskSnapshot, InputStream inputStream) throws IOException {
                try {
                    int n;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n2 = 0;
                    byte[] byArray = new byte[16384];
                    while ((n = inputStream.read(byArray, 0, 16384)) != -1) {
                        if ((long)(n2 += n) > l) {
                            Log.e((String)"StorageReference", (String)"the maximum allowed buffer size was exceeded.");
                            throw new IndexOutOfBoundsException("the maximum allowed buffer size was exceeded.");
                        }
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byteArrayOutputStream.flush();
                    taskCompletionSource.setResult((Object)byteArrayOutputStream.toByteArray());
                }
                finally {
                    inputStream.close();
                }
            }
        }).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<StreamDownloadTask.TaskSnapshot>(this){

            public void zza(StreamDownloadTask.TaskSnapshot taskSnapshot) {
                if (!taskCompletionSource.getTask().isComplete()) {
                    Log.e((String)"StorageReference", (String)"getBytes 'succeeded', but failed to set a Result.");
                    taskCompletionSource.setException((Exception)((Object)StorageException.fromErrorStatus(Status.zzazz)));
                }
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.zza((StreamDownloadTask.TaskSnapshot)object);
            }
        })).addOnFailureListener(new OnFailureListener(this){

            public void onFailure(@NonNull Exception exception) {
                StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, 0);
                assert (storageException != null);
                taskCompletionSource.setException((Exception)((Object)storageException));
            }
        });
        streamDownloadTask.zzacA();
        return taskCompletionSource.getTask();
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull Uri uri) {
        FileDownloadTask fileDownloadTask = new FileDownloadTask(this, uri);
        fileDownloadTask.zzacA();
        return fileDownloadTask;
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull File file) {
        return this.getFile(Uri.fromFile((File)file));
    }

    @NonNull
    public StreamDownloadTask getStream() {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zzacA();
        return streamDownloadTask;
    }

    @NonNull
    public StreamDownloadTask getStream(@NonNull StreamDownloadTask.StreamProcessor streamProcessor) {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zza(streamProcessor);
        streamDownloadTask.zzacA();
        return streamDownloadTask;
    }

    public Task<Void> delete() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd.zzacH().zzu(new zza(this, (TaskCompletionSource<Void>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    Uri zzacz() {
        return this.zzcno;
    }

    public String toString() {
        String string = String.valueOf(this.zzcno.getAuthority());
        String string2 = String.valueOf(this.zzcno.getEncodedPath());
        return new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length()).append("gs://").append(string).append(string2).toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StorageReference)) {
            return false;
        }
        StorageReference storageReference = (StorageReference)object;
        return storageReference.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

