/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbtv;
import com.google.android.gms.internal.zzbue;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzcmG;
    private zzbtv zzcmI;
    private volatile Exception zzbNH = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzcnR;
    private long zzaMd = -1L;
    private long zzcmK;
    private long zzcnS;
    private InputStream zzbUb;
    private zzbue zzcnT;
    private String zzcmL;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzcmG = storageReference;
        this.zzcmI = new zzbtv(this.zzcmG.getApp(), this.zzcmG.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzac.zzw((Object)streamProcessor);
        zzac.zzaw((this.zzcnR == null ? 1 : 0) != 0);
        this.zzcnR = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.zzcmG;
    }

    long getTotalBytes() {
        return this.zzaMd;
    }

    void zzaX(long l) {
        this.zzcmK += l;
        if (this.zzcnS + 262144L <= this.zzcmK) {
            if (this.zzacB() == 4) {
                this.zzf(4, false);
            } else {
                this.zzcnS = this.zzcmK;
            }
        }
    }

    @Override
    protected void schedule() {
        zzd.zzacH().zzw(this.zzUL());
    }

    private InputStream zzacI() throws Exception {
        boolean bl;
        this.zzcmI.reset();
        if (this.zzcnT != null) {
            this.zzcnT.zzacW();
        }
        try {
            this.zzcnT = this.zzcmG.zzacy().zza(this.zzcmG.zzacz(), this.zzcmK);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzcmI.zza(this.zzcnT, false);
        this.mResultCode = this.zzcnT.getResultCode();
        this.zzbNH = this.zzcnT.getException() != null ? this.zzcnT.getException() : this.zzbNH;
        boolean bl2 = bl = this.zzqK(this.mResultCode) && this.zzbNH == null && this.zzacB() == 4;
        if (bl) {
            String string = this.zzcnT.zzjO("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzcmL != null && !this.zzcmL.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzcmL = string;
            if (this.zzaMd == -1L) {
                this.zzaMd = this.zzcnT.zzadd();
            }
            return this.zzcnT.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    void run() {
        boolean bl;
        if (this.zzbNH != null) {
            this.zzf(64, false);
            return;
        }
        if (!this.zzf(4, false)) {
            return;
        }
        this.zzbUb = new BufferedInputStream(new zza(new Callable<InputStream>(){

            public InputStream zzacK() throws Exception {
                return StreamDownloadTask.this.zzacI();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzacK();
            }
        }, this));
        if (this.zzcnR != null) {
            try {
                this.zzcnR.doInBackground((TaskSnapshot)this.zzacD(), this.zzbUb);
            }
            catch (Exception exception) {
                Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                this.zzbNH = exception;
            }
        }
        if (this.zzbUb == null) {
            this.zzcnT.zzacW();
            this.zzcnT = null;
        }
        boolean bl2 = bl = this.zzbNH == null && this.zzacB() == 4;
        if (bl) {
            this.zzf(4, false);
            this.zzf(128, false);
        } else if (!this.zzf(this.zzacB() == 32 ? 256 : 64, false)) {
            int n = this.zzacB();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @NonNull
    TaskSnapshot zzacJ() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.zzbNH, this.mResultCode)), this.zzcnS);
    }

    @Override
    protected void onCanceled() {
        this.zzcmI.cancel();
        this.zzbNH = StorageException.fromErrorStatus(Status.zzazB);
    }

    @Override
    protected void onProgress() {
        this.zzcnS = this.zzcmK;
    }

    private boolean zzqK(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzacv() {
        return this.zzacJ();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcmK;

        TaskSnapshot(Exception exception, long l) {
            super(exception);
            this.zzcmK = l;
        }

        public long getBytesTransferred() {
            return this.zzcmK;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        public InputStream getStream() {
            return StreamDownloadTask.this.zzbUb;
        }
    }

    static class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzcnV;
        @Nullable
        private InputStream zzcnW;
        private Callable<InputStream> zzcnX;
        private IOException zzcnY;
        private int zzcnZ;
        private int zzcoa;
        private boolean zzcob;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzcnV = streamDownloadTask;
            this.zzcnX = callable;
        }

        private void zzacL() throws IOException {
            if (this.zzcnV != null && this.zzcnV.zzacB() == 32) {
                throw StorageException.zzcmU;
            }
        }

        private void zzaX(long l) {
            if (this.zzcnV != null) {
                this.zzcnV.zzaX(l);
            }
            this.zzcnZ = (int)((long)this.zzcnZ + l);
        }

        private boolean zzacM() throws IOException {
            this.zzacL();
            if (this.zzcnY != null) {
                try {
                    if (this.zzcnW != null) {
                        this.zzcnW.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzcnW = null;
                if (this.zzcoa == this.zzcnZ) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzcnY);
                    return false;
                }
                int n = this.zzcnZ;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzcnY);
                this.zzcoa = this.zzcnZ;
                this.zzcnY = null;
            }
            if (this.zzcob) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzcnW == null) {
                try {
                    this.zzcnW = this.zzcnX.call();
                }
                catch (Exception exception) {
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new IOException("Unable to open stream", exception);
                }
            }
            return true;
        }

        @Override
        public int read() throws IOException {
            while (this.zzacM()) {
                try {
                    int n = this.zzcnW.read();
                    if (n != -1) {
                        this.zzaX(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcnY = iOException;
                }
            }
            throw this.zzcnY;
        }

        @Override
        public int available() throws IOException {
            while (this.zzacM()) {
                try {
                    return this.zzcnW.available();
                }
                catch (IOException iOException) {
                    this.zzcnY = iOException;
                }
            }
            throw this.zzcnY;
        }

        @Override
        public void close() throws IOException {
            if (this.zzcnW != null) {
                this.zzcnW.close();
            }
            this.zzcob = true;
            if (this.zzcnV != null && this.zzcnV.zzcnT != null) {
                this.zzcnV.zzcnT.zzacW();
                this.zzcnV.zzcnT = null;
            }
            this.zzacL();
        }

        @Override
        public void mark(int n) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzacM()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzcnW.read(byArray, n, 262144);
                        if (n4 == -1) {
                            return n3 == 0 ? -1 : n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzaX(n4);
                        this.zzacL();
                    }
                    if (n2 > 0) {
                        n4 = this.zzcnW.read(byArray, n, n2);
                        if (n4 == -1) {
                            return n3 == 0 ? -1 : n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzaX(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzcnY = iOException;
                }
            }
            throw this.zzcnY;
        }

        @Override
        public long skip(long l) throws IOException {
            int n = 0;
            while (this.zzacM()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzcnW.skip(262144L);
                        n = (int)((long)n + l2);
                        if (l2 < 262144L) {
                            this.zzaX(l2);
                            return n;
                        }
                        this.zzcnV.zzaX(262144L);
                        l -= 262144L;
                        this.zzacL();
                    }
                    l2 = this.zzcnW.skip(l);
                    n = (int)((long)n + l2);
                    l -= l2;
                    this.zzaX(l2);
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcnY = iOException;
                }
            }
            throw this.zzcnY;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

