/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbtu;
import com.google.android.gms.internal.zzbtv;
import com.google.android.gms.internal.zzbua;
import com.google.android.gms.internal.zzbue;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzcmG;
    private final Uri mUri;
    private final long zzcom;
    private final zzbtu zzcon;
    private final AtomicLong zzcoo;
    private int zzcop;
    private zzbtv zzcmI;
    private boolean zzcoq;
    private volatile StorageMetadata zzcnm;
    private volatile Uri zzcor;
    private volatile Exception zzbNH;
    private volatile Exception zzcos;
    private volatile int mResultCode;
    private volatile String zzcot;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzcoo = new AtomicLong(0L);
        this.zzcop = 262144;
        this.zzcor = null;
        this.zzbNH = null;
        this.zzcos = null;
        this.mResultCode = 0;
        zzac.zzw((Object)storageReference);
        zzac.zzw((Object)byArray);
        this.zzcom = byArray.length;
        this.zzcmG = storageReference;
        this.zzcnm = storageMetadata;
        this.mUri = null;
        this.zzcon = new zzbtu(new ByteArrayInputStream(byArray), 262144);
        this.zzcoq = true;
        this.zzcmI = new zzbtv(this.zzcmG.getApp(), this.zzcmG.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzcoo = new AtomicLong(0L);
            this.zzcop = 262144;
            this.zzcor = null;
            this.zzbNH = null;
            this.zzcos = null;
            this.mResultCode = 0;
            zzac.zzw((Object)storageReference);
            zzac.zzw((Object)uri);
            this.zzcmG = storageReference;
            this.zzcnm = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzcmI = new zzbtv(this.zzcmG.getApp(), this.zzcmG.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzcmG.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzbNH = fileNotFoundException;
            }
        }
        this.zzcom = l;
        this.zzcon = new zzbtu(inputStream, 262144);
        this.zzcoq = true;
        this.zzcor = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzcoo = new AtomicLong(0L);
        this.zzcop = 262144;
        this.zzcor = null;
        this.zzbNH = null;
        this.zzcos = null;
        this.mResultCode = 0;
        zzac.zzw((Object)storageReference);
        zzac.zzw((Object)inputStream);
        this.zzcom = -1L;
        this.zzcmG = storageReference;
        this.zzcnm = storageMetadata;
        this.zzcon = new zzbtu(inputStream, 262144);
        this.zzcoq = false;
        this.mUri = null;
        this.zzcmI = new zzbtv(this.zzcmG.getApp(), this.zzcmG.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.zzcmG;
    }

    long getTotalByteCount() {
        return this.zzcom;
    }

    @Override
    protected void schedule() {
        zzd.zzacH().zzv(this.zzUL());
    }

    @Override
    void run() {
        this.zzcmI.reset();
        if (!this.zzf(4, false)) {
            Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
            return;
        }
        if (this.zzcmG.getParent() == null) {
            this.zzbNH = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.zzbNH != null) {
            return;
        }
        if (this.zzcor == null) {
            this.zzacO();
        } else {
            this.zzbi(false);
        }
        boolean bl = this.zzacP();
        while (bl) {
            this.zzacR();
            bl = this.zzacP();
            if (!bl) continue;
            this.zzf(4, false);
        }
        if (this.zzcoq && this.zzacB() != 16) {
            try {
                this.zzcon.close();
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzbNH = null;
        this.zzcos = null;
        this.mResultCode = 0;
        this.zzcot = null;
    }

    private void zzacO() {
        Object object;
        String string = null;
        if (this.zzcnm != null) {
            string = this.zzcnm.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty((CharSequence)string)) {
            object = this.zzcmG.getStorage().getApp().getApplicationContext();
            string = object.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "application/octet-stream";
        }
        try {
            object = this.zzcmG.zzacy().zza(this.zzcmG.zzacz(), this.zzcnm != null ? this.zzcnm.zzacx() : null, string);
        }
        catch (RemoteException | JSONException throwable) {
            Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
            this.zzbNH = throwable;
            return;
        }
        if (!this.zzc((zzbue)object)) {
            return;
        }
        String string2 = ((zzbue)object).zzjO("X-Goog-Upload-URL");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzcor = Uri.parse((String)string2);
        }
    }

    private boolean zzacP() {
        boolean bl;
        if (this.zzacB() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzbNH = new InterruptedException();
            this.zzf(64, false);
            return false;
        }
        if (this.zzacB() == 32) {
            this.zzf(256, false);
            return false;
        }
        if (this.zzacB() == 8) {
            this.zzf(16, false);
            return false;
        }
        if (!this.zzacQ()) {
            return false;
        }
        if (this.zzcor == null) {
            if (this.zzbNH == null) {
                this.zzbNH = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzf(64, false);
            return false;
        }
        if (this.zzbNH != null) {
            this.zzf(64, false);
            return false;
        }
        boolean bl2 = bl = this.zzcos != null || this.mResultCode < 200 || this.mResultCode >= 300;
        if (bl && !this.zzbi(true)) {
            if (this.zzacQ()) {
                this.zzf(64, false);
            }
            return false;
        }
        return true;
    }

    private boolean zzacQ() {
        if ("final".equals(this.zzcot)) {
            if (this.zzbNH == null) {
                this.zzbNH = new IOException("The server has terminated the upload session");
            }
            this.zzf(64, false);
            return false;
        }
        return true;
    }

    private boolean zzbi(boolean bl) {
        zzbue zzbue2;
        try {
            zzbue2 = this.zzcmG.zzacy().zzb(this.zzcmG.zzacz(), this.zzcor.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzbNH = remoteException;
            return false;
        }
        if ("final".equals(this.zzcot)) {
            return false;
        }
        if (bl ? !this.zzc(zzbue2) : !this.zzb(zzbue2)) {
            return false;
        }
        if ("final".equals(zzbue2.zzjO("X-Goog-Upload-Status"))) {
            this.zzbNH = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzbue2.zzjO("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzcoo.get();
        if (l2 > l) {
            this.zzbNH = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzcon.zzqO((int)(l - l2)) != l - l2) {
                    this.zzbNH = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzcoo.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzbNH = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzbNH = iOException;
                return false;
            }
        }
        return true;
    }

    private void zzacR() {
        block9: {
            try {
                zzbue zzbue2;
                this.zzcon.zzqP(this.zzcop);
                int n = Math.min(this.zzcop, this.zzcon.available());
                try {
                    zzbue2 = this.zzcmG.zzacy().zza(this.zzcmG.zzacz(), this.zzcor.toString(), this.zzcon.zzacV(), this.zzcoo.get(), n, this.zzcon.isFinished());
                }
                catch (RemoteException remoteException) {
                    Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                    this.zzbNH = remoteException;
                    return;
                }
                if (!this.zzb(zzbue2)) {
                    int n2 = this.zzcop = 262144;
                    Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                    return;
                }
                this.zzcoo.getAndAdd(n);
                if (!this.zzcon.isFinished()) {
                    this.zzcon.zzqO(n);
                    if (this.zzcop < 0x2000000) {
                        this.zzcop *= 2;
                        int n3 = this.zzcop;
                        Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                    }
                    break block9;
                }
                try {
                    this.zzcnm = new StorageMetadata.Builder(zzbue2.zzadf(), this.zzcmG).build();
                }
                catch (RemoteException | JSONException throwable) {
                    String string = String.valueOf(zzbue2.zzacZ());
                    Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                    this.zzbNH = throwable;
                    return;
                }
                this.zzf(4, false);
                this.zzf(128, false);
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                this.zzbNH = iOException;
            }
        }
    }

    private boolean zzqK(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    private boolean zzb(zzbue zzbue2) {
        zzbue2.zzd(zzbua.zzi(this.zzcmG.getApp()), this.zzcmG.getApp().getApplicationContext());
        return this.zzd(zzbue2);
    }

    private boolean zzc(zzbue zzbue2) {
        this.zzcmI.zze(zzbue2);
        return this.zzd(zzbue2);
    }

    private boolean zzd(zzbue zzbue2) {
        int n = zzbue2.getResultCode();
        this.mResultCode = this.zzcmI.zzqR(n) ? -2 : n;
        this.zzcos = zzbue2.getException();
        this.zzcot = zzbue2.zzjO("X-Goog-Upload-Status");
        return this.zzqK(this.mResultCode) && this.zzcos == null;
    }

    @Override
    protected void onCanceled() {
        this.zzcmI.cancel();
        zzbue zzbue2 = null;
        if (this.zzcor != null) {
            try {
                zzbue2 = this.zzcmG.zzacy().zza(this.zzcmG.zzacz(), this.zzcor.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzbue2 != null) {
            final zzbue zzbue3 = zzbue2;
            zzd.zzacH().zzu(new Runnable(){

                @Override
                public void run() {
                    zzbue3.zzd(zzbua.zzi(UploadTask.this.zzcmG.getApp()), UploadTask.this.zzcmG.getApp().getApplicationContext());
                }
            });
        }
        this.zzbNH = StorageException.fromErrorStatus(Status.zzazB);
        super.onCanceled();
    }

    @NonNull
    TaskSnapshot zzacS() {
        Exception exception = this.zzbNH != null ? this.zzbNH : this.zzcos;
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, this.mResultCode)), this.zzcoo.get(), this.zzcor, this.zzcnm);
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzacv() {
        return this.zzacS();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcow;
        private final Uri zzcor;
        private final StorageMetadata zzcnm;

        TaskSnapshot(Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            super(exception);
            this.zzcow = l;
            this.zzcor = uri;
            this.zzcnm = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzcow;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzcor;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzcnm;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

