/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public class zzbuk {
    private static final Runtime zzcqv = Runtime.getRuntime();
    private final InputStream zzcqw;
    private byte[] buffer;
    private int zzcqx;
    private boolean zzcqy;
    private boolean zzcqz;

    public zzbuk(InputStream inputStream, int n) {
        this.zzcqw = inputStream;
        this.buffer = new byte[n];
        this.zzcqx = 0;
        this.zzcqz = true;
        this.zzcqy = false;
    }

    public int available() {
        return this.zzcqx;
    }

    public byte[] zzadD() {
        return this.buffer;
    }

    public int zzqT(int n) throws IOException {
        int n2;
        if (n <= this.zzcqx) {
            this.zzcqx -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzcqx);
            n2 = n;
        } else {
            n2 = this.zzcqx = 0;
            while (n2 < n) {
                long l = this.zzcqw.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzcqw.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public int zzqU(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzqV(n));
        }
        while (this.zzcqx < n) {
            int n2 = this.zzcqw.read(this.buffer, this.zzcqx, n - this.zzcqx);
            if (n2 == -1) {
                this.zzcqy = true;
                break;
            }
            this.zzcqx += n2;
        }
        return this.zzcqx;
    }

    private int zzqV(int n) {
        int n2 = Math.max(this.buffer.length * 2, n);
        if (this.zzcqz && (long)(n2 + 262144) < zzcqv.freeMemory()) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzcqx);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzcqz = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public boolean isFinished() {
        return this.zzcqy;
    }

    public void close() throws IOException {
        this.zzcqw.close();
    }
}

