/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzbur;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public class zzbuu {
    private zzbur zzcqG;
    private Exception zzbNK;
    private int zzcqH;
    private Exception zzcqI;

    public zzbuu(@NonNull zzbur zzbur2) {
        this.zzcqG = zzbur2;
    }

    public void zzaD(String string, String string2) {
        try {
            this.zzcqG.zzaD(string, string2);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
        }
    }

    private boolean zzcH(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzcqH = -2;
            this.zzcqI = new SocketException("Network subsystem is unavailable");
            return false;
        }
        return true;
    }

    @Nullable
    public String zzkh(String string) {
        try {
            return this.zzcqG.zzkh(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public void zzd(@Nullable String string, @NonNull Context context) {
        try {
            if (!this.zzcH(context)) {
                return;
            }
            this.zzcqG.zzkf(string);
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void reset() {
        try {
            this.zzcqH = 0;
            this.zzcqI = null;
            this.zzcqG.reset();
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzkg(@Nullable String string) {
        try {
            this.zzcqG.zzkg(string);
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzadE() {
        try {
            this.zzcqG.zzadE();
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    @Nullable
    public InputStream getStream() {
        try {
            return (InputStream)zzd.zzF((IObjectWrapper)this.zzcqG.zzadF());
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public JSONObject zzadN() throws RemoteException {
        return (JSONObject)zzd.zzF((IObjectWrapper)this.zzcqG.zzadG());
    }

    @Nullable
    public String zzadH() {
        try {
            this.zzcqG.zzadH();
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public Exception getException() {
        try {
            if (this.zzcqI != null) {
                return this.zzcqI;
            }
            return this.zzbNK != null ? this.zzbNK : (Exception)zzd.zzF((IObjectWrapper)this.zzcqG.zzadJ());
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public int getResultCode() {
        try {
            if (this.zzcqH != 0) {
                return this.zzcqH;
            }
            return this.zzcqG.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public boolean zzadK() {
        try {
            if (this.zzcqH == -2 || this.zzcqI != null) {
                return false;
            }
            return this.zzcqG.zzadK();
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzadK() && exception == null) {
            taskCompletionSource.setResult(TResult);
        } else {
            StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (storageException != null);
            taskCompletionSource.setException((Exception)((Object)storageException));
        }
    }

    public int zzadL() {
        try {
            return this.zzcqG.zzadL();
        }
        catch (RemoteException remoteException) {
            this.zzbNK = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

