/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzbul;
import com.google.android.gms.internal.zzbuu;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzcoD;
    private long zzcoE;
    private StorageReference zzcoA;
    private zzbul zzcoC;
    private long zzaMd = -1L;
    private String zzcoF = null;
    private volatile Exception zzbNK = null;
    private long zzcoG = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzcoA = storageReference;
        this.zzcoD = uri;
        this.zzcoC = new zzbul(this.zzcoA.getStorage().getApp(), this.zzcoA.getStorage().getMaxDownloadRetryTimeMillis());
    }

    long getTotalBytes() {
        return this.zzaMd;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.zzcoA;
    }

    @Override
    protected void schedule() {
        zzd.zzadp().zzw(this.zzUN());
    }

    @NonNull
    TaskSnapshot zzadc() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.zzbNK, this.mResultCode)), this.zzcoE + this.zzcoG);
    }

    private int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzbNK = iOException;
        }
        return bl ? n : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zzbuu zzbuu2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzbuu2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            File file = new File(this.zzcoD.getPath());
            if (!file.exists()) {
                if (this.zzcoG > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                boolean bl2 = file.createNewFile();
                if (!bl2) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzcoG > 0L) {
                String string = String.valueOf(file.getAbsolutePath());
                long l = this.zzcoG;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Resuming download file ").append(string).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                byte[] byArray = new byte[262144];
                while (bl && (n = this.zza(inputStream, byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    this.zzcoE += (long)n;
                    if (this.zzbNK != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzbNK);
                        this.zzbNK = null;
                        bl = false;
                    }
                    if (this.zzf(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzbNK = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    void run() {
        if (this.zzbNK != null) {
            this.zzf(64, false);
            return;
        }
        if (!this.zzf(4, false)) {
            return;
        }
        do {
            Object object;
            boolean bl;
            zzbuu zzbuu2;
            this.zzcoE = 0L;
            this.zzbNK = null;
            this.zzcoC.reset();
            try {
                zzbuu2 = this.zzcoA.zzadg().zza(this.zzcoA.zzadh(), this.zzcoG);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzbNK = remoteException;
                this.zzf(64, false);
                return;
            }
            this.zzcoC.zza(zzbuu2, false);
            this.mResultCode = zzbuu2.getResultCode();
            this.zzbNK = zzbuu2.getException() != null ? zzbuu2.getException() : this.zzbNK;
            boolean bl2 = bl = this.zzqL(this.mResultCode) && this.zzbNK == null && this.zzadj() == 4;
            if (bl) {
                this.zzaMd = zzbuu2.zzadL();
                object = zzbuu2.zzkh("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzcoF != null && !this.zzcoF.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzcoG = 0L;
                    this.zzcoF = null;
                    zzbuu2.zzadE();
                    this.schedule();
                    return;
                }
                this.zzcoF = object;
                try {
                    bl = this.zza(zzbuu2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzbNK = iOException;
                }
            }
            zzbuu2.zzadE();
            boolean bl3 = bl = bl && this.zzbNK == null && this.zzadj() == 4;
            if (bl) {
                this.zzf(128, false);
                return;
            }
            object = new File(this.zzcoD.getPath());
            this.zzcoG = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzadj() == 8) {
                this.zzf(16, false);
                return;
            }
            if (this.zzadj() != 32) continue;
            if (!this.zzf(256, false)) {
                int n = this.zzadj();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
            }
            return;
        } while (this.zzcoE > 0L);
        this.zzf(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzcoC.cancel();
        this.zzbNK = StorageException.fromErrorStatus(Status.zzazB);
    }

    private boolean zzqL(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzadd() {
        return this.zzadc();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcoE;

        TaskSnapshot(Exception exception, long l) {
            super(FileDownloadTask.this, exception);
            this.zzcoE = l;
        }

        public long getBytesTransferred() {
            return this.zzcoE;
        }

        public long getTotalByteCount() {
            return FileDownloadTask.this.getTotalBytes();
        }
    }
}

