/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbuq;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class FirebaseStorage {
    private static final Map<String, Map<String, FirebaseStorage>> zzcoI = new HashMap<String, Map<String, FirebaseStorage>>();
    @NonNull
    private final FirebaseApp zzclm;
    @Nullable
    private final String zzcoJ;
    private long zzcoK = 600000L;
    private long zzcoL = 600000L;
    private long zzcoM = 120000L;

    private FirebaseStorage(@Nullable String string, @NonNull FirebaseApp firebaseApp) {
        this.zzcoJ = string;
        this.zzclm = firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FirebaseStorage zza(@NonNull FirebaseApp firebaseApp, @Nullable Uri uri) {
        String string;
        String string2 = string = uri != null ? uri.getHost() : null;
        if (uri != null && !TextUtils.isEmpty((CharSequence)uri.getPath())) {
            throw new IllegalArgumentException("The storage Uri cannot contain a path element.");
        }
        Map<String, Map<String, FirebaseStorage>> map = zzcoI;
        synchronized (map) {
            FirebaseStorage firebaseStorage;
            Map<String, FirebaseStorage> map2 = zzcoI.get(firebaseApp.getName());
            if (map2 == null) {
                map2 = new HashMap<String, FirebaseStorage>();
                zzcoI.put(firebaseApp.getName(), map2);
            }
            if ((firebaseStorage = map2.get(string)) == null) {
                firebaseStorage = new FirebaseStorage(string, firebaseApp);
                map2.put(string, firebaseStorage);
            }
            return firebaseStorage;
        }
    }

    @NonNull
    public static FirebaseStorage getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        zzac.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"You must call FirebaseApp.initialize() first.");
        assert (firebaseApp != null);
        return FirebaseStorage.getInstance(firebaseApp);
    }

    @NonNull
    public static FirebaseStorage getInstance(@NonNull String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        zzac.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"You must call FirebaseApp.initialize() first.");
        assert (firebaseApp != null);
        return FirebaseStorage.getInstance(firebaseApp, string);
    }

    @NonNull
    public static FirebaseStorage getInstance(@NonNull FirebaseApp firebaseApp) {
        zzac.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the FirebaseApp.");
        String string = firebaseApp.getOptions().getStorageBucket();
        if (string == null) {
            return FirebaseStorage.zza(firebaseApp, null);
        }
        try {
            String string2 = String.valueOf(firebaseApp.getOptions().getStorageBucket());
            return FirebaseStorage.zza(firebaseApp, zzbuq.zzg(firebaseApp, string2.length() != 0 ? "gs://".concat(string2) : new String("gs://")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = String.valueOf(string);
            Log.e((String)"FirebaseStorage", (String)(string3.length() != 0 ? "Unable to parse bucket:".concat(string3) : new String("Unable to parse bucket:")), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException("The storage Uri could not be parsed.");
        }
    }

    @NonNull
    public static FirebaseStorage getInstance(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        zzac.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the FirebaseApp.");
        try {
            return FirebaseStorage.zza(firebaseApp, zzbuq.zzg(firebaseApp, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = String.valueOf(string);
            Log.e((String)"FirebaseStorage", (String)(string2.length() != 0 ? "Unable to parse url:".concat(string2) : new String("Unable to parse url:")), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException("The storage Uri could not be parsed.");
        }
    }

    public long getMaxDownloadRetryTimeMillis() {
        return this.zzcoL;
    }

    public void setMaxDownloadRetryTimeMillis(long l) {
        this.zzcoL = l;
    }

    public long getMaxUploadRetryTimeMillis() {
        return this.zzcoK;
    }

    public void setMaxUploadRetryTimeMillis(long l) {
        this.zzcoK = l;
    }

    public long getMaxOperationRetryTimeMillis() {
        return this.zzcoM;
    }

    public void setMaxOperationRetryTimeMillis(long l) {
        this.zzcoM = l;
    }

    @Nullable
    private String zzade() {
        return this.zzcoJ;
    }

    @NonNull
    public StorageReference getReference() {
        String string = this.zzade();
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalStateException("FirebaseApp was not initialized with a bucket name.");
        }
        Uri uri = new Uri.Builder().scheme("gs").authority(this.zzade()).path("/").build();
        return this.zzz(uri);
    }

    @NonNull
    public StorageReference getReferenceFromUrl(@NonNull String string) {
        zzac.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String string2 = string.toLowerCase();
        if (string2.startsWith("gs://") || string2.startsWith("https://") || string2.startsWith("http://")) {
            try {
                Uri uri = zzbuq.zzg(this.zzclm, string);
                if (uri == null) {
                    throw new IllegalArgumentException("The storage Uri could not be parsed.");
                }
                return this.zzz(uri);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string3 = String.valueOf(string);
                Log.e((String)"FirebaseStorage", (String)(string3.length() != 0 ? "Unable to parse location:".concat(string3) : new String("Unable to parse location:")), (Throwable)unsupportedEncodingException);
                throw new IllegalArgumentException("The storage Uri could not be parsed.");
            }
        }
        throw new IllegalArgumentException("The storage Uri could not be parsed.");
    }

    @NonNull
    public StorageReference getReference(@NonNull String string) {
        zzac.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String string2 = string.toLowerCase();
        if (string2.startsWith("gs://") || string2.startsWith("https://") || string2.startsWith("http://")) {
            throw new IllegalArgumentException("location should not be a full URL.");
        }
        return this.getReference().child(string);
    }

    @NonNull
    private StorageReference zzz(@NonNull Uri uri) {
        zzac.zzb((Object)uri, (Object)"uri must not be null");
        String string = this.zzade();
        zzac.zzb((TextUtils.isEmpty((CharSequence)string) || uri.getAuthority().equalsIgnoreCase(string) ? 1 : 0) != 0, (Object)"The supplied bucketname does not match the storage bucket of the current instance.");
        return new StorageReference(uri, this);
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zzclm;
    }
}

