/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbum;
import com.google.android.gms.internal.zzbuq;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzcoS = null;
    private StorageReference zzcoA = null;
    private String zzcoT = null;
    private String zzcoU = null;
    private String zzaoj = null;
    private String zzcoV = null;
    private String zzcoW = null;
    private String zzcoX = null;
    private long zzcoY;
    private String zzcoZ = null;
    private String zzcpa = null;
    private String zzcpb = null;
    private String zzcpc = null;
    private String zzcpd = null;
    private Map<String, String> zzcpe = null;
    private String[] zzcpf = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzac.zzw((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzcoS = storageMetadata.zzcoS;
        this.zzcoA = storageMetadata.zzcoA;
        this.zzcoT = storageMetadata.zzcoT;
        this.zzaoj = storageMetadata.zzaoj;
        this.zzcpa = storageMetadata.zzcpa;
        this.zzcpb = storageMetadata.zzcpb;
        this.zzcpc = storageMetadata.zzcpc;
        this.zzcpd = storageMetadata.zzcpd;
        if (storageMetadata.zzcpe != null) {
            this.zzcpe = new HashMap<String, String>(storageMetadata.zzcpe);
        }
        this.zzcpf = storageMetadata.zzcpf;
        if (bl) {
            this.zzcoZ = storageMetadata.zzcoZ;
            this.zzcoY = storageMetadata.zzcoY;
            this.zzcoX = storageMetadata.zzcoX;
            this.zzcoW = storageMetadata.zzcoW;
            this.zzcoV = storageMetadata.zzcoV;
            this.zzcoU = storageMetadata.zzcoU;
        }
    }

    public String getContentType() {
        return this.zzaoj;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzcpe == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzcpe.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzcpe == null) {
            return Collections.emptySet();
        }
        return this.zzcpe.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzcoT;
    }

    @Nullable
    public String getGeneration() {
        return this.zzcoU;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzcoV;
    }

    public long getCreationTimeMillis() {
        return zzbuq.zzke(this.zzcoW);
    }

    public long getUpdatedTimeMillis() {
        return zzbuq.zzke(this.zzcoX);
    }

    public long getSizeBytes() {
        return this.zzcoY;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzcoZ;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzcpf != null && this.zzcoA != null) {
            try {
                String string = this.zzcoA.zzadg().zzA(this.zzcoA.zzadh());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    for (String string2 : this.zzcpf) {
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzcpa;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzcpb;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzcpc;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzcpd;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzcoA == null && this.zzcoS != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzbum.zzkb((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzcoS);
        }
        return this.zzcoA;
    }

    @NonNull
    JSONObject zzadf() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzcpe != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzcpe));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private void zzka(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzcpf = string.split(",");
        }
    }

    public static class Builder {
        StorageMetadata zzcpg;
        boolean zzcph;

        public Builder() {
            this.zzcpg = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzcpg = new StorageMetadata(storageMetadata, false);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzcpg.zzcoA = storageReference;
        }

        Builder(JSONObject jSONObject) throws JSONException {
            this.zzcpg = new StorageMetadata();
            if (jSONObject != null) {
                this.zzu(jSONObject);
                this.zzcph = true;
            }
        }

        private void zzu(JSONObject jSONObject) throws JSONException {
            this.zzcpg.zzcoU = jSONObject.optString("generation");
            this.zzcpg.mPath = jSONObject.optString("name");
            this.zzcpg.zzcoT = jSONObject.optString("bucket");
            this.zzcpg.zzcoV = jSONObject.optString("metageneration");
            this.zzcpg.zzcoW = jSONObject.optString("timeCreated");
            this.zzcpg.zzcoX = jSONObject.optString("updated");
            this.zzcpg.zzcoY = jSONObject.optLong("size");
            this.zzcpg.zzcoZ = jSONObject.optString("md5Hash");
            this.zzcpg.zzka(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzcpg, this.zzcph);
        }

        public Builder setContentLanguage(String string) {
            this.zzcpg.zzcpd = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzcpg.zzcpc = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzcpg.zzcpb = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzcpg.zzcpa = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzcpg.zzcpe == null) {
                this.zzcpg.zzcpe = new HashMap();
            }
            this.zzcpg.zzcpe.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzcpg.zzaoj = string;
            return this;
        }
    }
}

