/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbul;
import com.google.android.gms.internal.zzbuu;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzcoA;
    private zzbul zzcoC;
    private volatile Exception zzbNK = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzcpL;
    private long zzaMd = -1L;
    private long zzcoE;
    private long zzcpM;
    private InputStream zzbUe;
    private zzbuu zzcpN;
    private String zzcoF;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzcoA = storageReference;
        this.zzcoC = new zzbul(this.zzcoA.getApp(), this.zzcoA.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzac.zzw((Object)streamProcessor);
        zzac.zzav((this.zzcpL == null ? 1 : 0) != 0);
        this.zzcpL = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.zzcoA;
    }

    long getTotalBytes() {
        return this.zzaMd;
    }

    void zzbi(long l) {
        this.zzcoE += l;
        if (this.zzcpM + 262144L <= this.zzcoE) {
            if (this.zzadj() == 4) {
                this.zzf(4, false);
            } else {
                this.zzcpM = this.zzcoE;
            }
        }
    }

    @Override
    protected void schedule() {
        zzd.zzadp().zzw(this.zzUN());
    }

    private InputStream zzadq() throws Exception {
        boolean bl;
        this.zzcoC.reset();
        if (this.zzcpN != null) {
            this.zzcpN.zzadE();
        }
        try {
            this.zzcpN = this.zzcoA.zzadg().zza(this.zzcoA.zzadh(), this.zzcoE);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzcoC.zza(this.zzcpN, false);
        this.mResultCode = this.zzcpN.getResultCode();
        this.zzbNK = this.zzcpN.getException() != null ? this.zzcpN.getException() : this.zzbNK;
        boolean bl2 = bl = this.zzqL(this.mResultCode) && this.zzbNK == null && this.zzadj() == 4;
        if (bl) {
            String string = this.zzcpN.zzkh("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzcoF != null && !this.zzcoF.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzcoF = string;
            if (this.zzaMd == -1L) {
                this.zzaMd = this.zzcpN.zzadL();
            }
            return this.zzcpN.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    void run() {
        boolean bl;
        if (this.zzbNK != null) {
            this.zzf(64, false);
            return;
        }
        if (!this.zzf(4, false)) {
            return;
        }
        this.zzbUe = new BufferedInputStream(new zza(new Callable<InputStream>(){

            public InputStream zzads() throws Exception {
                return StreamDownloadTask.this.zzadq();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzads();
            }
        }, this));
        if (this.zzcpL != null) {
            try {
                this.zzcpL.doInBackground((TaskSnapshot)this.zzadl(), this.zzbUe);
            }
            catch (Exception exception) {
                Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                this.zzbNK = exception;
            }
        }
        if (this.zzbUe == null) {
            this.zzcpN.zzadE();
            this.zzcpN = null;
        }
        boolean bl2 = bl = this.zzbNK == null && this.zzadj() == 4;
        if (bl) {
            this.zzf(4, false);
            this.zzf(128, false);
        } else if (!this.zzf(this.zzadj() == 32 ? 256 : 64, false)) {
            int n = this.zzadj();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @NonNull
    TaskSnapshot zzadr() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.zzbNK, this.mResultCode)), this.zzcpM);
    }

    @Override
    protected void onCanceled() {
        this.zzcoC.cancel();
        this.zzbNK = StorageException.fromErrorStatus(Status.zzazB);
    }

    @Override
    protected void onProgress() {
        this.zzcpM = this.zzcoE;
    }

    private boolean zzqL(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzadd() {
        return this.zzadr();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcoE;

        TaskSnapshot(Exception exception, long l) {
            super(exception);
            this.zzcoE = l;
        }

        public long getBytesTransferred() {
            return this.zzcoE;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        public InputStream getStream() {
            return StreamDownloadTask.this.zzbUe;
        }
    }

    static class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzcpP;
        @Nullable
        private InputStream zzcpQ;
        private Callable<InputStream> zzcpR;
        private IOException zzcpS;
        private int zzcpT;
        private int zzcpU;
        private boolean zzcpV;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzcpP = streamDownloadTask;
            this.zzcpR = callable;
        }

        private void zzadt() throws IOException {
            if (this.zzcpP != null && this.zzcpP.zzadj() == 32) {
                throw StorageException.zzcoO;
            }
        }

        private void zzbi(long l) {
            if (this.zzcpP != null) {
                this.zzcpP.zzbi(l);
            }
            this.zzcpT = (int)((long)this.zzcpT + l);
        }

        private boolean zzadu() throws IOException {
            this.zzadt();
            if (this.zzcpS != null) {
                try {
                    if (this.zzcpQ != null) {
                        this.zzcpQ.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzcpQ = null;
                if (this.zzcpU == this.zzcpT) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzcpS);
                    return false;
                }
                int n = this.zzcpT;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzcpS);
                this.zzcpU = this.zzcpT;
                this.zzcpS = null;
            }
            if (this.zzcpV) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzcpQ == null) {
                try {
                    this.zzcpQ = this.zzcpR.call();
                }
                catch (Exception exception) {
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new IOException("Unable to open stream", exception);
                }
            }
            return true;
        }

        @Override
        public int read() throws IOException {
            while (this.zzadu()) {
                try {
                    int n = this.zzcpQ.read();
                    if (n != -1) {
                        this.zzbi(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcpS = iOException;
                }
            }
            throw this.zzcpS;
        }

        @Override
        public int available() throws IOException {
            while (this.zzadu()) {
                try {
                    return this.zzcpQ.available();
                }
                catch (IOException iOException) {
                    this.zzcpS = iOException;
                }
            }
            throw this.zzcpS;
        }

        @Override
        public void close() throws IOException {
            if (this.zzcpQ != null) {
                this.zzcpQ.close();
            }
            this.zzcpV = true;
            if (this.zzcpP != null && this.zzcpP.zzcpN != null) {
                this.zzcpP.zzcpN.zzadE();
                this.zzcpP.zzcpN = null;
            }
            this.zzadt();
        }

        @Override
        public void mark(int n) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzadu()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzcpQ.read(byArray, n, 262144);
                        if (n4 == -1) {
                            return n3 == 0 ? -1 : n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzbi(n4);
                        this.zzadt();
                    }
                    if (n2 > 0) {
                        n4 = this.zzcpQ.read(byArray, n, n2);
                        if (n4 == -1) {
                            return n3 == 0 ? -1 : n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzbi(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzcpS = iOException;
                }
            }
            throw this.zzcpS;
        }

        @Override
        public long skip(long l) throws IOException {
            int n = 0;
            while (this.zzadu()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzcpQ.skip(262144L);
                        n = (int)((long)n + l2);
                        if (l2 < 262144L) {
                            this.zzbi(l2);
                            return n;
                        }
                        this.zzcpP.zzbi(262144L);
                        l -= 262144L;
                        this.zzadt();
                    }
                    l2 = this.zzcpQ.skip(l);
                    n = (int)((long)n + l2);
                    l -= l2;
                    this.zzbi(l2);
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcpS = iOException;
                }
            }
            throw this.zzcpS;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

