/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbuk;
import com.google.android.gms.internal.zzbul;
import com.google.android.gms.internal.zzbuq;
import com.google.android.gms.internal.zzbuu;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzcoA;
    private final Uri mUri;
    private final long zzcqg;
    private final zzbuk zzcqh;
    private final AtomicLong zzcqi;
    private int zzcqj;
    private zzbul zzcoC;
    private boolean zzcqk;
    private volatile StorageMetadata zzcpg;
    private volatile Uri zzcql;
    private volatile Exception zzbNK;
    private volatile Exception zzcqm;
    private volatile int mResultCode;
    private volatile String zzcqn;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzcqi = new AtomicLong(0L);
        this.zzcqj = 262144;
        this.zzcql = null;
        this.zzbNK = null;
        this.zzcqm = null;
        this.mResultCode = 0;
        zzac.zzw((Object)storageReference);
        zzac.zzw((Object)byArray);
        this.zzcqg = byArray.length;
        this.zzcoA = storageReference;
        this.zzcpg = storageMetadata;
        this.mUri = null;
        this.zzcqh = new zzbuk(new ByteArrayInputStream(byArray), 262144);
        this.zzcqk = true;
        this.zzcoC = new zzbul(this.zzcoA.getApp(), this.zzcoA.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzcqi = new AtomicLong(0L);
            this.zzcqj = 262144;
            this.zzcql = null;
            this.zzbNK = null;
            this.zzcqm = null;
            this.mResultCode = 0;
            zzac.zzw((Object)storageReference);
            zzac.zzw((Object)uri);
            this.zzcoA = storageReference;
            this.zzcpg = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzcoC = new zzbul(this.zzcoA.getApp(), this.zzcoA.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzcoA.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzbNK = fileNotFoundException;
            }
        }
        this.zzcqg = l;
        this.zzcqh = new zzbuk(inputStream, 262144);
        this.zzcqk = true;
        this.zzcql = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzcqi = new AtomicLong(0L);
        this.zzcqj = 262144;
        this.zzcql = null;
        this.zzbNK = null;
        this.zzcqm = null;
        this.mResultCode = 0;
        zzac.zzw((Object)storageReference);
        zzac.zzw((Object)inputStream);
        this.zzcqg = -1L;
        this.zzcoA = storageReference;
        this.zzcpg = storageMetadata;
        this.zzcqh = new zzbuk(inputStream, 262144);
        this.zzcqk = false;
        this.mUri = null;
        this.zzcoC = new zzbul(this.zzcoA.getApp(), this.zzcoA.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.zzcoA;
    }

    long getTotalByteCount() {
        return this.zzcqg;
    }

    @Override
    protected void schedule() {
        zzd.zzadp().zzv(this.zzUN());
    }

    @Override
    void run() {
        this.zzcoC.reset();
        if (!this.zzf(4, false)) {
            Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
            return;
        }
        if (this.zzcoA.getParent() == null) {
            this.zzbNK = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.zzbNK != null) {
            return;
        }
        if (this.zzcql == null) {
            this.zzadw();
        } else {
            this.zzbj(false);
        }
        boolean bl = this.zzadx();
        while (bl) {
            this.zzadz();
            bl = this.zzadx();
            if (!bl) continue;
            this.zzf(4, false);
        }
        if (this.zzcqk && this.zzadj() != 16) {
            try {
                this.zzcqh.close();
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzbNK = null;
        this.zzcqm = null;
        this.mResultCode = 0;
        this.zzcqn = null;
    }

    private void zzadw() {
        Object object;
        String string = null;
        if (this.zzcpg != null) {
            string = this.zzcpg.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty((CharSequence)string)) {
            object = this.zzcoA.getStorage().getApp().getApplicationContext();
            string = object.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "application/octet-stream";
        }
        try {
            object = this.zzcoA.zzadg().zza(this.zzcoA.zzadh(), this.zzcpg != null ? this.zzcpg.zzadf() : null, string);
        }
        catch (RemoteException | JSONException throwable) {
            Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
            this.zzbNK = throwable;
            return;
        }
        if (!this.zzc((zzbuu)object)) {
            return;
        }
        String string2 = ((zzbuu)object).zzkh("X-Goog-Upload-URL");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzcql = Uri.parse((String)string2);
        }
    }

    private boolean zzadx() {
        boolean bl;
        if (this.zzadj() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzbNK = new InterruptedException();
            this.zzf(64, false);
            return false;
        }
        if (this.zzadj() == 32) {
            this.zzf(256, false);
            return false;
        }
        if (this.zzadj() == 8) {
            this.zzf(16, false);
            return false;
        }
        if (!this.zzady()) {
            return false;
        }
        if (this.zzcql == null) {
            if (this.zzbNK == null) {
                this.zzbNK = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzf(64, false);
            return false;
        }
        if (this.zzbNK != null) {
            this.zzf(64, false);
            return false;
        }
        boolean bl2 = bl = this.zzcqm != null || this.mResultCode < 200 || this.mResultCode >= 300;
        if (bl && !this.zzbj(true)) {
            if (this.zzady()) {
                this.zzf(64, false);
            }
            return false;
        }
        return true;
    }

    private boolean zzady() {
        if ("final".equals(this.zzcqn)) {
            if (this.zzbNK == null) {
                this.zzbNK = new IOException("The server has terminated the upload session");
            }
            this.zzf(64, false);
            return false;
        }
        return true;
    }

    private boolean zzbj(boolean bl) {
        zzbuu zzbuu2;
        try {
            zzbuu2 = this.zzcoA.zzadg().zzb(this.zzcoA.zzadh(), this.zzcql.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzbNK = remoteException;
            return false;
        }
        if ("final".equals(this.zzcqn)) {
            return false;
        }
        if (bl ? !this.zzc(zzbuu2) : !this.zzb(zzbuu2)) {
            return false;
        }
        if ("final".equals(zzbuu2.zzkh("X-Goog-Upload-Status"))) {
            this.zzbNK = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzbuu2.zzkh("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzcqi.get();
        if (l2 > l) {
            this.zzbNK = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzcqh.zzqT((int)(l - l2)) != l - l2) {
                    this.zzbNK = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzcqi.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzbNK = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzbNK = iOException;
                return false;
            }
        }
        return true;
    }

    private void zzadz() {
        block9: {
            try {
                zzbuu zzbuu2;
                this.zzcqh.zzqU(this.zzcqj);
                int n = Math.min(this.zzcqj, this.zzcqh.available());
                try {
                    zzbuu2 = this.zzcoA.zzadg().zza(this.zzcoA.zzadh(), this.zzcql.toString(), this.zzcqh.zzadD(), this.zzcqi.get(), n, this.zzcqh.isFinished());
                }
                catch (RemoteException remoteException) {
                    Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                    this.zzbNK = remoteException;
                    return;
                }
                if (!this.zzb(zzbuu2)) {
                    int n2 = this.zzcqj = 262144;
                    Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                    return;
                }
                this.zzcqi.getAndAdd(n);
                if (!this.zzcqh.isFinished()) {
                    this.zzcqh.zzqT(n);
                    if (this.zzcqj < 0x2000000) {
                        this.zzcqj *= 2;
                        int n3 = this.zzcqj;
                        Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                    }
                    break block9;
                }
                try {
                    this.zzcpg = new StorageMetadata.Builder(zzbuu2.zzadN(), this.zzcoA).build();
                }
                catch (RemoteException | JSONException throwable) {
                    String string = String.valueOf(zzbuu2.zzadH());
                    Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                    this.zzbNK = throwable;
                    return;
                }
                this.zzf(4, false);
                this.zzf(128, false);
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                this.zzbNK = iOException;
            }
        }
    }

    private boolean zzqL(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    private boolean zzb(zzbuu zzbuu2) {
        zzbuu2.zzd(zzbuq.zzi(this.zzcoA.getApp()), this.zzcoA.getApp().getApplicationContext());
        return this.zzd(zzbuu2);
    }

    private boolean zzc(zzbuu zzbuu2) {
        this.zzcoC.zze(zzbuu2);
        return this.zzd(zzbuu2);
    }

    private boolean zzd(zzbuu zzbuu2) {
        int n = zzbuu2.getResultCode();
        this.mResultCode = this.zzcoC.zzqW(n) ? -2 : n;
        this.zzcqm = zzbuu2.getException();
        this.zzcqn = zzbuu2.zzkh("X-Goog-Upload-Status");
        return this.zzqL(this.mResultCode) && this.zzcqm == null;
    }

    @Override
    protected void onCanceled() {
        this.zzcoC.cancel();
        zzbuu zzbuu2 = null;
        if (this.zzcql != null) {
            try {
                zzbuu2 = this.zzcoA.zzadg().zza(this.zzcoA.zzadh(), this.zzcql.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzbuu2 != null) {
            final zzbuu zzbuu3 = zzbuu2;
            zzd.zzadp().zzu(new Runnable(){

                @Override
                public void run() {
                    zzbuu3.zzd(zzbuq.zzi(UploadTask.this.zzcoA.getApp()), UploadTask.this.zzcoA.getApp().getApplicationContext());
                }
            });
        }
        this.zzbNK = StorageException.fromErrorStatus(Status.zzazB);
        super.onCanceled();
    }

    @NonNull
    TaskSnapshot zzadA() {
        Exception exception = this.zzbNK != null ? this.zzbNK : this.zzcqm;
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, this.mResultCode)), this.zzcqi.get(), this.zzcql, this.zzcpg);
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzadd() {
        return this.zzadA();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcqq;
        private final Uri zzcql;
        private final StorageMetadata zzcpg;

        TaskSnapshot(Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            super(exception);
            this.zzcqq = l;
            this.zzcql = uri;
            this.zzcpg = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzcqq;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzcql;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzcpg;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

