/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.agl;
import com.google.android.gms.internal.agp;
import com.google.android.gms.internal.agu;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzc;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzcrf = null;
    private StorageReference zzcqN = null;
    private String zzcrg = null;
    private String zzcrh = null;
    private String zzaqb = null;
    private String zzcri = null;
    private String zzcrj = null;
    private String zzcrk = null;
    private long zzcrl;
    private String zzcrm = null;
    private String zzcrn = null;
    private String zzcro = null;
    private String zzcrp = null;
    private String zzcrq = null;
    private Map<String, String> zzcrr = null;
    private String[] zzcrs = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbr.zzu((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzcrf = storageMetadata.zzcrf;
        this.zzcqN = storageMetadata.zzcqN;
        this.zzcrg = storageMetadata.zzcrg;
        this.zzaqb = storageMetadata.zzaqb;
        this.zzcrn = storageMetadata.zzcrn;
        this.zzcro = storageMetadata.zzcro;
        this.zzcrp = storageMetadata.zzcrp;
        this.zzcrq = storageMetadata.zzcrq;
        if (storageMetadata.zzcrr != null) {
            this.zzcrr = new HashMap<String, String>(storageMetadata.zzcrr);
        }
        this.zzcrs = storageMetadata.zzcrs;
        if (bl) {
            this.zzcrm = storageMetadata.zzcrm;
            this.zzcrl = storageMetadata.zzcrl;
            this.zzcrk = storageMetadata.zzcrk;
            this.zzcrj = storageMetadata.zzcrj;
            this.zzcri = storageMetadata.zzcri;
            this.zzcrh = storageMetadata.zzcrh;
        }
    }

    public String getContentType() {
        return this.zzaqb;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzcrr == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzcrr.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzcrr == null) {
            return Collections.emptySet();
        }
        return this.zzcrr.keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzcrg;
    }

    @Nullable
    public String getGeneration() {
        return this.zzcrh;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzcri;
    }

    public long getCreationTimeMillis() {
        return agp.zzik(this.zzcrj);
    }

    public long getUpdatedTimeMillis() {
        return agp.zzik(this.zzcrk);
    }

    public long getSizeBytes() {
        return this.zzcrl;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzcrm;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzcrs != null && this.zzcqN != null) {
            try {
                String string = agu.zzg(this.zzcqN.getStorage().getApp()).zzv(this.zzcqN.zzLf());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzcrs;
                    int n = this.zzcrs.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzcrn;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzcro;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzcrp;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzcrq;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzcqN == null && this.zzcrf != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(agl.zzih((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzcrf);
        }
        return this.zzcqN;
    }

    @NonNull
    final JSONObject zzLd() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzcrr != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzcrr));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private final void zzig(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzcrs = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzc zzc2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzcrt;
        private boolean zzcru;

        public Builder() {
            this.zzcrt = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzcrt = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzcrt.zzcqN = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzcrt = new StorageMetadata();
            if (jSONObject != null) {
                this.zzt(jSONObject);
                this.zzcru = true;
            }
        }

        private final void zzt(JSONObject jSONObject) throws JSONException {
            this.zzcrt.zzcrh = jSONObject.optString("generation");
            this.zzcrt.mPath = jSONObject.optString("name");
            this.zzcrt.zzcrg = jSONObject.optString("bucket");
            this.zzcrt.zzcri = jSONObject.optString("metageneration");
            this.zzcrt.zzcrj = jSONObject.optString("timeCreated");
            this.zzcrt.zzcrk = jSONObject.optString("updated");
            this.zzcrt.zzcrl = jSONObject.optLong("size");
            this.zzcrt.zzcrm = jSONObject.optString("md5Hash");
            this.zzcrt.zzig(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzcrt, this.zzcru, null);
        }

        public Builder setContentLanguage(String string) {
            this.zzcrt.zzcrq = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzcrt.zzcrp = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzcrt.zzcro = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzcrt.zzcrn = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzcrt.zzcrr == null) {
                this.zzcrt.zzcrr = new HashMap();
            }
            this.zzcrt.zzcrr.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzcrt.zzaqb = string;
            return this;
        }
    }
}

