/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.agk;
import com.google.android.gms.internal.agv;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzv;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzcqN;
    private agk zzcqP;
    private volatile Exception zzbMl = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzcrY;
    private long zzaNu = -1L;
    private long zzcqR;
    private long zzcrZ;
    private InputStream zzbSq;
    private agv zzcsa;
    private String zzcqS;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzcqN = storageReference;
        this.zzcqP = new agk(this.zzcqN.getStorage().getApp(), this.zzcqN.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbr.zzu((Object)streamProcessor);
        zzbr.zzae((this.zzcrY == null ? 1 : 0) != 0);
        this.zzcrY = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzcqN;
    }

    final long getTotalBytes() {
        return this.zzaNu;
    }

    final void zzaN(long l) {
        this.zzcqR += l;
        if (this.zzcrZ + 262144L <= this.zzcqR) {
            if (this.zzLh() == 4) {
                this.zzj(4, false);
                return;
            }
            this.zzcrZ = this.zzcqR;
        }
    }

    @Override
    protected void schedule() {
        zzt.zzu(this.zzEc());
    }

    private final InputStream zzLm() throws Exception {
        this.zzcqP.reset();
        if (this.zzcsa != null) {
            this.zzcsa.zzLv();
        }
        try {
            this.zzcsa = this.zzcqN.zzLe().zza(this.zzcqN.zzLf(), this.zzcqR);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzcqP.zza(this.zzcsa, false);
        this.mResultCode = this.zzcsa.getResultCode();
        this.zzbMl = this.zzcsa.getException() != null ? this.zzcsa.getException() : this.zzbMl;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzbMl == null && this.zzLh() == 4) {
            String string = this.zzcsa.zzin("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzcqS != null && !this.zzcqS.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzcqS = string;
            if (this.zzaNu == -1L) {
                this.zzaNu = this.zzcsa.zzLB();
            }
            return this.zzcsa.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzbMl != null) {
            this.zzj(64, false);
            return;
        }
        if (!this.zzj(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzv(this), this);
        this.zzbSq = new BufferedInputStream(zza2);
        try {
            zza2.zzLo();
            if (this.zzcrY != null) {
                try {
                    this.zzcrY.doInBackground((TaskSnapshot)this.zzLi(), this.zzbSq);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzbMl = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzbMl = iOException;
        }
        if (this.zzbSq == null) {
            this.zzcsa.zzLv();
            this.zzcsa = null;
        }
        if (this.zzbMl == null && this.zzLh() == 4) {
            this.zzj(4, false);
            this.zzj(128, false);
            return;
        }
        if (!this.zzj(this.zzLh() == 32 ? 256 : 64, false)) {
            int n = this.zzLh();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzcqP.cancel();
        this.zzbMl = StorageException.fromErrorStatus(Status.zzaBs);
    }

    @Override
    protected void onProgress() {
        this.zzcrZ = this.zzcqR;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzLc() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzbMl, streamDownloadTask.mResultCode)), streamDownloadTask.zzcrZ);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzLm();
    }

    static /* synthetic */ agv zza(StreamDownloadTask streamDownloadTask, agv agv2) {
        streamDownloadTask.zzcsa = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcqR;
        private /* synthetic */ StreamDownloadTask zzcsb;

        TaskSnapshot(StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzcsb = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzcqR = l;
        }

        public long getBytesTransferred() {
            return this.zzcqR;
        }

        public long getTotalByteCount() {
            return this.zzcsb.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzcsb.zzbSq;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzcsc;
        @Nullable
        private InputStream zzcsd;
        private Callable<InputStream> zzcse;
        private IOException zzcsf;
        private int zzcsg;
        private int zzcsh;
        private boolean zzcsi;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzcsc = streamDownloadTask;
            this.zzcse = callable;
        }

        private final void zzLn() throws IOException {
            if (this.zzcsc != null && this.zzcsc.zzLh() == 32) {
                throw StorageException.zzcrb;
            }
        }

        private final void zzaN(long l) {
            if (this.zzcsc != null) {
                this.zzcsc.zzaN(l);
            }
            this.zzcsg = (int)((long)this.zzcsg + l);
        }

        private final boolean zzLo() throws IOException {
            this.zzLn();
            if (this.zzcsf != null) {
                try {
                    if (this.zzcsd != null) {
                        this.zzcsd.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzcsd = null;
                if (this.zzcsh == this.zzcsg) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzcsf);
                    return false;
                }
                int n = this.zzcsg;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzcsf);
                this.zzcsh = this.zzcsg;
                this.zzcsf = null;
            }
            if (this.zzcsi) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzcsd == null) {
                try {
                    this.zzcsd = this.zzcse.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzLo()) {
                try {
                    int n = this.zzcsd.read();
                    if (n != -1) {
                        this.zzaN(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcsf = iOException;
                }
            }
            throw this.zzcsf;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzLo()) {
                try {
                    return this.zzcsd.available();
                }
                catch (IOException iOException) {
                    this.zzcsf = iOException;
                }
            }
            throw this.zzcsf;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzcsd != null) {
                this.zzcsd.close();
            }
            this.zzcsi = true;
            if (this.zzcsc != null && this.zzcsc.zzcsa != null) {
                this.zzcsc.zzcsa.zzLv();
                StreamDownloadTask.zza(this.zzcsc, null);
            }
            this.zzLn();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzLo()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzcsd.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzaN(n4);
                        this.zzLn();
                    }
                    if (n2 > 0) {
                        n4 = this.zzcsd.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzaN(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzcsf = iOException;
                }
            }
            throw this.zzcsf;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzLo()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzcsd.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzaN(l2);
                        this.zzLn();
                    }
                    if (l > 0L) {
                        l2 = this.zzcsd.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzaN(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcsf = iOException;
                }
            }
            throw this.zzcsf;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

