/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.agj;
import com.google.android.gms.internal.agk;
import com.google.android.gms.internal.agp;
import com.google.android.gms.internal.agv;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzac;
import com.google.firebase.storage.zzt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzcqN;
    private final Uri mUri;
    private final long zzcst;
    private final agj zzcsu;
    private final AtomicLong zzcsv;
    private int zzcsw;
    private agk zzcqP;
    private boolean zzcsx;
    private volatile StorageMetadata zzcrt;
    private volatile Uri zzcsy;
    private volatile Exception zzbMl;
    private volatile Exception zzcsz;
    private volatile int mResultCode;
    private volatile String zzcsA;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzcsv = new AtomicLong(0L);
        this.zzcsw = 262144;
        this.zzcsy = null;
        this.zzbMl = null;
        this.zzcsz = null;
        this.mResultCode = 0;
        zzbr.zzu((Object)storageReference);
        zzbr.zzu((Object)byArray);
        this.zzcst = byArray.length;
        this.zzcqN = storageReference;
        this.zzcrt = storageMetadata;
        this.mUri = null;
        this.zzcsu = new agj(new ByteArrayInputStream(byArray), 262144);
        this.zzcsx = true;
        this.zzcqP = new agk(this.zzcqN.getStorage().getApp(), this.zzcqN.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzcsv = new AtomicLong(0L);
            this.zzcsw = 262144;
            this.zzcsy = null;
            this.zzbMl = null;
            this.zzcsz = null;
            this.mResultCode = 0;
            zzbr.zzu((Object)storageReference);
            zzbr.zzu((Object)uri);
            this.zzcqN = storageReference;
            this.zzcrt = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzcqP = new agk(this.zzcqN.getStorage().getApp(), this.zzcqN.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzcqN.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzbMl = fileNotFoundException;
            }
        }
        this.zzcst = l;
        this.zzcsu = new agj(inputStream, 262144);
        this.zzcsx = true;
        this.zzcsy = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzcsv = new AtomicLong(0L);
        this.zzcsw = 262144;
        this.zzcsy = null;
        this.zzbMl = null;
        this.zzcsz = null;
        this.mResultCode = 0;
        zzbr.zzu((Object)storageReference);
        zzbr.zzu((Object)inputStream);
        this.zzcst = -1L;
        this.zzcqN = storageReference;
        this.zzcrt = storageMetadata;
        this.zzcsu = new agj(inputStream, 262144);
        this.zzcsx = false;
        this.mUri = null;
        this.zzcqP = new agk(this.zzcqN.getStorage().getApp(), this.zzcqN.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzcqN;
    }

    final long getTotalByteCount() {
        return this.zzcst;
    }

    @Override
    protected void schedule() {
        zzt.zzt(this.zzEc());
    }

    @Override
    final void run() {
        agv agv2;
        UploadTask uploadTask;
        block24: {
            this.zzcqP.reset();
            if (!this.zzj(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzcqN.getParent() == null) {
                this.zzbMl = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzbMl != null) {
                return;
            }
            if (this.zzcsy == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzcrt != null) {
                    string2 = uploadTask.zzcrt.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzcqN.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    agv2 = uploadTask.zzcqN.zzLe().zza(uploadTask.zzcqN.zzLf(), uploadTask.zzcrt != null ? uploadTask.zzcrt.zzLd() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzbMl = throwable;
                    break block24;
                }
                if (uploadTask.zzc(agv2) && !TextUtils.isEmpty((CharSequence)(string = agv2.zzin("X-Goog-Upload-URL")))) {
                    uploadTask.zzcsy = Uri.parse((String)string);
                }
            } else {
                this.zzaK(false);
            }
        }
        boolean bl = this.zzLq();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzcsu.zzcg(uploadTask.zzcsw);
                    int n = Math.min(uploadTask.zzcsw, uploadTask.zzcsu.available());
                    try {
                        agv2 = uploadTask.zzcqN.zzLe().zza(uploadTask.zzcqN.zzLf(), uploadTask.zzcsy.toString(), uploadTask.zzcsu.zzLu(), uploadTask.zzcsv.get(), n, uploadTask.zzcsu.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzbMl = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(agv2)) {
                        int n2 = uploadTask.zzcsw = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzcsv.getAndAdd(n);
                    if (!uploadTask.zzcsu.isFinished()) {
                        uploadTask.zzcsu.zzcf(n);
                        if (uploadTask.zzcsw < 0x2000000) {
                            uploadTask.zzcsw <<= 1;
                            int n3 = uploadTask.zzcsw;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzcrt = new StorageMetadata.Builder(agv2.zzLD(), uploadTask.zzcqN).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(agv2.zzLy());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzbMl = throwable;
                        break block25;
                    }
                    uploadTask.zzj(4, false);
                    uploadTask.zzj(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzbMl = iOException;
                }
            }
            if (!(bl = this.zzLq())) continue;
            this.zzj(4, false);
        }
        if (this.zzcsx && this.zzLh() != 16) {
            try {
                this.zzcsu.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzbMl = null;
        this.zzcsz = null;
        this.mResultCode = 0;
        this.zzcsA = null;
    }

    private final boolean zzLq() {
        if (this.zzLh() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzbMl = new InterruptedException();
            this.zzj(64, false);
            return false;
        }
        if (this.zzLh() == 32) {
            this.zzj(256, false);
            return false;
        }
        if (this.zzLh() == 8) {
            this.zzj(16, false);
            return false;
        }
        if (!this.zzLr()) {
            return false;
        }
        if (this.zzcsy == null) {
            if (this.zzbMl == null) {
                this.zzbMl = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzj(64, false);
            return false;
        }
        if (this.zzbMl != null) {
            this.zzj(64, false);
            return false;
        }
        if ((this.zzcsz != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzaK(true)) {
            if (this.zzLr()) {
                this.zzj(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzLr() {
        if ("final".equals(this.zzcsA)) {
            if (this.zzbMl == null) {
                this.zzbMl = new IOException("The server has terminated the upload session");
            }
            this.zzj(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzaK(boolean bl) {
        agv agv2;
        try {
            agv2 = this.zzcqN.zzLe().zzb(this.zzcqN.zzLf(), this.zzcsy.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzbMl = remoteException;
            return false;
        }
        if ("final".equals(this.zzcsA)) {
            return false;
        }
        if (bl ? !this.zzc(agv2) : !this.zzb(agv2)) {
            return false;
        }
        if ("final".equals(agv2.zzin("X-Goog-Upload-Status"))) {
            this.zzbMl = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = agv2.zzin("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzcsv.get();
        if (l2 > l) {
            this.zzbMl = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzcsu.zzcf((int)(l - l2)) != l - l2) {
                    this.zzbMl = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzcsv.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzbMl = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzbMl = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(agv agv2) {
        agv2.zze(agp.zzf(this.zzcqN.getStorage().getApp()), this.zzcqN.getStorage().getApp().getApplicationContext());
        return this.zzd(agv2);
    }

    private final boolean zzc(agv agv2) {
        agv agv3 = agv2;
        this.zzcqP.zza(agv3, true);
        return this.zzd(agv2);
    }

    private final boolean zzd(agv agv2) {
        int n = agv2.getResultCode();
        this.mResultCode = agk.zzci(n) ? -2 : n;
        this.zzcsz = agv2.getException();
        this.zzcsA = agv2.zzin("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzcsz == null;
    }

    @Override
    protected void onCanceled() {
        this.zzcqP.cancel();
        agv agv2 = null;
        if (this.zzcsy != null) {
            try {
                agv2 = this.zzcqN.zzLe().zza(this.zzcqN.zzLf(), this.zzcsy.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (agv2 != null) {
            agv agv3 = agv2;
            zzt.zzs(new zzac(this, agv3));
        }
        this.zzbMl = StorageException.fromErrorStatus(Status.zzaBs);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzLc() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzbMl != null ? uploadTask.zzbMl : uploadTask.zzcsz;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzcsv.get(), uploadTask.zzcsy, uploadTask.zzcrt);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzcqN;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcsD;
        private final Uri zzcsy;
        private final StorageMetadata zzcrt;
        private /* synthetic */ UploadTask zzcsC;

        TaskSnapshot(UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzcsC = uploadTask;
            super(uploadTask, exception);
            this.zzcsD = l;
            this.zzcsy = uri;
            this.zzcrt = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzcsD;
        }

        public long getTotalByteCount() {
            return this.zzcsC.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzcsy;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzcrt;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

