/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abm;
import com.google.android.gms.internal.abq;
import com.google.android.gms.internal.abv;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzc;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzcoh = null;
    private StorageReference zzcnP = null;
    private String zzcoi = null;
    private String zzcoj = null;
    private String zzapZ = null;
    private String zzcok = null;
    private String zzcol = null;
    private String zzcom = null;
    private long zzcon;
    private String zzcoo = null;
    private String zzcop = null;
    private String zzcoq = null;
    private String zzcor = null;
    private String zzcos = null;
    private Map<String, String> zzcot = null;
    private String[] zzcou = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbo.zzu((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzcoh = storageMetadata.zzcoh;
        this.zzcnP = storageMetadata.zzcnP;
        this.zzcoi = storageMetadata.zzcoi;
        this.zzapZ = storageMetadata.zzapZ;
        this.zzcop = storageMetadata.zzcop;
        this.zzcoq = storageMetadata.zzcoq;
        this.zzcor = storageMetadata.zzcor;
        this.zzcos = storageMetadata.zzcos;
        if (storageMetadata.zzcot != null) {
            this.zzcot = new HashMap<String, String>(storageMetadata.zzcot);
        }
        this.zzcou = storageMetadata.zzcou;
        if (bl) {
            this.zzcoo = storageMetadata.zzcoo;
            this.zzcon = storageMetadata.zzcon;
            this.zzcom = storageMetadata.zzcom;
            this.zzcol = storageMetadata.zzcol;
            this.zzcok = storageMetadata.zzcok;
            this.zzcoj = storageMetadata.zzcoj;
        }
    }

    public String getContentType() {
        return this.zzapZ;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzcot == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzcot.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzcot == null) {
            return Collections.emptySet();
        }
        return this.zzcot.keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzcoi;
    }

    @Nullable
    public String getGeneration() {
        return this.zzcoj;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzcok;
    }

    public long getCreationTimeMillis() {
        return abq.zzhL(this.zzcol);
    }

    public long getUpdatedTimeMillis() {
        return abq.zzhL(this.zzcom);
    }

    public long getSizeBytes() {
        return this.zzcon;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzcoo;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzcou != null && this.zzcnP != null) {
            try {
                String string = abv.zzg(this.zzcnP.getStorage().getApp()).zzv(this.zzcnP.zzKN());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzcou;
                    int n = this.zzcou.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzcop;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzcoq;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzcor;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzcos;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzcnP == null && this.zzcoh != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(abm.zzhI((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzcoh);
        }
        return this.zzcnP;
    }

    @NonNull
    final JSONObject zzKL() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzcot != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzcot));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private final void zzhH(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzcou = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzc zzc2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzcov;
        private boolean zzcow;

        public Builder() {
            this.zzcov = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzcov = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzcov.zzcnP = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzcov = new StorageMetadata();
            if (jSONObject != null) {
                this.zzt(jSONObject);
                this.zzcow = true;
            }
        }

        private final void zzt(JSONObject jSONObject) throws JSONException {
            this.zzcov.zzcoj = jSONObject.optString("generation");
            this.zzcov.mPath = jSONObject.optString("name");
            this.zzcov.zzcoi = jSONObject.optString("bucket");
            this.zzcov.zzcok = jSONObject.optString("metageneration");
            this.zzcov.zzcol = jSONObject.optString("timeCreated");
            this.zzcov.zzcom = jSONObject.optString("updated");
            this.zzcov.zzcon = jSONObject.optLong("size");
            this.zzcov.zzcoo = jSONObject.optString("md5Hash");
            this.zzcov.zzhH(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzcov, this.zzcow, null);
        }

        public Builder setContentLanguage(String string) {
            this.zzcov.zzcos = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzcov.zzcor = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzcov.zzcoq = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzcov.zzcop = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzcov.zzcot == null) {
                this.zzcov.zzcot = new HashMap();
            }
            this.zzcov.zzcot.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzcov.zzapZ = string;
            return this;
        }
    }
}

