/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abk;
import com.google.android.gms.internal.abl;
import com.google.android.gms.internal.abq;
import com.google.android.gms.internal.abw;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzac;
import com.google.firebase.storage.zzt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzcnP;
    private final Uri mUri;
    private final long zzcpv;
    private final abk zzcpw;
    private final AtomicLong zzcpx;
    private int zzcpy;
    private abl zzcnR;
    private boolean zzcpz;
    private volatile StorageMetadata zzcov;
    private volatile Uri zzcpA;
    private volatile Exception zzbMh;
    private volatile Exception zzcpB;
    private volatile int mResultCode;
    private volatile String zzcpC;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzcpx = new AtomicLong(0L);
        this.zzcpy = 262144;
        this.zzcpA = null;
        this.zzbMh = null;
        this.zzcpB = null;
        this.mResultCode = 0;
        zzbo.zzu((Object)storageReference);
        zzbo.zzu((Object)byArray);
        this.zzcpv = byArray.length;
        this.zzcnP = storageReference;
        this.zzcov = storageMetadata;
        this.mUri = null;
        this.zzcpw = new abk(new ByteArrayInputStream(byArray), 262144);
        this.zzcpz = true;
        this.zzcnR = new abl(this.zzcnP.getStorage().getApp(), this.zzcnP.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzcpx = new AtomicLong(0L);
            this.zzcpy = 262144;
            this.zzcpA = null;
            this.zzbMh = null;
            this.zzcpB = null;
            this.mResultCode = 0;
            zzbo.zzu((Object)storageReference);
            zzbo.zzu((Object)uri);
            this.zzcnP = storageReference;
            this.zzcov = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzcnR = new abl(this.zzcnP.getStorage().getApp(), this.zzcnP.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzcnP.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzbMh = fileNotFoundException;
            }
        }
        this.zzcpv = l;
        this.zzcpw = new abk(inputStream, 262144);
        this.zzcpz = true;
        this.zzcpA = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzcpx = new AtomicLong(0L);
        this.zzcpy = 262144;
        this.zzcpA = null;
        this.zzbMh = null;
        this.zzcpB = null;
        this.mResultCode = 0;
        zzbo.zzu((Object)storageReference);
        zzbo.zzu((Object)inputStream);
        this.zzcpv = -1L;
        this.zzcnP = storageReference;
        this.zzcov = storageMetadata;
        this.zzcpw = new abk(inputStream, 262144);
        this.zzcpz = false;
        this.mUri = null;
        this.zzcnR = new abl(this.zzcnP.getStorage().getApp(), this.zzcnP.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzcnP;
    }

    final long getTotalByteCount() {
        return this.zzcpv;
    }

    @Override
    protected void schedule() {
        zzt.zzt(this.zzEe());
    }

    @Override
    final void run() {
        abw abw2;
        UploadTask uploadTask;
        block24: {
            this.zzcnR.reset();
            if (!this.zzj(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzcnP.getParent() == null) {
                this.zzbMh = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzbMh != null) {
                return;
            }
            if (this.zzcpA == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzcov != null) {
                    string2 = uploadTask.zzcov.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzcnP.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    abw2 = uploadTask.zzcnP.zzKM().zza(uploadTask.zzcnP.zzKN(), uploadTask.zzcov != null ? uploadTask.zzcov.zzKL() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzbMh = throwable;
                    break block24;
                }
                if (uploadTask.zzc(abw2) && !TextUtils.isEmpty((CharSequence)(string = abw2.zzhO("X-Goog-Upload-URL")))) {
                    uploadTask.zzcpA = Uri.parse((String)string);
                }
            } else {
                this.zzaK(false);
            }
        }
        boolean bl = this.zzKY();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzcpw.zzch(uploadTask.zzcpy);
                    int n = Math.min(uploadTask.zzcpy, uploadTask.zzcpw.available());
                    try {
                        abw2 = uploadTask.zzcnP.zzKM().zza(uploadTask.zzcnP.zzKN(), uploadTask.zzcpA.toString(), uploadTask.zzcpw.zzLc(), uploadTask.zzcpx.get(), n, uploadTask.zzcpw.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzbMh = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(abw2)) {
                        int n2 = uploadTask.zzcpy = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzcpx.getAndAdd(n);
                    if (!uploadTask.zzcpw.isFinished()) {
                        uploadTask.zzcpw.zzcg(n);
                        if (uploadTask.zzcpy < 0x2000000) {
                            uploadTask.zzcpy <<= 1;
                            int n3 = uploadTask.zzcpy;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzcov = new StorageMetadata.Builder(abw2.zzLl(), uploadTask.zzcnP).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(abw2.zzLg());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzbMh = throwable;
                        break block25;
                    }
                    uploadTask.zzj(4, false);
                    uploadTask.zzj(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzbMh = iOException;
                }
            }
            if (!(bl = this.zzKY())) continue;
            this.zzj(4, false);
        }
        if (this.zzcpz && this.zzKP() != 16) {
            try {
                this.zzcpw.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzbMh = null;
        this.zzcpB = null;
        this.mResultCode = 0;
        this.zzcpC = null;
    }

    private final boolean zzKY() {
        if (this.zzKP() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzbMh = new InterruptedException();
            this.zzj(64, false);
            return false;
        }
        if (this.zzKP() == 32) {
            this.zzj(256, false);
            return false;
        }
        if (this.zzKP() == 8) {
            this.zzj(16, false);
            return false;
        }
        if (!this.zzKZ()) {
            return false;
        }
        if (this.zzcpA == null) {
            if (this.zzbMh == null) {
                this.zzbMh = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzj(64, false);
            return false;
        }
        if (this.zzbMh != null) {
            this.zzj(64, false);
            return false;
        }
        if ((this.zzcpB != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzaK(true)) {
            if (this.zzKZ()) {
                this.zzj(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzKZ() {
        if ("final".equals(this.zzcpC)) {
            if (this.zzbMh == null) {
                this.zzbMh = new IOException("The server has terminated the upload session");
            }
            this.zzj(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzaK(boolean bl) {
        abw abw2;
        try {
            abw2 = this.zzcnP.zzKM().zzb(this.zzcnP.zzKN(), this.zzcpA.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzbMh = remoteException;
            return false;
        }
        if ("final".equals(this.zzcpC)) {
            return false;
        }
        if (bl ? !this.zzc(abw2) : !this.zzb(abw2)) {
            return false;
        }
        if ("final".equals(abw2.zzhO("X-Goog-Upload-Status"))) {
            this.zzbMh = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = abw2.zzhO("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzcpx.get();
        if (l2 > l) {
            this.zzbMh = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzcpw.zzcg((int)(l - l2)) != l - l2) {
                    this.zzbMh = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzcpx.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzbMh = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzbMh = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(abw abw2) {
        abw2.zze(abq.zzf(this.zzcnP.getStorage().getApp()), this.zzcnP.getStorage().getApp().getApplicationContext());
        return this.zzd(abw2);
    }

    private final boolean zzc(abw abw2) {
        abw abw3 = abw2;
        this.zzcnR.zza(abw3, true);
        return this.zzd(abw2);
    }

    private final boolean zzd(abw abw2) {
        int n = abw2.getResultCode();
        this.mResultCode = abl.zzcj(n) ? -2 : n;
        this.zzcpB = abw2.getException();
        this.zzcpC = abw2.zzhO("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzcpB == null;
    }

    @Override
    protected void onCanceled() {
        this.zzcnR.cancel();
        abw abw2 = null;
        if (this.zzcpA != null) {
            try {
                abw2 = this.zzcnP.zzKM().zza(this.zzcnP.zzKN(), this.zzcpA.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (abw2 != null) {
            abw abw3 = abw2;
            zzt.zzs(new zzac(this, abw3));
        }
        this.zzbMh = StorageException.fromErrorStatus(Status.zzaBq);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzKK() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzbMh != null ? uploadTask.zzbMh : uploadTask.zzcpB;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzcpx.get(), uploadTask.zzcpA, uploadTask.zzcov);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzcnP;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcpF;
        private final Uri zzcpA;
        private final StorageMetadata zzcov;
        private /* synthetic */ UploadTask zzcpE;

        TaskSnapshot(UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzcpE = uploadTask;
            super(uploadTask, exception);
            this.zzcpF = l;
            this.zzcpA = uri;
            this.zzcov = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzcpF;
        }

        public long getTotalByteCount() {
            return this.zzcpE.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzcpA;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzcov;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

