/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.aca;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class acf {
    private aca zzcpZ;
    private Exception zzbMj;
    private int zzcqa;
    private Exception zzcqb;

    public acf(@NonNull aca aca2) {
        this.zzcpZ = aca2;
    }

    public final void zzam(String string, String string2) {
        try {
            this.zzcpZ.zzam(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzhQ(String string) {
        try {
            return this.zzcpZ.zzhQ(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            acf acf2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                acf2.zzcqa = -2;
                acf2.zzcqb = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzcpZ.zzhO(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zzcqa = 0;
            this.zzcqb = null;
            this.zzcpZ.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzhP(@Nullable String string) {
        try {
            this.zzcpZ.zzhP(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzLg() {
        try {
            if (this.zzcpZ != null) {
                this.zzcpZ.zzLg();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzE((IObjectWrapper)this.zzcpZ.zzLh());
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzLo() throws RemoteException {
        return (JSONObject)zzn.zzE((IObjectWrapper)this.zzcpZ.zzLi());
    }

    @Nullable
    public final String zzLj() {
        try {
            this.zzcpZ.zzLj();
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzcqb != null) {
                return this.zzcqb;
            }
            if (this.zzbMj != null) {
                return this.zzbMj;
            }
            return (Exception)zzn.zzE((IObjectWrapper)this.zzcpZ.zzLk());
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzcqa != 0) {
                return this.zzcqa;
            }
            return this.zzcpZ.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzLl() {
        try {
            if (this.zzcqa == -2 || this.zzcqb != null) {
                return false;
            }
            return this.zzcpZ.zzLl();
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzLl() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzLm() {
        try {
            return this.zzcpZ.zzLm();
        }
        catch (RemoteException remoteException) {
            this.zzbMj = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

