/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abv;
import com.google.android.gms.internal.abz;
import com.google.android.gms.internal.ace;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzc;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzcow = null;
    private StorageReference zzcoe = null;
    private String zzcox = null;
    private String zzcoy = null;
    private String zzapZ = null;
    private String zzcoz = null;
    private String zzcoA = null;
    private String zzcoB = null;
    private long zzcoC;
    private String zzcoD = null;
    private String zzcoE = null;
    private String zzcoF = null;
    private String zzcoG = null;
    private String zzcoH = null;
    private Map<String, String> zzcoI = null;
    private String[] zzcoJ = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbo.zzu((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzcow = storageMetadata.zzcow;
        this.zzcoe = storageMetadata.zzcoe;
        this.zzcox = storageMetadata.zzcox;
        this.zzapZ = storageMetadata.zzapZ;
        this.zzcoE = storageMetadata.zzcoE;
        this.zzcoF = storageMetadata.zzcoF;
        this.zzcoG = storageMetadata.zzcoG;
        this.zzcoH = storageMetadata.zzcoH;
        if (storageMetadata.zzcoI != null) {
            this.zzcoI = new HashMap<String, String>(storageMetadata.zzcoI);
        }
        this.zzcoJ = storageMetadata.zzcoJ;
        if (bl) {
            this.zzcoD = storageMetadata.zzcoD;
            this.zzcoC = storageMetadata.zzcoC;
            this.zzcoB = storageMetadata.zzcoB;
            this.zzcoA = storageMetadata.zzcoA;
            this.zzcoz = storageMetadata.zzcoz;
            this.zzcoy = storageMetadata.zzcoy;
        }
    }

    public String getContentType() {
        return this.zzapZ;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.zzcoI == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzcoI.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.zzcoI == null) {
            return Collections.emptySet();
        }
        return this.zzcoI.keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzcox;
    }

    @Nullable
    public String getGeneration() {
        return this.zzcoy;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzcoz;
    }

    public long getCreationTimeMillis() {
        return abz.zzhL(this.zzcoA);
    }

    public long getUpdatedTimeMillis() {
        return abz.zzhL(this.zzcoB);
    }

    public long getSizeBytes() {
        return this.zzcoC;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzcoD;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzcoJ != null && this.zzcoe != null) {
            try {
                String string = ace.zzg(this.zzcoe.getStorage().getApp()).zzv(this.zzcoe.zzKP());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzcoJ;
                    int n = this.zzcoJ.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzcoE;
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzcoF;
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzcoG;
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzcoH;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzcoe == null && this.zzcow != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(abv.zzhI((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzcow);
        }
        return this.zzcoe;
    }

    @NonNull
    final JSONObject zzKN() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.zzcoI != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.zzcoI));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private final void zzhH(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzcoJ = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzc zzc2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzcoK;
        private boolean zzcoL;

        public Builder() {
            this.zzcoK = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzcoK = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzcoK.zzcoe = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzcoK = new StorageMetadata();
            if (jSONObject != null) {
                this.zzt(jSONObject);
                this.zzcoL = true;
            }
        }

        private final void zzt(JSONObject jSONObject) throws JSONException {
            this.zzcoK.zzcoy = jSONObject.optString("generation");
            this.zzcoK.mPath = jSONObject.optString("name");
            this.zzcoK.zzcox = jSONObject.optString("bucket");
            this.zzcoK.zzcoz = jSONObject.optString("metageneration");
            this.zzcoK.zzcoA = jSONObject.optString("timeCreated");
            this.zzcoK.zzcoB = jSONObject.optString("updated");
            this.zzcoK.zzcoC = jSONObject.optLong("size");
            this.zzcoK.zzcoD = jSONObject.optString("md5Hash");
            this.zzcoK.zzhH(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzcoK, this.zzcoL, null);
        }

        public Builder setContentLanguage(String string) {
            this.zzcoK.zzcoH = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.zzcoK.zzcoG = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.zzcoK.zzcoF = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.zzcoK.zzcoE = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.zzcoK.zzcoI == null) {
                this.zzcoK.zzcoI = new HashMap();
            }
            this.zzcoK.zzcoI.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.zzcoK.zzapZ = string;
            return this;
        }
    }
}

