/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abv;
import com.google.android.gms.internal.ace;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.FileDownloadTask;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.StreamDownloadTask;
import com.google.firebase.storage.UploadTask;
import com.google.firebase.storage.zza;
import com.google.firebase.storage.zzab;
import com.google.firebase.storage.zzb;
import com.google.firebase.storage.zzd;
import com.google.firebase.storage.zze;
import com.google.firebase.storage.zzf;
import com.google.firebase.storage.zzg;
import com.google.firebase.storage.zzh;
import com.google.firebase.storage.zzs;
import com.google.firebase.storage.zzt;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class StorageReference {
    private final Uri zzcoM;
    private final FirebaseStorage zzcoN;

    StorageReference(@NonNull Uri uri, @NonNull FirebaseStorage firebaseStorage) {
        zzbo.zzb((uri != null ? 1 : 0) != 0, (Object)"storageUri cannot be null");
        zzbo.zzb((firebaseStorage != null ? 1 : 0) != 0, (Object)"FirebaseApp cannot be null");
        this.zzcoM = uri;
        this.zzcoN = firebaseStorage;
    }

    @NonNull
    public StorageReference child(@NonNull String string) {
        Uri uri;
        zzbo.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"childName cannot be null or empty");
        string = abv.zzhK((String)string);
        try {
            uri = this.zzcoM.buildUpon().appendEncodedPath(abv.zzhI((String)string)).build();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = String.valueOf(string);
            Log.e((String)"StorageReference", (String)(string2.length() != 0 ? "Unable to create a valid default Uri. ".concat(string2) : new String("Unable to create a valid default Uri. ")), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException("childName");
        }
        return new StorageReference(uri, this.zzcoN);
    }

    @Nullable
    public StorageReference getParent() {
        String string = this.zzcoM.getPath();
        if (string == null || string.equals("/")) {
            return null;
        }
        int n = string.lastIndexOf(47);
        string = n == -1 ? "/" : string.substring(0, n);
        Uri uri = this.zzcoM.buildUpon().path(string).build();
        return new StorageReference(uri, this.zzcoN);
    }

    @NonNull
    public StorageReference getRoot() {
        Uri uri = this.zzcoM.buildUpon().path("").build();
        return new StorageReference(uri, this.zzcoN);
    }

    @NonNull
    public String getName() {
        String string = this.zzcoM.getPath();
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @NonNull
    public String getPath() {
        return this.zzcoM.getPath();
    }

    @NonNull
    public String getBucket() {
        return this.zzcoM.getAuthority();
    }

    @NonNull
    public FirebaseStorage getStorage() {
        return this.zzcoN;
    }

    @NonNull
    final ace zzKO() throws RemoteException {
        return ace.zzg(this.getStorage().getApp());
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray) {
        zzbo.zzb((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, byArray);
        uploadTask.zzKQ();
        return uploadTask;
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray, @NonNull StorageMetadata storageMetadata) {
        zzbo.zzb((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        zzbo.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, byArray);
        uploadTask.zzKQ();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri) {
        zzbo.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, uri, null);
        uploadTask.zzKQ();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @NonNull StorageMetadata storageMetadata) {
        zzbo.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzbo.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, null);
        uploadTask.zzKQ();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @Nullable StorageMetadata storageMetadata, @Nullable Uri uri2) {
        zzbo.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzbo.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, uri2);
        uploadTask.zzKQ();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream) {
        zzbo.zzb((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, inputStream);
        uploadTask.zzKQ();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream, @NonNull StorageMetadata storageMetadata) {
        zzbo.zzb((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        zzbo.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, inputStream);
        uploadTask.zzKQ();
        return uploadTask;
    }

    @NonNull
    public List<UploadTask> getActiveUploadTasks() {
        return zzs.zzKV().zza(this);
    }

    @NonNull
    public List<FileDownloadTask> getActiveDownloadTasks() {
        return zzs.zzKV().zzb(this);
    }

    @NonNull
    public Task<StorageMetadata> getMetadata() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzt.zzs(new zzb(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Uri> getDownloadUrl() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Task<StorageMetadata> task = this.getMetadata();
        task.addOnSuccessListener((OnSuccessListener)new zzd(this, taskCompletionSource));
        task.addOnFailureListener((OnFailureListener)new zze(this, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<StorageMetadata> updateMetadata(@NonNull StorageMetadata storageMetadata) {
        zzbo.zzu((Object)storageMetadata);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzt.zzs(new zzab(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource, storageMetadata));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<byte[]> getBytes(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        ((StorageTask)streamDownloadTask.zza(new zzh(this, l, taskCompletionSource)).addOnSuccessListener(new zzg(this, taskCompletionSource))).addOnFailureListener(new zzf(this, taskCompletionSource));
        streamDownloadTask.zzKQ();
        return taskCompletionSource.getTask();
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull Uri uri) {
        FileDownloadTask fileDownloadTask = new FileDownloadTask(this, uri);
        fileDownloadTask.zzKQ();
        return fileDownloadTask;
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull File file) {
        return this.getFile(Uri.fromFile((File)file));
    }

    @NonNull
    public StreamDownloadTask getStream() {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zzKQ();
        return streamDownloadTask;
    }

    @NonNull
    public StreamDownloadTask getStream(@NonNull StreamDownloadTask.StreamProcessor streamProcessor) {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zza(streamProcessor);
        streamDownloadTask.zzKQ();
        return streamDownloadTask;
    }

    public Task<Void> delete() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzt.zzs(new zza(this, (TaskCompletionSource<Void>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    final Uri zzKP() {
        return this.zzcoM;
    }

    public String toString() {
        String string = String.valueOf(this.zzcoM.getAuthority());
        String string2 = String.valueOf(this.zzcoM.getEncodedPath());
        return new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length()).append("gs://").append(string).append(string2).toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StorageReference)) {
            return false;
        }
        return ((StorageReference)object).toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

