/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.abu;
import com.google.android.gms.internal.acf;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzv;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzcoe;
    private abu zzcog;
    private volatile Exception zzbMj = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzcpp;
    private long zzaNq = -1L;
    private long zzcoi;
    private long zzcpq;
    private InputStream zzbSo;
    private acf zzcpr;
    private String zzcoj;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzcoe = storageReference;
        this.zzcog = new abu(this.zzcoe.getStorage().getApp(), this.zzcoe.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbo.zzu((Object)streamProcessor);
        zzbo.zzae((this.zzcpp == null ? 1 : 0) != 0);
        this.zzcpp = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzcoe;
    }

    final long getTotalBytes() {
        return this.zzaNq;
    }

    final void zzaN(long l) {
        this.zzcoi += l;
        if (this.zzcpq + 262144L <= this.zzcoi) {
            if (this.zzKR() == 4) {
                this.zzj(4, false);
                return;
            }
            this.zzcpq = this.zzcoi;
        }
    }

    @Override
    protected void schedule() {
        zzt.zzu(this.zzEf());
    }

    private final InputStream zzKW() throws Exception {
        this.zzcog.reset();
        if (this.zzcpr != null) {
            this.zzcpr.zzLf();
        }
        try {
            this.zzcpr = this.zzcoe.zzKO().zza(this.zzcoe.zzKP(), this.zzcoi);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzcog.zza(this.zzcpr, false);
        this.mResultCode = this.zzcpr.getResultCode();
        this.zzbMj = this.zzcpr.getException() != null ? this.zzcpr.getException() : this.zzbMj;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzbMj == null && this.zzKR() == 4) {
            String string = this.zzcpr.zzhO("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzcoj != null && !this.zzcoj.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzcoj = string;
            if (this.zzaNq == -1L) {
                this.zzaNq = this.zzcpr.zzLl();
            }
            return this.zzcpr.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzbMj != null) {
            this.zzj(64, false);
            return;
        }
        if (!this.zzj(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzv(this), this);
        this.zzbSo = new BufferedInputStream(zza2);
        try {
            zza2.zzKY();
            if (this.zzcpp != null) {
                try {
                    this.zzcpp.doInBackground((TaskSnapshot)this.zzKS(), this.zzbSo);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzbMj = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzbMj = iOException;
        }
        if (this.zzbSo == null) {
            this.zzcpr.zzLf();
            this.zzcpr = null;
        }
        if (this.zzbMj == null && this.zzKR() == 4) {
            this.zzj(4, false);
            this.zzj(128, false);
            return;
        }
        if (!this.zzj(this.zzKR() == 32 ? 256 : 64, false)) {
            int n = this.zzKR();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzcog.cancel();
        this.zzbMj = StorageException.fromErrorStatus(Status.zzaBq);
    }

    @Override
    protected void onProgress() {
        this.zzcpq = this.zzcoi;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzKM() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzbMj, streamDownloadTask.mResultCode)), streamDownloadTask.zzcpq);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzKW();
    }

    static /* synthetic */ acf zza(StreamDownloadTask streamDownloadTask, acf acf2) {
        streamDownloadTask.zzcpr = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzcoi;
        private /* synthetic */ StreamDownloadTask zzcps;

        TaskSnapshot(StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzcps = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzcoi = l;
        }

        public long getBytesTransferred() {
            return this.zzcoi;
        }

        public long getTotalByteCount() {
            return this.zzcps.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzcps.zzbSo;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzcpt;
        @Nullable
        private InputStream zzcpu;
        private Callable<InputStream> zzcpv;
        private IOException zzcpw;
        private int zzcpx;
        private int zzcpy;
        private boolean zzcpz;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzcpt = streamDownloadTask;
            this.zzcpv = callable;
        }

        private final void zzKX() throws IOException {
            if (this.zzcpt != null && this.zzcpt.zzKR() == 32) {
                throw StorageException.zzcos;
            }
        }

        private final void zzaN(long l) {
            if (this.zzcpt != null) {
                this.zzcpt.zzaN(l);
            }
            this.zzcpx = (int)((long)this.zzcpx + l);
        }

        private final boolean zzKY() throws IOException {
            this.zzKX();
            if (this.zzcpw != null) {
                try {
                    if (this.zzcpu != null) {
                        this.zzcpu.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzcpu = null;
                if (this.zzcpy == this.zzcpx) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzcpw);
                    return false;
                }
                int n = this.zzcpx;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzcpw);
                this.zzcpy = this.zzcpx;
                this.zzcpw = null;
            }
            if (this.zzcpz) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzcpu == null) {
                try {
                    this.zzcpu = this.zzcpv.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzKY()) {
                try {
                    int n = this.zzcpu.read();
                    if (n != -1) {
                        this.zzaN(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcpw = iOException;
                }
            }
            throw this.zzcpw;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzKY()) {
                try {
                    return this.zzcpu.available();
                }
                catch (IOException iOException) {
                    this.zzcpw = iOException;
                }
            }
            throw this.zzcpw;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzcpu != null) {
                this.zzcpu.close();
            }
            this.zzcpz = true;
            if (this.zzcpt != null && this.zzcpt.zzcpr != null) {
                this.zzcpt.zzcpr.zzLf();
                StreamDownloadTask.zza(this.zzcpt, null);
            }
            this.zzKX();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzKY()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzcpu.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzaN(n4);
                        this.zzKX();
                    }
                    if (n2 > 0) {
                        n4 = this.zzcpu.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzaN(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzcpw = iOException;
                }
            }
            throw this.zzcpw;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzKY()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzcpu.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzaN(l2);
                        this.zzKX();
                    }
                    if (l > 0L) {
                        l2 = this.zzcpu.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzaN(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzcpw = iOException;
                }
            }
            throw this.zzcpw;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

