/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzebz;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class zzece {
    private zzebz zzmul;
    private Exception zzkgb;
    private int zzmum;
    private Exception zzmun;

    public zzece(@NonNull zzebz zzebz2) {
        this.zzmul = zzebz2;
    }

    public final void zzbp(String string, String string2) {
        try {
            this.zzmul.zzbp(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzqz(String string) {
        try {
            return this.zzmul.zzqz(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            zzece zzece2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                zzece2.zzmum = -2;
                zzece2.zzmun = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzmul.zzqx(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zzmum = 0;
            this.zzmun = null;
            this.zzmul.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzqy(@Nullable String string) {
        try {
            this.zzmul.zzqy(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzcax() {
        try {
            if (this.zzmul != null) {
                this.zzmul.zzcax();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzab((IObjectWrapper)this.zzmul.zzcay());
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzcbf() throws RemoteException {
        return (JSONObject)zzn.zzab((IObjectWrapper)this.zzmul.zzcaz());
    }

    @Nullable
    public final String zzcba() {
        try {
            this.zzmul.zzcba();
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzmun != null) {
                return this.zzmun;
            }
            if (this.zzkgb != null) {
                return this.zzkgb;
            }
            return (Exception)zzn.zzab((IObjectWrapper)this.zzmul.zzcbb());
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzmum != 0) {
                return this.zzmum;
            }
            return this.zzmul.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzcbc() {
        try {
            if (this.zzmum == -2 || this.zzmun != null) {
                return false;
            }
            return this.zzmul.zzcbc();
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzcbc() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzcbd() {
        try {
            return this.zzmul.zzcbd();
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

