/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzebu;
import com.google.android.gms.internal.zzeby;
import com.google.android.gms.internal.zzecd;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzd;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzmqv = null;
    private StorageReference zzmqd = null;
    private String zzmqw = null;
    private String zzmqx = null;
    private zza<String> zzmqy = zza.zzbt("");
    private String zzmqz = null;
    private String zzmra = null;
    private String zzmrb = null;
    private long zzmrc;
    private String zzmrd = null;
    private zza<String> zzmre = zza.zzbt("");
    private zza<String> zzmrf = zza.zzbt("");
    private zza<String> zzmrg = zza.zzbt("");
    private zza<String> zzmrh = zza.zzbt("");
    private zza<Map<String, String>> zzmri = zza.zzbt(Collections.emptyMap());
    private String[] zzmrj = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbp.zzu((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzmqv = storageMetadata.zzmqv;
        this.zzmqd = storageMetadata.zzmqd;
        this.zzmqw = storageMetadata.zzmqw;
        this.zzmqy = storageMetadata.zzmqy;
        this.zzmre = storageMetadata.zzmre;
        this.zzmrf = storageMetadata.zzmrf;
        this.zzmrg = storageMetadata.zzmrg;
        this.zzmrh = storageMetadata.zzmrh;
        this.zzmri = storageMetadata.zzmri;
        this.zzmrj = storageMetadata.zzmrj;
        if (bl) {
            this.zzmrd = storageMetadata.zzmrd;
            this.zzmrc = storageMetadata.zzmrc;
            this.zzmrb = storageMetadata.zzmrb;
            this.zzmra = storageMetadata.zzmra;
            this.zzmqz = storageMetadata.zzmqz;
            this.zzmqx = storageMetadata.zzmqx;
        }
    }

    public String getContentType() {
        return this.zzmqy.getValue();
    }

    public String getCustomMetadata(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzmri.getValue().get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        return this.zzmri.getValue().keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzmqw;
    }

    @Nullable
    public String getGeneration() {
        return this.zzmqx;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzmqz;
    }

    public long getCreationTimeMillis() {
        return zzeby.zzqw(this.zzmra);
    }

    public long getUpdatedTimeMillis() {
        return zzeby.zzqw(this.zzmrb);
    }

    public long getSizeBytes() {
        return this.zzmrc;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzmrd;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzmrj != null && this.zzmqd != null) {
            try {
                String string = zzecd.zzg(this.zzmqd.getStorage().getApp()).zzv(this.zzmqd.zzcah());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzmrj;
                    int n = this.zzmrj.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzmre.getValue();
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzmrf.getValue();
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzmrg.getValue();
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzmrh.getValue();
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzmqd == null && this.zzmqv != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzebu.zzqt((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzmqv);
        }
        return this.zzmqd;
    }

    @NonNull
    final JSONObject zzcae() throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.zzmqy.zzcaf()) {
            hashMap.put("contentType", this.getContentType());
        }
        if (this.zzmri.zzcaf()) {
            hashMap.put("metadata", (String)new JSONObject(this.zzmri.getValue()));
        }
        if (this.zzmre.zzcaf()) {
            hashMap.put("cacheControl", this.getCacheControl());
        }
        if (this.zzmrf.zzcaf()) {
            hashMap.put("contentDisposition", this.getContentDisposition());
        }
        if (this.zzmrg.zzcaf()) {
            hashMap.put("contentEncoding", this.getContentEncoding());
        }
        if (this.zzmrh.zzcaf()) {
            hashMap.put("contentLanguage", this.getContentLanguage());
        }
        return new JSONObject(hashMap);
    }

    private final void zzqs(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzmrj = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzd zzd2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzmrk;
        private boolean zzmrl;

        public Builder() {
            this.zzmrk = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzmrk = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzmrk.zzmqd = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzmrk = new StorageMetadata();
            if (jSONObject != null) {
                this.zzt(jSONObject);
                this.zzmrl = true;
            }
        }

        @Nullable
        private static String zze(JSONObject jSONObject, String string) throws JSONException {
            if (jSONObject.has(string) && !jSONObject.isNull(string)) {
                return jSONObject.getString(string);
            }
            return null;
        }

        private final void zzt(JSONObject jSONObject) throws JSONException {
            String string;
            this.zzmrk.zzmqx = jSONObject.optString("generation");
            this.zzmrk.mPath = jSONObject.optString("name");
            this.zzmrk.zzmqw = jSONObject.optString("bucket");
            this.zzmrk.zzmqz = jSONObject.optString("metageneration");
            this.zzmrk.zzmra = jSONObject.optString("timeCreated");
            this.zzmrk.zzmrb = jSONObject.optString("updated");
            this.zzmrk.zzmrc = jSONObject.optLong("size");
            this.zzmrk.zzmrd = jSONObject.optString("md5Hash");
            this.zzmrk.zzqs(jSONObject.optString("downloadTokens"));
            if (jSONObject.has("metadata") && !jSONObject.isNull("metadata")) {
                string = jSONObject.getJSONObject("metadata");
                Iterator iterator = string.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.setCustomMetadata(string2, string.getString(string2));
                }
            }
            if ((string = Builder.zze(jSONObject, "contentType")) != null) {
                this.setContentType(string);
            }
            if ((string = Builder.zze(jSONObject, "cacheControl")) != null) {
                this.setCacheControl(string);
            }
            if ((string = Builder.zze(jSONObject, "contentDisposition")) != null) {
                this.setContentDisposition(string);
            }
            if ((string = Builder.zze(jSONObject, "contentEncoding")) != null) {
                this.setContentEncoding(string);
            }
            if ((string = Builder.zze(jSONObject, "contentLanguage")) != null) {
                this.setContentLanguage(string);
            }
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzmrk, this.zzmrl, null);
        }

        public Builder setContentLanguage(@Nullable String string) {
            this.zzmrk.zzmrh = zza.zzbu(string);
            return this;
        }

        public Builder setContentEncoding(@Nullable String string) {
            this.zzmrk.zzmrg = zza.zzbu(string);
            return this;
        }

        public Builder setContentDisposition(@Nullable String string) {
            this.zzmrk.zzmrf = zza.zzbu(string);
            return this;
        }

        public Builder setCacheControl(@Nullable String string) {
            this.zzmrk.zzmre = zza.zzbu(string);
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (!this.zzmrk.zzmri.zzcaf()) {
                this.zzmrk.zzmri = zza.zzbu(new HashMap());
            }
            ((Map)this.zzmrk.zzmri.getValue()).put(string, string2);
            return this;
        }

        public Builder setContentType(@Nullable String string) {
            this.zzmrk.zzmqy = zza.zzbu(string);
            return this;
        }
    }

    static final class zza<T> {
        private final boolean zzmrm;
        @Nullable
        private final T value;

        private zza(@Nullable T t, boolean bl) {
            this.zzmrm = bl;
            this.value = t;
        }

        static <T> zza<T> zzbt(T t) {
            return new zza<T>(t, false);
        }

        static <T> zza<T> zzbu(@Nullable T t) {
            return new zza<T>(t, true);
        }

        final boolean zzcaf() {
            return this.zzmrm;
        }

        @Nullable
        final T getValue() {
            return this.value;
        }
    }
}

