/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzebs;
import com.google.android.gms.internal.zzebt;
import com.google.android.gms.internal.zzeby;
import com.google.android.gms.internal.zzece;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzad;
import com.google.firebase.storage.zzu;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzmqd;
    private final Uri mUri;
    private final long zzmtl;
    private final zzebs zzmtm;
    private final AtomicLong zzmtn;
    private int zzmto;
    private zzebt zzmqf;
    private boolean zzmtp;
    private volatile StorageMetadata zzmrk;
    private volatile Uri zzmtq;
    private volatile Exception zzkgb;
    private volatile Exception zzmtr;
    private volatile int mResultCode;
    private volatile String zzmts;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzmtn = new AtomicLong(0L);
        this.zzmto = 262144;
        this.zzmtq = null;
        this.zzkgb = null;
        this.zzmtr = null;
        this.mResultCode = 0;
        zzbp.zzu((Object)storageReference);
        zzbp.zzu((Object)byArray);
        this.zzmtl = byArray.length;
        this.zzmqd = storageReference;
        this.zzmrk = storageMetadata;
        this.mUri = null;
        this.zzmtm = new zzebs(new ByteArrayInputStream(byArray), 262144);
        this.zzmtp = true;
        this.zzmqf = new zzebt(this.zzmqd.getStorage().getApp(), this.zzmqd.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzmtn = new AtomicLong(0L);
            this.zzmto = 262144;
            this.zzmtq = null;
            this.zzkgb = null;
            this.zzmtr = null;
            this.mResultCode = 0;
            zzbp.zzu((Object)storageReference);
            zzbp.zzu((Object)uri);
            this.zzmqd = storageReference;
            this.zzmrk = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzmqf = new zzebt(this.zzmqd.getStorage().getApp(), this.zzmqd.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzmqd.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzkgb = fileNotFoundException;
            }
        }
        this.zzmtl = l;
        this.zzmtm = new zzebs(inputStream, 262144);
        this.zzmtp = true;
        this.zzmtq = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzmtn = new AtomicLong(0L);
        this.zzmto = 262144;
        this.zzmtq = null;
        this.zzkgb = null;
        this.zzmtr = null;
        this.mResultCode = 0;
        zzbp.zzu((Object)storageReference);
        zzbp.zzu((Object)inputStream);
        this.zzmtl = -1L;
        this.zzmqd = storageReference;
        this.zzmrk = storageMetadata;
        this.zzmtm = new zzebs(inputStream, 262144);
        this.zzmtp = false;
        this.mUri = null;
        this.zzmqf = new zzebt(this.zzmqd.getStorage().getApp(), this.zzmqd.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzmqd;
    }

    final long getTotalByteCount() {
        return this.zzmtl;
    }

    @Override
    protected void schedule() {
        zzu.zzq(this.zzbjc());
    }

    @Override
    final void run() {
        zzece zzece2;
        UploadTask uploadTask;
        block24: {
            this.zzmqf.reset();
            if (!this.zzk(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzmqd.getParent() == null) {
                this.zzkgb = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzkgb != null) {
                return;
            }
            if (this.zzmtq == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzmrk != null) {
                    string2 = uploadTask.zzmrk.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzmqd.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    zzece2 = uploadTask.zzmqd.zzcag().zza(uploadTask.zzmqd.zzcah(), uploadTask.zzmrk != null ? uploadTask.zzmrk.zzcae() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzkgb = throwable;
                    break block24;
                }
                if (uploadTask.zzc(zzece2) && !TextUtils.isEmpty((CharSequence)(string = zzece2.zzqz("X-Goog-Upload-URL")))) {
                    uploadTask.zzmtq = Uri.parse((String)string);
                }
            } else {
                this.zzcl(false);
            }
        }
        boolean bl = this.zzcas();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzmtm.zzge(uploadTask.zzmto);
                    int n = Math.min(uploadTask.zzmto, uploadTask.zzmtm.available());
                    try {
                        zzece2 = uploadTask.zzmqd.zzcag().zza(uploadTask.zzmqd.zzcah(), uploadTask.zzmtq.toString(), uploadTask.zzmtm.zzcaw(), uploadTask.zzmtn.get(), n, uploadTask.zzmtm.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzkgb = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(zzece2)) {
                        int n2 = uploadTask.zzmto = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzmtn.getAndAdd(n);
                    if (!uploadTask.zzmtm.isFinished()) {
                        uploadTask.zzmtm.zzgd(n);
                        if (uploadTask.zzmto < 0x2000000) {
                            uploadTask.zzmto <<= 1;
                            int n3 = uploadTask.zzmto;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzmrk = new StorageMetadata.Builder(zzece2.zzcbf(), uploadTask.zzmqd).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(zzece2.zzcba());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzkgb = throwable;
                        break block25;
                    }
                    uploadTask.zzk(4, false);
                    uploadTask.zzk(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzkgb = iOException;
                }
            }
            if (!(bl = this.zzcas())) continue;
            this.zzk(4, false);
        }
        if (this.zzmtp && this.zzcaj() != 16) {
            try {
                this.zzmtm.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzkgb = null;
        this.zzmtr = null;
        this.mResultCode = 0;
        this.zzmts = null;
    }

    private final boolean zzcas() {
        if (this.zzcaj() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzkgb = new InterruptedException();
            this.zzk(64, false);
            return false;
        }
        if (this.zzcaj() == 32) {
            this.zzk(256, false);
            return false;
        }
        if (this.zzcaj() == 8) {
            this.zzk(16, false);
            return false;
        }
        if (!this.zzcat()) {
            return false;
        }
        if (this.zzmtq == null) {
            if (this.zzkgb == null) {
                this.zzkgb = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzk(64, false);
            return false;
        }
        if (this.zzkgb != null) {
            this.zzk(64, false);
            return false;
        }
        if ((this.zzmtr != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzcl(true)) {
            if (this.zzcat()) {
                this.zzk(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzcat() {
        if ("final".equals(this.zzmts)) {
            if (this.zzkgb == null) {
                this.zzkgb = new IOException("The server has terminated the upload session");
            }
            this.zzk(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzcl(boolean bl) {
        zzece zzece2;
        try {
            zzece2 = this.zzmqd.zzcag().zzb(this.zzmqd.zzcah(), this.zzmtq.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzkgb = remoteException;
            return false;
        }
        if ("final".equals(this.zzmts)) {
            return false;
        }
        if (bl ? !this.zzc(zzece2) : !this.zzb(zzece2)) {
            return false;
        }
        if ("final".equals(zzece2.zzqz("X-Goog-Upload-Status"))) {
            this.zzkgb = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzece2.zzqz("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzmtn.get();
        if (l2 > l) {
            this.zzkgb = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzmtm.zzgd((int)(l - l2)) != l - l2) {
                    this.zzkgb = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzmtn.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzkgb = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzkgb = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(zzece zzece2) {
        zzece2.zze(zzeby.zzf(this.zzmqd.getStorage().getApp()), this.zzmqd.getStorage().getApp().getApplicationContext());
        return this.zzd(zzece2);
    }

    private final boolean zzc(zzece zzece2) {
        zzece zzece3 = zzece2;
        this.zzmqf.zza(zzece3, true);
        return this.zzd(zzece2);
    }

    private final boolean zzd(zzece zzece2) {
        int n = zzece2.getResultCode();
        this.mResultCode = zzebt.zzgg(n) ? -2 : n;
        this.zzmtr = zzece2.getException();
        this.zzmts = zzece2.zzqz("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzmtr == null;
    }

    @Override
    protected void onCanceled() {
        this.zzmqf.cancel();
        zzece zzece2 = null;
        if (this.zzmtq != null) {
            try {
                zzece2 = this.zzmqd.zzcag().zza(this.zzmqd.zzcah(), this.zzmtq.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzece2 != null) {
            zzece zzece3 = zzece2;
            zzu.zzp(new zzad(this, zzece3));
        }
        this.zzkgb = StorageException.fromErrorStatus(Status.zzfht);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcad() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzkgb != null ? uploadTask.zzkgb : uploadTask.zzmtr;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzmtn.get(), uploadTask.zzmtq, uploadTask.zzmrk);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzmqd;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzmtv;
        private final Uri zzmtq;
        private final StorageMetadata zzmrk;
        private /* synthetic */ UploadTask zzmtu;

        TaskSnapshot(@Nullable UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzmtu = uploadTask;
            super(uploadTask, exception);
            this.zzmtv = l;
            this.zzmtq = uri;
            this.zzmrk = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzmtv;
        }

        public long getTotalByteCount() {
            return this.zzmtu.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzmtq;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzmrk;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

