/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzecm;
import com.google.android.gms.internal.zzecn;
import com.google.android.gms.internal.zzecp;
import com.google.firebase.FirebaseApp;
import org.json.JSONObject;

public final class zzeco {
    private static final Object zzmvb = new Object();
    private static volatile zzeco zzmvc;
    private zzecm zzmvd;
    private Context mContext;
    private FirebaseApp zzmix;

    private zzeco(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        this.mContext = firebaseApp.getApplicationContext();
        this.zzmix = firebaseApp;
        try {
            IInterface iInterface;
            DynamiteModule dynamiteModule = DynamiteModule.zza((Context)this.mContext, (DynamiteModule.zzd)DynamiteModule.zzgpj, (String)"com.google.android.gms.firebasestorage");
            IBinder iBinder = dynamiteModule.zzgv("com.google.firebase.storage.network.NetworkRequestFactoryImpl");
            this.zzmvd = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.firebase.storage.network.INetworkRequestFactory")) instanceof zzecm ? (zzecm)iInterface : new zzecn(iBinder));
        }
        catch (DynamiteModule.zzc zzc2) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"NetworkRequestFactoryProxy failed with a RemoteException:", (Throwable)zzc2);
            throw new RemoteException();
        }
        if (this.zzmvd == null) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"Unable to load Firebase Storage Network layer.");
            throw new RemoteException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzeco zzg(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        if (zzmvc == null) {
            Object object = zzmvb;
            synchronized (object) {
                if (zzmvc == null) {
                    zzmvc = new zzeco(firebaseApp);
                }
            }
        }
        return zzmvc;
    }

    private final zzecp zze(zzecp zzecp2) {
        zzecp2.zzbp("x-firebase-gmpid", this.zzmix.getOptions().getApplicationId());
        return zzecp2;
    }

    @NonNull
    public final zzecp zzw(Uri uri) throws RemoteException {
        return this.zze(new zzecp(this.zzmvd.zza(uri, zzn.zzw((Object)this.mContext))));
    }

    @NonNull
    public final zzecp zzx(Uri uri) throws RemoteException {
        return this.zze(new zzecp(this.zzmvd.zzb(uri, zzn.zzw((Object)this.mContext))));
    }

    @NonNull
    public final zzecp zza(Uri uri, long l) throws RemoteException {
        return this.zze(new zzecp(this.zzmvd.zza(uri, zzn.zzw((Object)this.mContext), l)));
    }

    @NonNull
    public final zzecp zza(Uri uri, String string, byte[] byArray, long l, int n, boolean bl) throws RemoteException {
        return this.zze(new zzecp(this.zzmvd.zza(uri, zzn.zzw((Object)this.mContext), string, zzn.zzw((Object)byArray), l, n, bl)));
    }

    @Nullable
    public final zzecp zza(Uri uri, String string) throws RemoteException {
        return this.zze(new zzecp(this.zzmvd.zza(uri, zzn.zzw((Object)this.mContext), string)));
    }

    @NonNull
    public final zzecp zzb(Uri uri, String string) throws RemoteException {
        return this.zze(new zzecp(this.zzmvd.zzb(uri, zzn.zzw((Object)this.mContext), string)));
    }

    @NonNull
    public final zzecp zza(Uri uri, JSONObject jSONObject, String string) throws RemoteException {
        return this.zze(new zzecp(this.zzmvd.zza(uri, zzn.zzw((Object)this.mContext), zzn.zzw((Object)jSONObject), string)));
    }

    @NonNull
    public final zzecp zza(Uri uri, JSONObject jSONObject) throws RemoteException {
        return this.zze(new zzecp(this.zzmvd.zza(uri, zzn.zzw((Object)this.mContext), zzn.zzw((Object)jSONObject))));
    }

    @Nullable
    public final String zzcbi() {
        try {
            return this.zzmvd.zzcbi();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getBackendAuthority failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @Nullable
    public final String zzv(Uri uri) {
        try {
            return this.zzmvd.zzv(uri);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getDefaultURL failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }
}

