/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzeck;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class zzecp {
    private zzeck zzmve;
    private Exception zzkgb;
    private int zzmvf;
    private Exception zzmvg;

    public zzecp(@NonNull zzeck zzeck2) {
        this.zzmve = zzeck2;
    }

    public final void zzbp(String string, String string2) {
        try {
            this.zzmve.zzbp(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzqx(String string) {
        try {
            return this.zzmve.zzqx(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            zzecp zzecp2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                zzecp2.zzmvf = -2;
                zzecp2.zzmvg = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzmve.zzqv(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zzmvf = 0;
            this.zzmvg = null;
            this.zzmve.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzqw(@Nullable String string) {
        try {
            this.zzmve.zzqw(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzcbb() {
        try {
            if (this.zzmve != null) {
                this.zzmve.zzcbb();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzab((IObjectWrapper)this.zzmve.zzcbc());
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzcbj() throws RemoteException {
        return (JSONObject)zzn.zzab((IObjectWrapper)this.zzmve.zzcbd());
    }

    @Nullable
    public final String zzcbe() {
        try {
            this.zzmve.zzcbe();
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzmvg != null) {
                return this.zzmvg;
            }
            if (this.zzkgb != null) {
                return this.zzkgb;
            }
            return (Exception)zzn.zzab((IObjectWrapper)this.zzmve.zzcbf());
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzmvf != 0) {
                return this.zzmvf;
            }
            return this.zzmve.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzcbg() {
        try {
            if (this.zzmvf == -2 || this.zzmvg != null) {
                return false;
            }
            return this.zzmve.zzcbg();
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzcbg() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzcbh() {
        try {
            return this.zzmve.zzcbh();
        }
        catch (RemoteException remoteException) {
            this.zzkgb = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

