/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzece;
import com.google.android.gms.internal.zzeco;
import com.google.android.gms.internal.zzecp;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzmqz;
    private long zzmra;
    private StorageReference zzmqw;
    private zzece zzmqy;
    private long zzgft = -1L;
    private String zzmrb = null;
    private volatile Exception zzkgb = null;
    private long zzmrc = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzmqw = storageReference;
        this.zzmqz = uri;
        this.zzmqy = new zzece(this.zzmqw.getStorage().getApp(), this.zzmqw.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzgft;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzmqw;
    }

    @Override
    protected void schedule() {
        zzu.zzr(this.zzbjc());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzkgb = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(zzecp zzecp2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzecp2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zzmqz.getPath());
            if (!file.exists()) {
                if (this.zzmrc > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzmrc > 0L) {
                object = file.getAbsolutePath();
                long l = this.zzmrc;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzmra += (long)n;
                    if (this.zzkgb != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzkgb);
                        this.zzkgb = null;
                        bl = false;
                    }
                    if (this.zzk(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzkgb = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    final void run() {
        if (this.zzkgb != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        do {
            Object object;
            zzecp zzecp2;
            this.zzmra = 0L;
            this.zzkgb = null;
            this.zzmqy.reset();
            try {
                zzecp2 = zzeco.zzg(this.zzmqw.getStorage().getApp()).zza(this.zzmqw.zzcal(), this.zzmrc);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzkgb = remoteException;
                this.zzk(64, false);
                return;
            }
            this.zzmqy.zza(zzecp2, false);
            this.mResultCode = zzecp2.getResultCode();
            this.zzkgb = zzecp2.getException() != null ? zzecp2.getException() : this.zzkgb;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzkgb == null && this.zzcan() == 4;
            if (bl) {
                this.zzgft = zzecp2.zzcbh();
                object = zzecp2.zzqx("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzmrb != null && !this.zzmrb.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzmrc = 0L;
                    this.zzmrb = null;
                    zzecp2.zzcbb();
                    ((StorageTask)this).schedule();
                    return;
                }
                this.zzmrb = object;
                try {
                    bl = this.zza(zzecp2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzkgb = iOException;
                }
            }
            zzecp2.zzcbb();
            if (bl && this.zzkgb == null && this.zzcan() == 4) {
                this.zzk(128, false);
                return;
            }
            object = new File(this.zzmqz.getPath());
            this.zzmrc = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzcan() == 8) {
                this.zzk(16, false);
                return;
            }
            if (this.zzcan() != 32) continue;
            if (!this.zzk(256, false)) {
                int n2 = this.zzcan();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzmra > 0L);
        this.zzk(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzmqy.cancel();
        this.zzkgb = StorageException.fromErrorStatus(Status.zzfht);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcah() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzkgb, fileDownloadTask.mResultCode)), fileDownloadTask.zzmra + fileDownloadTask.zzmrc);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzmra;
        private /* synthetic */ FileDownloadTask zzmrd;

        TaskSnapshot(@Nullable FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzmrd = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zzmra = l;
        }

        public long getBytesTransferred() {
            return this.zzmra;
        }

        public long getTotalByteCount() {
            return this.zzmrd.getTotalBytes();
        }
    }
}

