/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzece;
import com.google.android.gms.internal.zzecp;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import com.google.firebase.storage.zzw;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzmqw;
    private zzece zzmqy;
    private volatile Exception zzkgb = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzmtj;
    private long zzgft = -1L;
    private long zzmra;
    private long zzmtk;
    private InputStream zzksd;
    private zzecp zzmtl;
    private String zzmrb;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzmqw = storageReference;
        this.zzmqy = new zzece(this.zzmqw.getStorage().getApp(), this.zzmqw.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbp.zzu((Object)streamProcessor);
        zzbp.zzbg((this.zzmtj == null ? 1 : 0) != 0);
        this.zzmtj = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzmqw;
    }

    final long getTotalBytes() {
        return this.zzgft;
    }

    final void zzcm(long l) {
        this.zzmra += l;
        if (this.zzmtk + 262144L <= this.zzmra) {
            if (this.zzcan() == 4) {
                this.zzk(4, false);
                return;
            }
            this.zzmtk = this.zzmra;
        }
    }

    @Override
    protected void schedule() {
        zzu.zzr(this.zzbjc());
    }

    private final InputStream zzcas() throws Exception {
        this.zzmqy.reset();
        if (this.zzmtl != null) {
            this.zzmtl.zzcbb();
        }
        try {
            this.zzmtl = this.zzmqw.zzcak().zza(this.zzmqw.zzcal(), this.zzmra);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzmqy.zza(this.zzmtl, false);
        this.mResultCode = this.zzmtl.getResultCode();
        this.zzkgb = this.zzmtl.getException() != null ? this.zzmtl.getException() : this.zzkgb;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzkgb == null && this.zzcan() == 4) {
            String string = this.zzmtl.zzqx("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzmrb != null && !this.zzmrb.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzmrb = string;
            if (this.zzgft == -1L) {
                this.zzgft = this.zzmtl.zzcbh();
            }
            return this.zzmtl.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzkgb != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzw(this), this);
        this.zzksd = new BufferedInputStream(zza2);
        try {
            zza2.zzcau();
            if (this.zzmtj != null) {
                try {
                    this.zzmtj.doInBackground((TaskSnapshot)this.zzcao(), this.zzksd);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzkgb = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzkgb = iOException;
        }
        if (this.zzksd == null) {
            this.zzmtl.zzcbb();
            this.zzmtl = null;
        }
        if (this.zzkgb == null && this.zzcan() == 4) {
            this.zzk(4, false);
            this.zzk(128, false);
            return;
        }
        if (!this.zzk(this.zzcan() == 32 ? 256 : 64, false)) {
            int n = this.zzcan();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzmqy.cancel();
        this.zzkgb = StorageException.fromErrorStatus(Status.zzfht);
    }

    @Override
    protected void onProgress() {
        this.zzmtk = this.zzmra;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcah() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzkgb, streamDownloadTask.mResultCode)), streamDownloadTask.zzmtk);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzcas();
    }

    static /* synthetic */ zzecp zza(StreamDownloadTask streamDownloadTask, zzecp zzecp2) {
        streamDownloadTask.zzmtl = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzmra;
        private /* synthetic */ StreamDownloadTask zzmtm;

        TaskSnapshot(@Nullable StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzmtm = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzmra = l;
        }

        public long getBytesTransferred() {
            return this.zzmra;
        }

        public long getTotalByteCount() {
            return this.zzmtm.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzmtm.zzksd;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzmtn;
        @Nullable
        private InputStream zzmto;
        private Callable<InputStream> zzmtp;
        private IOException zzmtq;
        private int zzmtr;
        private int zzmts;
        private boolean zzmtt;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzmtn = streamDownloadTask;
            this.zzmtp = callable;
        }

        private final void zzcat() throws IOException {
            if (this.zzmtn != null && this.zzmtn.zzcan() == 32) {
                throw new com.google.firebase.storage.zza();
            }
        }

        private final void zzcm(long l) {
            if (this.zzmtn != null) {
                this.zzmtn.zzcm(l);
            }
            this.zzmtr = (int)((long)this.zzmtr + l);
        }

        private final boolean zzcau() throws IOException {
            this.zzcat();
            if (this.zzmtq != null) {
                try {
                    if (this.zzmto != null) {
                        this.zzmto.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzmto = null;
                if (this.zzmts == this.zzmtr) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzmtq);
                    return false;
                }
                int n = this.zzmtr;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzmtq);
                this.zzmts = this.zzmtr;
                this.zzmtq = null;
            }
            if (this.zzmtt) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzmto == null) {
                try {
                    this.zzmto = this.zzmtp.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzcau()) {
                try {
                    int n = this.zzmto.read();
                    if (n != -1) {
                        this.zzcm(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzmtq = iOException;
                }
            }
            throw this.zzmtq;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzcau()) {
                try {
                    return this.zzmto.available();
                }
                catch (IOException iOException) {
                    this.zzmtq = iOException;
                }
            }
            throw this.zzmtq;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzmto != null) {
                this.zzmto.close();
            }
            this.zzmtt = true;
            if (this.zzmtn != null && this.zzmtn.zzmtl != null) {
                this.zzmtn.zzmtl.zzcbb();
                StreamDownloadTask.zza(this.zzmtn, null);
            }
            this.zzcat();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzcau()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzmto.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzcm(n4);
                        this.zzcat();
                    }
                    if (n2 > 0) {
                        n4 = this.zzmto.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzcm(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzmtq = iOException;
                }
            }
            throw this.zzmtq;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzcau()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzmto.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcm(l2);
                        this.zzcat();
                    }
                    if (l > 0L) {
                        l2 = this.zzmto.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcm(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzmtq = iOException;
                }
            }
            throw this.zzmtq;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

