/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzecd;
import com.google.android.gms.internal.zzece;
import com.google.android.gms.internal.zzecj;
import com.google.android.gms.internal.zzecp;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzad;
import com.google.firebase.storage.zzu;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzmqw;
    private final Uri mUri;
    private final long zzmue;
    private final zzecd zzmuf;
    private final AtomicLong zzmug;
    private int zzmuh;
    private zzece zzmqy;
    private boolean zzmui;
    private volatile StorageMetadata zzmsd;
    private volatile Uri zzmuj;
    private volatile Exception zzkgb;
    private volatile Exception zzmuk;
    private volatile int mResultCode;
    private volatile String zzmul;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzmug = new AtomicLong(0L);
        this.zzmuh = 262144;
        this.zzmuj = null;
        this.zzkgb = null;
        this.zzmuk = null;
        this.mResultCode = 0;
        zzbp.zzu((Object)storageReference);
        zzbp.zzu((Object)byArray);
        this.zzmue = byArray.length;
        this.zzmqw = storageReference;
        this.zzmsd = storageMetadata;
        this.mUri = null;
        this.zzmuf = new zzecd(new ByteArrayInputStream(byArray), 262144);
        this.zzmui = true;
        this.zzmqy = new zzece(this.zzmqw.getStorage().getApp(), this.zzmqw.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzmug = new AtomicLong(0L);
            this.zzmuh = 262144;
            this.zzmuj = null;
            this.zzkgb = null;
            this.zzmuk = null;
            this.mResultCode = 0;
            zzbp.zzu((Object)storageReference);
            zzbp.zzu((Object)uri);
            this.zzmqw = storageReference;
            this.zzmsd = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzmqy = new zzece(this.zzmqw.getStorage().getApp(), this.zzmqw.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzmqw.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzkgb = fileNotFoundException;
            }
        }
        this.zzmue = l;
        this.zzmuf = new zzecd(inputStream, 262144);
        this.zzmui = true;
        this.zzmuj = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzmug = new AtomicLong(0L);
        this.zzmuh = 262144;
        this.zzmuj = null;
        this.zzkgb = null;
        this.zzmuk = null;
        this.mResultCode = 0;
        zzbp.zzu((Object)storageReference);
        zzbp.zzu((Object)inputStream);
        this.zzmue = -1L;
        this.zzmqw = storageReference;
        this.zzmsd = storageMetadata;
        this.zzmuf = new zzecd(inputStream, 262144);
        this.zzmui = false;
        this.mUri = null;
        this.zzmqy = new zzece(this.zzmqw.getStorage().getApp(), this.zzmqw.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzmqw;
    }

    final long getTotalByteCount() {
        return this.zzmue;
    }

    @Override
    protected void schedule() {
        zzu.zzq(this.zzbjc());
    }

    @Override
    final void run() {
        zzecp zzecp2;
        UploadTask uploadTask;
        block24: {
            this.zzmqy.reset();
            if (!this.zzk(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzmqw.getParent() == null) {
                this.zzkgb = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzkgb != null) {
                return;
            }
            if (this.zzmuj == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzmsd != null) {
                    string2 = uploadTask.zzmsd.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzmqw.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    zzecp2 = uploadTask.zzmqw.zzcak().zza(uploadTask.zzmqw.zzcal(), uploadTask.zzmsd != null ? uploadTask.zzmsd.zzcai() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzkgb = throwable;
                    break block24;
                }
                if (uploadTask.zzc(zzecp2) && !TextUtils.isEmpty((CharSequence)(string = zzecp2.zzqx("X-Goog-Upload-URL")))) {
                    uploadTask.zzmuj = Uri.parse((String)string);
                }
            } else {
                this.zzcl(false);
            }
        }
        boolean bl = this.zzcaw();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzmuf.zzge(uploadTask.zzmuh);
                    int n = Math.min(uploadTask.zzmuh, uploadTask.zzmuf.available());
                    try {
                        zzecp2 = uploadTask.zzmqw.zzcak().zza(uploadTask.zzmqw.zzcal(), uploadTask.zzmuj.toString(), uploadTask.zzmuf.zzcba(), uploadTask.zzmug.get(), n, uploadTask.zzmuf.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzkgb = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(zzecp2)) {
                        int n2 = uploadTask.zzmuh = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzmug.getAndAdd(n);
                    if (!uploadTask.zzmuf.isFinished()) {
                        uploadTask.zzmuf.zzgd(n);
                        if (uploadTask.zzmuh < 0x2000000) {
                            uploadTask.zzmuh <<= 1;
                            int n3 = uploadTask.zzmuh;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzmsd = new StorageMetadata.Builder(zzecp2.zzcbj(), uploadTask.zzmqw).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(zzecp2.zzcbe());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzkgb = throwable;
                        break block25;
                    }
                    uploadTask.zzk(4, false);
                    uploadTask.zzk(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzkgb = iOException;
                }
            }
            if (!(bl = this.zzcaw())) continue;
            this.zzk(4, false);
        }
        if (this.zzmui && this.zzcan() != 16) {
            try {
                this.zzmuf.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzkgb = null;
        this.zzmuk = null;
        this.mResultCode = 0;
        this.zzmul = null;
    }

    private final boolean zzcaw() {
        if (this.zzcan() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzkgb = new InterruptedException();
            this.zzk(64, false);
            return false;
        }
        if (this.zzcan() == 32) {
            this.zzk(256, false);
            return false;
        }
        if (this.zzcan() == 8) {
            this.zzk(16, false);
            return false;
        }
        if (!this.zzcax()) {
            return false;
        }
        if (this.zzmuj == null) {
            if (this.zzkgb == null) {
                this.zzkgb = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzk(64, false);
            return false;
        }
        if (this.zzkgb != null) {
            this.zzk(64, false);
            return false;
        }
        if ((this.zzmuk != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzcl(true)) {
            if (this.zzcax()) {
                this.zzk(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzcax() {
        if ("final".equals(this.zzmul)) {
            if (this.zzkgb == null) {
                this.zzkgb = new IOException("The server has terminated the upload session");
            }
            this.zzk(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzcl(boolean bl) {
        zzecp zzecp2;
        try {
            zzecp2 = this.zzmqw.zzcak().zzb(this.zzmqw.zzcal(), this.zzmuj.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzkgb = remoteException;
            return false;
        }
        if ("final".equals(this.zzmul)) {
            return false;
        }
        if (bl ? !this.zzc(zzecp2) : !this.zzb(zzecp2)) {
            return false;
        }
        if ("final".equals(zzecp2.zzqx("X-Goog-Upload-Status"))) {
            this.zzkgb = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzecp2.zzqx("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzmug.get();
        if (l2 > l) {
            this.zzkgb = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzmuf.zzgd((int)(l - l2)) != l - l2) {
                    this.zzkgb = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzmug.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzkgb = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzkgb = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(zzecp zzecp2) {
        zzecp2.zze(zzecj.zzf(this.zzmqw.getStorage().getApp()), this.zzmqw.getStorage().getApp().getApplicationContext());
        return this.zzd(zzecp2);
    }

    private final boolean zzc(zzecp zzecp2) {
        zzecp zzecp3 = zzecp2;
        this.zzmqy.zza(zzecp3, true);
        return this.zzd(zzecp2);
    }

    private final boolean zzd(zzecp zzecp2) {
        int n = zzecp2.getResultCode();
        this.mResultCode = zzece.zzgg(n) ? -2 : n;
        this.zzmuk = zzecp2.getException();
        this.zzmul = zzecp2.zzqx("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzmuk == null;
    }

    @Override
    protected void onCanceled() {
        this.zzmqy.cancel();
        zzecp zzecp2 = null;
        if (this.zzmuj != null) {
            try {
                zzecp2 = this.zzmqw.zzcak().zza(this.zzmqw.zzcal(), this.zzmuj.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzecp2 != null) {
            zzecp zzecp3 = zzecp2;
            zzu.zzp(new zzad(this, zzecp3));
        }
        this.zzkgb = StorageException.fromErrorStatus(Status.zzfht);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcah() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzkgb != null ? uploadTask.zzkgb : uploadTask.zzmuk;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzmug.get(), uploadTask.zzmuj, uploadTask.zzmsd);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzmqw;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzmuo;
        private final Uri zzmuj;
        private final StorageMetadata zzmsd;
        private /* synthetic */ UploadTask zzmun;

        TaskSnapshot(@Nullable UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzmun = uploadTask;
            super(uploadTask, exception);
            this.zzmuo = l;
            this.zzmuj = uri;
            this.zzmsd = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzmuo;
        }

        public long getTotalByteCount() {
            return this.zzmun.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzmuj;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzmsd;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

