/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzeck;
import com.google.android.gms.internal.zzecv;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import com.google.firebase.storage.zzw;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzmtj;
    private zzeck zzmtl;
    private volatile Exception zzkgm = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzmvw;
    private long zzggc = -1L;
    private long zzmtn;
    private long zzmvx;
    private InputStream zzkuj;
    private zzecv zzmvy;
    private String zzmto;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzmtj = storageReference;
        this.zzmtl = new zzeck(this.zzmtj.getStorage().getApp(), this.zzmtj.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbp.zzu((Object)streamProcessor);
        zzbp.zzbg((this.zzmvw == null ? 1 : 0) != 0);
        this.zzmvw = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzmtj;
    }

    final long getTotalBytes() {
        return this.zzggc;
    }

    final void zzcm(long l) {
        this.zzmtn += l;
        if (this.zzmvx + 262144L <= this.zzmtn) {
            if (this.zzcaq() == 4) {
                this.zzk(4, false);
                return;
            }
            this.zzmvx = this.zzmtn;
        }
    }

    @Override
    protected void schedule() {
        zzu.zzr(this.zzbjf());
    }

    private final InputStream zzcav() throws Exception {
        this.zzmtl.reset();
        if (this.zzmvy != null) {
            this.zzmvy.zzcbe();
        }
        try {
            this.zzmvy = this.zzmtj.zzcan().zza(this.zzmtj.zzcao(), this.zzmtn);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzmtl.zza(this.zzmvy, false);
        this.mResultCode = this.zzmvy.getResultCode();
        this.zzkgm = this.zzmvy.getException() != null ? this.zzmvy.getException() : this.zzkgm;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzkgm == null && this.zzcaq() == 4) {
            String string = this.zzmvy.zzrh("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzmto != null && !this.zzmto.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzmto = string;
            if (this.zzggc == -1L) {
                this.zzggc = this.zzmvy.zzcbk();
            }
            return this.zzmvy.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzkgm != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzw(this), this);
        this.zzkuj = new BufferedInputStream(zza2);
        try {
            zza2.zzcax();
            if (this.zzmvw != null) {
                try {
                    this.zzmvw.doInBackground((TaskSnapshot)this.zzcar(), this.zzkuj);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzkgm = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzkgm = iOException;
        }
        if (this.zzkuj == null) {
            this.zzmvy.zzcbe();
            this.zzmvy = null;
        }
        if (this.zzkgm == null && this.zzcaq() == 4) {
            this.zzk(4, false);
            this.zzk(128, false);
            return;
        }
        if (!this.zzk(this.zzcaq() == 32 ? 256 : 64, false)) {
            int n = this.zzcaq();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzmtl.cancel();
        this.zzkgm = StorageException.fromErrorStatus(Status.zzfhy);
    }

    @Override
    protected void onProgress() {
        this.zzmvx = this.zzmtn;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcak() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzkgm, streamDownloadTask.mResultCode)), streamDownloadTask.zzmvx);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzcav();
    }

    static /* synthetic */ zzecv zza(StreamDownloadTask streamDownloadTask, zzecv zzecv2) {
        streamDownloadTask.zzmvy = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzmtn;
        private /* synthetic */ StreamDownloadTask zzmvz;

        TaskSnapshot(@Nullable StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzmvz = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzmtn = l;
        }

        public long getBytesTransferred() {
            return this.zzmtn;
        }

        public long getTotalByteCount() {
            return this.zzmvz.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzmvz.zzkuj;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzmwa;
        @Nullable
        private InputStream zzmwb;
        private Callable<InputStream> zzmwc;
        private IOException zzmwd;
        private int zzmwe;
        private int zzmwf;
        private boolean zzmwg;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzmwa = streamDownloadTask;
            this.zzmwc = callable;
        }

        private final void zzcaw() throws IOException {
            if (this.zzmwa != null && this.zzmwa.zzcaq() == 32) {
                throw new com.google.firebase.storage.zza();
            }
        }

        private final void zzcm(long l) {
            if (this.zzmwa != null) {
                this.zzmwa.zzcm(l);
            }
            this.zzmwe = (int)((long)this.zzmwe + l);
        }

        private final boolean zzcax() throws IOException {
            this.zzcaw();
            if (this.zzmwd != null) {
                try {
                    if (this.zzmwb != null) {
                        this.zzmwb.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzmwb = null;
                if (this.zzmwf == this.zzmwe) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzmwd);
                    return false;
                }
                int n = this.zzmwe;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzmwd);
                this.zzmwf = this.zzmwe;
                this.zzmwd = null;
            }
            if (this.zzmwg) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzmwb == null) {
                try {
                    this.zzmwb = this.zzmwc.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzcax()) {
                try {
                    int n = this.zzmwb.read();
                    if (n != -1) {
                        this.zzcm(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzmwd = iOException;
                }
            }
            throw this.zzmwd;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzcax()) {
                try {
                    return this.zzmwb.available();
                }
                catch (IOException iOException) {
                    this.zzmwd = iOException;
                }
            }
            throw this.zzmwd;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzmwb != null) {
                this.zzmwb.close();
            }
            this.zzmwg = true;
            if (this.zzmwa != null && this.zzmwa.zzmvy != null) {
                this.zzmwa.zzmvy.zzcbe();
                StreamDownloadTask.zza(this.zzmwa, null);
            }
            this.zzcaw();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzcax()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzmwb.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzcm(n4);
                        this.zzcaw();
                    }
                    if (n2 > 0) {
                        n4 = this.zzmwb.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzcm(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzmwd = iOException;
                }
            }
            throw this.zzmwd;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzcax()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzmwb.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcm(l2);
                        this.zzcaw();
                    }
                    if (l > 0L) {
                        l2 = this.zzmwb.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcm(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzmwd = iOException;
                }
            }
            throw this.zzmwd;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

