/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzemy;
import com.google.android.gms.internal.zzemz;
import com.google.android.gms.internal.zzenb;
import com.google.firebase.FirebaseApp;
import org.json.JSONObject;

public final class zzena {
    private static final Object zznro = new Object();
    private static volatile zzena zznrp;
    private zzemy zznrq;
    private Context mContext;
    private FirebaseApp zznfk;

    private zzena(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        this.mContext = firebaseApp.getApplicationContext();
        this.zznfk = firebaseApp;
        try {
            IInterface iInterface;
            DynamiteModule dynamiteModule = DynamiteModule.zza((Context)this.mContext, (DynamiteModule.zzd)DynamiteModule.zzgps, (String)"com.google.android.gms.firebasestorage");
            IBinder iBinder = dynamiteModule.zzgv("com.google.firebase.storage.network.NetworkRequestFactoryImpl");
            this.zznrq = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.firebase.storage.network.INetworkRequestFactory")) instanceof zzemy ? (zzemy)iInterface : new zzemz(iBinder));
        }
        catch (DynamiteModule.zzc zzc2) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"NetworkRequestFactoryProxy failed with a RemoteException:", (Throwable)zzc2);
            throw new RemoteException();
        }
        if (this.zznrq == null) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"Unable to load Firebase Storage Network layer.");
            throw new RemoteException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzena zzh(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        if (zznrp == null) {
            Object object = zznro;
            synchronized (object) {
                if (zznrp == null) {
                    zznrp = new zzena(firebaseApp);
                }
            }
        }
        return zznrp;
    }

    private final zzenb zze(zzenb zzenb2) {
        zzenb2.zzbp("x-firebase-gmpid", this.zznfk.getOptions().getApplicationId());
        return zzenb2;
    }

    @NonNull
    public final zzenb zzv(Uri uri) throws RemoteException {
        return this.zze(new zzenb(this.zznrq.zza(uri, zzn.zzw((Object)this.mContext))));
    }

    @NonNull
    public final zzenb zzw(Uri uri) throws RemoteException {
        return this.zze(new zzenb(this.zznrq.zzb(uri, zzn.zzw((Object)this.mContext))));
    }

    @NonNull
    public final zzenb zza(Uri uri, long l) throws RemoteException {
        return this.zze(new zzenb(this.zznrq.zza(uri, zzn.zzw((Object)this.mContext), l)));
    }

    @NonNull
    public final zzenb zza(Uri uri, String string, byte[] byArray, long l, int n, boolean bl) throws RemoteException {
        return this.zze(new zzenb(this.zznrq.zza(uri, zzn.zzw((Object)this.mContext), string, zzn.zzw((Object)byArray), l, n, bl)));
    }

    @Nullable
    public final zzenb zza(Uri uri, String string) throws RemoteException {
        return this.zze(new zzenb(this.zznrq.zza(uri, zzn.zzw((Object)this.mContext), string)));
    }

    @NonNull
    public final zzenb zzb(Uri uri, String string) throws RemoteException {
        return this.zze(new zzenb(this.zznrq.zzb(uri, zzn.zzw((Object)this.mContext), string)));
    }

    @NonNull
    public final zzenb zza(Uri uri, JSONObject jSONObject, String string) throws RemoteException {
        return this.zze(new zzenb(this.zznrq.zza(uri, zzn.zzw((Object)this.mContext), zzn.zzw((Object)jSONObject), string)));
    }

    @NonNull
    public final zzenb zza(Uri uri, JSONObject jSONObject) throws RemoteException {
        return this.zze(new zzenb(this.zznrq.zza(uri, zzn.zzw((Object)this.mContext), zzn.zzw((Object)jSONObject))));
    }

    @Nullable
    public final String zzcix() {
        try {
            return this.zznrq.zzcix();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getBackendAuthority failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @Nullable
    public final String zzu(Uri uri) {
        try {
            return this.zznrq.zzu(uri);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getDefaultURL failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }
}

