/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzemw;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class zzenb {
    private zzemw zznrr;
    private Exception zzkgm;
    private int zznrs;
    private Exception zznrt;

    public zzenb(@NonNull zzemw zzemw2) {
        this.zznrr = zzemw2;
    }

    public final void zzbp(String string, String string2) {
        try {
            this.zznrr.zzbp(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzsd(String string) {
        try {
            return this.zznrr.zzsd(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            zzenb zzenb2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                zzenb2.zznrs = -2;
                zzenb2.zznrt = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zznrr.zzsb(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zznrs = 0;
            this.zznrt = null;
            this.zznrr.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzsc(@Nullable String string) {
        try {
            this.zznrr.zzsc(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzciq() {
        try {
            if (this.zznrr != null) {
                this.zznrr.zzciq();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzx((IObjectWrapper)this.zznrr.zzcir());
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzciy() throws RemoteException {
        return (JSONObject)zzn.zzx((IObjectWrapper)this.zznrr.zzcis());
    }

    @Nullable
    public final String zzcit() {
        try {
            this.zznrr.zzcit();
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zznrt != null) {
                return this.zznrt;
            }
            if (this.zzkgm != null) {
                return this.zzkgm;
            }
            return (Exception)zzn.zzx((IObjectWrapper)this.zznrr.zzciu());
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zznrs != 0) {
                return this.zznrs;
            }
            return this.zznrr.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzciv() {
        try {
            if (this.zznrs == -2 || this.zznrt != null) {
                return false;
            }
            return this.zznrr.zzciv();
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzciv() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzciw() {
        try {
            return this.zznrr.zzciw();
        }
        catch (RemoteException remoteException) {
            this.zzkgm = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

