/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzemr;
import com.google.android.gms.internal.zzemv;
import com.google.android.gms.internal.zzena;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzd;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zznob = null;
    private StorageReference zznnj = null;
    private String zznoc = null;
    private String zznod = null;
    private zza<String> zznoe = zza.zzcb("");
    private String zznof = null;
    private String zznog = null;
    private String zznoh = null;
    private long zznoi;
    private String zznoj = null;
    private zza<String> zznok = zza.zzcb("");
    private zza<String> zznol = zza.zzcb("");
    private zza<String> zznom = zza.zzcb("");
    private zza<String> zznon = zza.zzcb("");
    private zza<Map<String, String>> zznoo = zza.zzcb(Collections.emptyMap());
    private String[] zznop = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbp.zzu((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zznob = storageMetadata.zznob;
        this.zznnj = storageMetadata.zznnj;
        this.zznoc = storageMetadata.zznoc;
        this.zznoe = storageMetadata.zznoe;
        this.zznok = storageMetadata.zznok;
        this.zznol = storageMetadata.zznol;
        this.zznom = storageMetadata.zznom;
        this.zznon = storageMetadata.zznon;
        this.zznoo = storageMetadata.zznoo;
        this.zznop = storageMetadata.zznop;
        if (bl) {
            this.zznoj = storageMetadata.zznoj;
            this.zznoi = storageMetadata.zznoi;
            this.zznoh = storageMetadata.zznoh;
            this.zznog = storageMetadata.zznog;
            this.zznof = storageMetadata.zznof;
            this.zznod = storageMetadata.zznod;
        }
    }

    public String getContentType() {
        return this.zznoe.getValue();
    }

    public String getCustomMetadata(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zznoo.getValue().get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        return this.zznoo.getValue().keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zznoc;
    }

    @Nullable
    public String getGeneration() {
        return this.zznod;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zznof;
    }

    public long getCreationTimeMillis() {
        return zzemv.zzsa(this.zznog);
    }

    public long getUpdatedTimeMillis() {
        return zzemv.zzsa(this.zznoh);
    }

    public long getSizeBytes() {
        return this.zznoi;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zznoj;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zznop != null && this.zznnj != null) {
            try {
                String string = zzena.zzh(this.zznnj.getStorage().getApp()).zzu(this.zznnj.zzcia());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zznop;
                    int n = this.zznop.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zznok.getValue();
    }

    @Nullable
    public String getContentDisposition() {
        return this.zznol.getValue();
    }

    @Nullable
    public String getContentEncoding() {
        return this.zznom.getValue();
    }

    @Nullable
    public String getContentLanguage() {
        return this.zznon.getValue();
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zznnj == null && this.zznob != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzemr.zzrx((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zznob);
        }
        return this.zznnj;
    }

    @NonNull
    final JSONObject zzchx() throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.zznoe.zzchy()) {
            hashMap.put("contentType", this.getContentType());
        }
        if (this.zznoo.zzchy()) {
            hashMap.put("metadata", (String)new JSONObject(this.zznoo.getValue()));
        }
        if (this.zznok.zzchy()) {
            hashMap.put("cacheControl", this.getCacheControl());
        }
        if (this.zznol.zzchy()) {
            hashMap.put("contentDisposition", this.getContentDisposition());
        }
        if (this.zznom.zzchy()) {
            hashMap.put("contentEncoding", this.getContentEncoding());
        }
        if (this.zznon.zzchy()) {
            hashMap.put("contentLanguage", this.getContentLanguage());
        }
        return new JSONObject(hashMap);
    }

    private final void zzrw(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zznop = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzd zzd2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zznoq;
        private boolean zznor;

        public Builder() {
            this.zznoq = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zznoq = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zznoq.zznnj = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zznoq = new StorageMetadata();
            if (jSONObject != null) {
                this.zzt(jSONObject);
                this.zznor = true;
            }
        }

        @Nullable
        private static String zze(JSONObject jSONObject, String string) throws JSONException {
            if (jSONObject.has(string) && !jSONObject.isNull(string)) {
                return jSONObject.getString(string);
            }
            return null;
        }

        private final void zzt(JSONObject jSONObject) throws JSONException {
            String string;
            this.zznoq.zznod = jSONObject.optString("generation");
            this.zznoq.mPath = jSONObject.optString("name");
            this.zznoq.zznoc = jSONObject.optString("bucket");
            this.zznoq.zznof = jSONObject.optString("metageneration");
            this.zznoq.zznog = jSONObject.optString("timeCreated");
            this.zznoq.zznoh = jSONObject.optString("updated");
            this.zznoq.zznoi = jSONObject.optLong("size");
            this.zznoq.zznoj = jSONObject.optString("md5Hash");
            this.zznoq.zzrw(jSONObject.optString("downloadTokens"));
            if (jSONObject.has("metadata") && !jSONObject.isNull("metadata")) {
                string = jSONObject.getJSONObject("metadata");
                Iterator iterator = string.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.setCustomMetadata(string2, string.getString(string2));
                }
            }
            if ((string = Builder.zze(jSONObject, "contentType")) != null) {
                this.setContentType(string);
            }
            if ((string = Builder.zze(jSONObject, "cacheControl")) != null) {
                this.setCacheControl(string);
            }
            if ((string = Builder.zze(jSONObject, "contentDisposition")) != null) {
                this.setContentDisposition(string);
            }
            if ((string = Builder.zze(jSONObject, "contentEncoding")) != null) {
                this.setContentEncoding(string);
            }
            if ((string = Builder.zze(jSONObject, "contentLanguage")) != null) {
                this.setContentLanguage(string);
            }
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zznoq, this.zznor, null);
        }

        public Builder setContentLanguage(@Nullable String string) {
            this.zznoq.zznon = zza.zzcc(string);
            return this;
        }

        public Builder setContentEncoding(@Nullable String string) {
            this.zznoq.zznom = zza.zzcc(string);
            return this;
        }

        public Builder setContentDisposition(@Nullable String string) {
            this.zznoq.zznol = zza.zzcc(string);
            return this;
        }

        public Builder setCacheControl(@Nullable String string) {
            this.zznoq.zznok = zza.zzcc(string);
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (!this.zznoq.zznoo.zzchy()) {
                this.zznoq.zznoo = zza.zzcc(new HashMap());
            }
            ((Map)this.zznoq.zznoo.getValue()).put(string, string2);
            return this;
        }

        public Builder setContentType(@Nullable String string) {
            this.zznoq.zznoe = zza.zzcc(string);
            return this;
        }
    }

    static final class zza<T> {
        private final boolean zznos;
        @Nullable
        private final T value;

        private zza(@Nullable T t, boolean bl) {
            this.zznos = bl;
            this.value = t;
        }

        static <T> zza<T> zzcb(T t) {
            return new zza<T>(t, false);
        }

        static <T> zza<T> zzcc(@Nullable T t) {
            return new zza<T>(t, true);
        }

        final boolean zzchy() {
            return this.zznos;
        }

        @Nullable
        final T getValue() {
            return this.value;
        }
    }
}

