/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.CancellableTask;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzj;
import com.google.firebase.storage.zzk;
import com.google.firebase.storage.zzl;
import com.google.firebase.storage.zzm;
import com.google.firebase.storage.zzn;
import com.google.firebase.storage.zzo;
import com.google.firebase.storage.zzp;
import com.google.firebase.storage.zzs;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzx;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zznoy = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zznoz = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    private zzx<OnSuccessListener<? super TResult>, TResult> zznpa = new zzx(this, 128, new zzj(this));
    @VisibleForTesting
    private zzx<OnFailureListener, TResult> zznpb = new zzx(this, 320, new zzk(this));
    @VisibleForTesting
    private zzx<OnCompleteListener<TResult>, TResult> zznpc = new zzx(this, 448, new zzl(this));
    @VisibleForTesting
    private zzx<OnProgressListener<? super TResult>, TResult> zznpd = new zzx(this, -465, new zzm(this));
    @VisibleForTesting
    private zzx<OnPausedListener<? super TResult>, TResult> zznpe = new zzx(this, 16, new zzn(this));
    private volatile int zzcfj = 1;
    private TResult zznpf;

    protected StorageTask() {
    }

    @VisibleForTesting
    final boolean zzcib() {
        if (this.zzk(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzk(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zza(new int[]{16, 8}, true);
    }

    @Override
    public boolean cancel() {
        return this.zza(new int[]{256, 32}, true);
    }

    public boolean isComplete() {
        return (this.zzcfj & 0x80) != 0 || (this.zzcfj & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzcfj & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzcfj == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzcfj & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzcfj & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zzcie() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zzcie().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzcie();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zzcie() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zzcie().getError())) {
            throw (Throwable)clazz.cast(this.zzcie().getError());
        }
        Exception exception = this.zzcie().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzcie();
    }

    @Nullable
    public Exception getException() {
        if (this.zzcie() == null) {
            return null;
        }
        return this.zzcie().getError();
    }

    public TResult getSnapshot() {
        return this.zzcid();
    }

    @VisibleForTesting
    final int zzcic() {
        return this.zzcfj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    final TResult zzcid() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzchw();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult zzchw();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zza(int[] nArray, boolean bl) {
        HashMap<Integer, HashSet<Integer>> hashMap = bl ? zznoy : zznoz;
        Object object = this.mSyncObject;
        synchronized (object) {
            Object object2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = object2[i];
                HashSet<Integer> hashSet = hashMap.get(this.zzcfj);
                if (hashSet == null || !hashSet.contains(n2)) continue;
                this.zzcfj = n2;
                switch (this.zzcfj) {
                    case 2: {
                        zzt.zzcig().zzb(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zznpa.zzcik();
                this.zznpb.zzcik();
                this.zznpc.zzcik();
                this.zznpe.zzcik();
                this.zznpd.zzcik();
                if (Log.isLoggable((String)"StorageTask", (int)3)) {
                    String string = StorageTask.zzhq(n2);
                    String string2 = StorageTask.zzhq(this.zzcfj);
                    Log.d((String)"StorageTask", (String)new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string2).length()).append("changed internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
                }
                return true;
            }
            object2 = StorageTask.zzf(nArray);
            String string = StorageTask.zzhq(this.zzcfj);
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(object2).length() + String.valueOf(string).length()).append("unable to change internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append(string).toString());
            return false;
        }
    }

    @VisibleForTesting
    final boolean zzk(int n, boolean bl) {
        return this.zza(new int[]{n}, bl);
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private final TResult zzcie() {
        if (this.zznpf != null) {
            return this.zznpf;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zznpf == null) {
            this.zznpf = this.zzcid();
        }
        return this.zznpf;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        this.zznpe.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        zzbp.zzu((Object)executor);
        this.zznpe.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        zzbp.zzu((Object)activity);
        this.zznpe.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbp.zzu(onPausedListener);
        this.zznpe.zzcd(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        this.zznpd.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        zzbp.zzu((Object)executor);
        this.zznpd.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        zzbp.zzu((Object)activity);
        this.zznpd.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbp.zzu(onProgressListener);
        this.zznpd.zzcd(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu(onSuccessListener);
        this.zznpa.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu((Object)executor);
        zzbp.zzu(onSuccessListener);
        this.zznpa.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu((Object)activity);
        zzbp.zzu(onSuccessListener);
        this.zznpa.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbp.zzu(onSuccessListener);
        this.zznpa.zzcd(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        this.zznpb.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        zzbp.zzu((Object)executor);
        this.zznpb.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        zzbp.zzu((Object)activity);
        this.zznpb.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbp.zzu((Object)onFailureListener);
        this.zznpb.zzcd(onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        this.zznpc.zza(null, null, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        zzbp.zzu((Object)executor);
        this.zznpc.zza(null, executor, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        zzbp.zzu((Object)activity);
        this.zznpc.zza(activity, null, onCompleteListener);
        return this;
    }

    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbp.zzu(onCompleteListener);
        this.zznpc.zzcd(onCompleteListener);
        return this;
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zza(@Nullable Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zznpc.zza(null, executor, new zzo(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zzb(@Nullable Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zznpc.zza(null, executor, new zzp(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    final Runnable zzbje() {
        return new zzs(this);
    }

    private final void zzcif() {
        if (!(this.isComplete() || ((ControllableTask)this).isPaused() || this.zzcfj == 2 || this.zzk(256, false))) {
            this.zzk(64, false);
        }
    }

    private static String zzf(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            stringBuilder.append(StorageTask.zzhq(n2)).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private static String zzhq(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static /* synthetic */ void zza(StorageTask storageTask) {
        storageTask.zzcif();
    }

    static {
        zznoy.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zznoy.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zznoy.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zznoy.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zznoy.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zznoz.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        zznoz.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zznoz.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zznoz.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zznoz.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    public class SnapshotBase
    implements ProvideError {
        private final Exception zznpj;
        private /* synthetic */ StorageTask zznpg;

        public SnapshotBase(@Nullable StorageTask storageTask, Exception exception) {
            this.zznpg = storageTask;
            if (exception == null) {
                if (((CancellableTask)storageTask).isCanceled()) {
                    this.zznpj = StorageException.fromErrorStatus(Status.zzfhz);
                    return;
                }
                if (storageTask.zzcic() == 64) {
                    this.zznpj = StorageException.fromErrorStatus(Status.zzfhx);
                    return;
                }
                this.zznpj = null;
                return;
            }
            this.zznpj = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return this.zznpg;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zznpj;
        }
    }

    public static interface ProvideError {
        public Exception getError();
    }
}

