/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzenb;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import com.google.firebase.storage.zzw;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zznnj;
    private zzemq zznnl;
    private volatile Exception zzkgm = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zznpw;
    private long zzggd = -1L;
    private long zznnn;
    private long zznpx;
    private InputStream zzkuj;
    private zzenb zznpy;
    private String zznno;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zznnj = storageReference;
        this.zznnl = new zzemq(this.zznnj.getStorage().getApp(), this.zznnj.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbp.zzu((Object)streamProcessor);
        zzbp.zzbg((this.zznpw == null ? 1 : 0) != 0);
        this.zznpw = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zznnj;
    }

    final long getTotalBytes() {
        return this.zzggd;
    }

    final void zzcn(long l) {
        this.zznnn += l;
        if (this.zznpx + 262144L <= this.zznnn) {
            if (this.zzcic() == 4) {
                this.zzk(4, false);
                return;
            }
            this.zznpx = this.zznnn;
        }
    }

    @Override
    protected void schedule() {
        zzu.zzs(this.zzbje());
    }

    private final InputStream zzcih() throws Exception {
        this.zznnl.reset();
        if (this.zznpy != null) {
            this.zznpy.zzciq();
        }
        try {
            this.zznpy = this.zznnj.zzchz().zza(this.zznnj.zzcia(), this.zznnn);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zznnl.zza(this.zznpy, false);
        this.mResultCode = this.zznpy.getResultCode();
        this.zzkgm = this.zznpy.getException() != null ? this.zznpy.getException() : this.zzkgm;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzkgm == null && this.zzcic() == 4) {
            String string = this.zznpy.zzsd("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zznno != null && !this.zznno.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zznno = string;
            if (this.zzggd == -1L) {
                this.zzggd = this.zznpy.zzciw();
            }
            return this.zznpy.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzkgm != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzw(this), this);
        this.zzkuj = new BufferedInputStream(zza2);
        try {
            zza2.zzcij();
            if (this.zznpw != null) {
                try {
                    this.zznpw.doInBackground((TaskSnapshot)this.zzcid(), this.zzkuj);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzkgm = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzkgm = iOException;
        }
        if (this.zzkuj == null) {
            this.zznpy.zzciq();
            this.zznpy = null;
        }
        if (this.zzkgm == null && this.zzcic() == 4) {
            this.zzk(4, false);
            this.zzk(128, false);
            return;
        }
        if (!this.zzk(this.zzcic() == 32 ? 256 : 64, false)) {
            int n = this.zzcic();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zznnl.cancel();
        this.zzkgm = StorageException.fromErrorStatus(Status.zzfhz);
    }

    @Override
    protected void onProgress() {
        this.zznpx = this.zznnn;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzchw() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzkgm, streamDownloadTask.mResultCode)), streamDownloadTask.zznpx);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzcih();
    }

    static /* synthetic */ zzenb zza(StreamDownloadTask streamDownloadTask, zzenb zzenb2) {
        streamDownloadTask.zznpy = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zznnn;
        private /* synthetic */ StreamDownloadTask zznpz;

        TaskSnapshot(@Nullable StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zznpz = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zznnn = l;
        }

        public long getBytesTransferred() {
            return this.zznnn;
        }

        public long getTotalByteCount() {
            return this.zznpz.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zznpz.zzkuj;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zznqa;
        @Nullable
        private InputStream zznqb;
        private Callable<InputStream> zznqc;
        private IOException zznqd;
        private int zznqe;
        private int zznqf;
        private boolean zznqg;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zznqa = streamDownloadTask;
            this.zznqc = callable;
        }

        private final void zzcii() throws IOException {
            if (this.zznqa != null && this.zznqa.zzcic() == 32) {
                throw new com.google.firebase.storage.zza();
            }
        }

        private final void zzcn(long l) {
            if (this.zznqa != null) {
                this.zznqa.zzcn(l);
            }
            this.zznqe = (int)((long)this.zznqe + l);
        }

        private final boolean zzcij() throws IOException {
            this.zzcii();
            if (this.zznqd != null) {
                try {
                    if (this.zznqb != null) {
                        this.zznqb.close();
                    }
                }
                catch (IOException iOException) {}
                this.zznqb = null;
                if (this.zznqf == this.zznqe) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zznqd);
                    return false;
                }
                int n = this.zznqe;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zznqd);
                this.zznqf = this.zznqe;
                this.zznqd = null;
            }
            if (this.zznqg) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zznqb == null) {
                try {
                    this.zznqb = this.zznqc.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzcij()) {
                try {
                    int n = this.zznqb.read();
                    if (n != -1) {
                        this.zzcn(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zznqd = iOException;
                }
            }
            throw this.zznqd;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzcij()) {
                try {
                    return this.zznqb.available();
                }
                catch (IOException iOException) {
                    this.zznqd = iOException;
                }
            }
            throw this.zznqd;
        }

        @Override
        public final void close() throws IOException {
            if (this.zznqb != null) {
                this.zznqb.close();
            }
            this.zznqg = true;
            if (this.zznqa != null && this.zznqa.zznpy != null) {
                this.zznqa.zznpy.zzciq();
                StreamDownloadTask.zza(this.zznqa, null);
            }
            this.zzcii();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzcij()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zznqb.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzcn(n4);
                        this.zzcii();
                    }
                    if (n2 > 0) {
                        n4 = this.zznqb.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzcn(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zznqd = iOException;
                }
            }
            throw this.zznqd;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzcij()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zznqb.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcn(l2);
                        this.zzcii();
                    }
                    if (l > 0L) {
                        l2 = this.zznqb.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcn(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zznqd = iOException;
                }
            }
            throw this.zznqd;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

