/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public final class zzewn {
    private static final Runtime zzohl = Runtime.getRuntime();
    private final InputStream zzohm;
    private byte[] buffer;
    private int zzohn;
    private boolean zzoho;
    private boolean zzohp;

    public zzewn(InputStream inputStream, int n) {
        this.zzohm = inputStream;
        this.buffer = new byte[262144];
        this.zzohn = 0;
        this.zzohp = true;
        this.zzoho = false;
    }

    public final int available() {
        return this.zzohn;
    }

    public final byte[] zzckg() {
        return this.buffer;
    }

    public final int zzib(int n) throws IOException {
        int n2;
        if (n <= this.zzohn) {
            this.zzohn -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzohn);
            n2 = n;
        } else {
            n2 = this.zzohn = 0;
            while (n2 < n) {
                long l = this.zzohm.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzohm.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public final int zzic(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzid(n));
        }
        while (this.zzohn < n) {
            int n2 = this.zzohm.read(this.buffer, this.zzohn, n - this.zzohn);
            if (n2 == -1) {
                this.zzoho = true;
                break;
            }
            this.zzohn += n2;
        }
        return this.zzohn;
    }

    private final int zzid(int n) {
        int n2 = Math.max(this.buffer.length << 1, n);
        if (this.zzohp && (long)(n2 + 262144) < zzohl.freeMemory()) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzohn);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzohp = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public final boolean isFinished() {
        return this.zzoho;
    }

    public final void close() throws IOException {
        this.zzohm.close();
    }
}

